// ===========================================================================
//	File:					CTitleBox.h
//  Version:				1.1 - Dec 5, 1994
//
//	Copyright (C)1994 Mike Shields. All rights reserved.
// ===========================================================================
//	CTitleBox.cp			<- double-click + Command-D to see class definition
//
//
// CTitleBox is my version of the typical "box around some items with a title"; 
// In MacApp speak, a cluster. This is derived from LView so it can have subpanes. 
// It does no event handling itself.
//
#ifndef __CTitleBox__
#define __CTitleBox__

#include <LView.h>

class CTitleBox : public LView 
{
	public:
	enum { class_ID = 'Titl' };
							CTitleBox(void);							// default constructor
							CTitleBox(const CTitleBox &inCaption);		// copy constructor
							CTitleBox(const SPaneInfo &inPaneInfo, const SViewInfo &inViewInfo, 
											Str255 inString, ResIDT inTextTraitsID,
											Rect &inOffsetRect);		// build on the fly
							CTitleBox(LStream *inStream);				// resource constructor
		virtual				~CTitleBox(void);							
		
		static CTitleBox*	CreateTitleBoxStream(LStream *inStream);	
							
							// Thse set/get the title of the title box
		virtual StringPtr	GetDescriptor(Str255 outDescriptor) const;
		virtual void		SetDescriptor(ConstStr255Param inDescriptor);
							
							// set the drawing environment used
		ResIDT				GetTextTraitsID(void) const;
		void				SetTextTraitsID(ResIDT inTxtrID);
	
							// we have an offset for the rectangle to customize drawing of the 
							// box around the view
		void				GetOffsetRect(Rect *outOffsetRect) const;
		void				SetOffsetRect(Rect &inOffsetRect);
		
	protected:
		Str255				mTitle;
		ResIDT				mTxtrID;
		Rect				mOffsetRect;
		
		virtual void		DrawSelf();
};

#endif
