/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CGAProgressDialog.cp,v 1.13 1999/03/10 02:33:48 heller Exp $
____________________________________________________________________________*/

#include <Appearance.h>
#include <LProgressBar.h>
#include <LPushButton.h>
#include <LStaticText.h>
#include <UModalDialogs.h>

#include "pgpMacMemory.h"
#include "MacEnvirons.h"
#include "MacStrings.h"

#include "CGAProgressDialog.h"

const PaneIDT	kCancelButtonPaneID		= 'bCan';
const PaneIDT	kProgressCaptionPaneID	= 'Capt';
const PaneIDT	kProgressBarPaneID		= 'PBar';



CGAProgressDialog::CGAProgressDialog()
{
	mTotalOps 		= 0;
	mCompletedOps	= 0;
}

CGAProgressDialog::CGAProgressDialog(LStream *inStream)
	: LGADialog(inStream)
{
	mTotalOps 		= 0;
	mCompletedOps	= 0;
}

CGAProgressDialog::~CGAProgressDialog()
{
}


	void
CGAProgressDialog::FinishCreateSelf(void)
{
	LGADialog::FinishCreateSelf();
	
	if( HaveAppearanceMgr() )
	{
		SetThemeWindowBackground( GetMacPort(),
					kThemeActiveDialogBackgroundBrush, FALSE );
	}
		
	mProgressBarObj = (LProgressBar *) FindPaneByID( kProgressBarPaneID );
	pgpAssertAddrValid( mProgressBarObj, VoidAlign ); 
}

	void
CGAProgressDialog::ApplyForeAndBackColors(void) const
{
	if( HaveAppearanceMgr() )
	{
		SetThemeWindowBackground( GetMacPort(),
				kThemeActiveDialogBackgroundBrush, FALSE );
	}
	else
	{
		LGADialog::ApplyForeAndBackColors();
	}
}

//	Sets the text of the description above the progress bar.

	void
CGAProgressDialog::SetCaption(ConstStr255Param caption)
{
	LStaticText	*captionObj;
	
	pgpAssertAddrValid( caption, uchar );
	
	captionObj = (LStaticText *) FindPaneByID( kProgressCaptionPaneID );
	pgpAssertAddrValid( captionObj, VoidAlign );
	
	captionObj->SetDescriptor( caption );
}

	void
CGAProgressDialog::GetCaption(Str255 caption)
{
	LStaticText	*captionObj;
	
	pgpAssertAddrValid( caption, uchar );
	
	captionObj = (LStaticText *) FindPaneByID( kProgressCaptionPaneID );
	pgpAssertAddrValid( captionObj, VoidAlign );
	
	captionObj->GetDescriptor( caption );
}


//	Sets the title of the "Cancel" button.

	void
CGAProgressDialog::SetButtonTitle(ConstStr255Param title)
{
	LPushButton	*buttonObj;
	
	pgpAssertAddrValid( title, uchar );
	
	buttonObj = (LPushButton *) FindPaneByID( kCancelButtonPaneID );
	pgpAssertAddrValid( buttonObj, VoidAlign );
	
	buttonObj->SetDescriptor( title );
}


	void
CGAProgressDialog::SetPercentComplete(UInt32 percentComplete)
{
	pgpAssertAddrValid( mProgressBarObj, VoidAlign );
	
	mProgressBarObj->SetValue( percentComplete );
}


	void
CGAProgressDialog::SetTotalOperations(UInt32 totalOps)
{
	mTotalOps = totalOps;
}


	void
CGAProgressDialog::SetCompletedOperations(UInt32 completedOps)
{
	UInt32	percentComplete;
	
	pgpAssert( mTotalOps != 0 );
	
	mCompletedOps = completedOps;
	if( mCompletedOps > mTotalOps )
		mCompletedOps = mTotalOps;
		
	percentComplete = (UInt32)
		(( (float) mCompletedOps * 100.0 ) / (float) mTotalOps);
	
	SetPercentComplete( percentComplete );
}

	void
CGAProgressDialog::AddCompletedOperations(UInt32 completedOps)
{
	SetCompletedOperations( mCompletedOps + completedOps );
}

	void
CGAProgressDialog::SetIndeterminateFlag(Boolean inIsIndeterminate)
{
	pgpAssertAddrValid( mProgressBarObj, VoidAlign );

	mProgressBarObj->SetIndeterminateFlag( inIsIndeterminate );
}


	Boolean
CGAProgressDialog::IsIndeterminate(void) const
{
	pgpAssertAddrValid( mProgressBarObj, VoidAlign );
	
	return( mProgressBarObj->IsIndeterminate() );
}
