/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CSizeWindowPatcher.h,v 1.4 1999/03/10 02:40:05 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CPatcher.h"

class CSizeWindowPatcher	:	public	CPatcher {
public:
#if	TARGET_RT_MAC_CFM
	enum {kProcInfo =	kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(WindowRef)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(Boolean)))};
#else
	enum {kProcInfo = 0};
	typedef pascal void				(*SizeWindowProc)(WindowRef theWindow,
										short w, short h,
										Boolean fUpdate);
#endif
		
									CSizeWindowPatcher();
	virtual							~CSizeWindowPatcher();

protected:
	static CSizeWindowPatcher *		sSizeWindowPatcher;
	
	virtual void					NewSizeWindow(WindowRef theWindow,
										short w, short h,
										Boolean fUpdate);

	virtual void					OldSizeWindow(WindowRef theWindow, short w,
										short h,
										Boolean fUpdate);

	static pascal  void				SizeWindowCallback(WindowRef theWindow,
										short w, short h,
										Boolean fUpdate);
};
