/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPmenu.cp,v 1.14.4.2 1999/06/18 18:19:14 jason Exp $
____________________________________________________________________________*/

#include <EPPC.h>
#include <LowMem.h>
#include <Menus.h>
#include <ToolUtils.h>

#include "BETA.h"

#include "MacDesktop.h"
#include "MacIcons.h"
#include "MacMenus.h"
#include "pgpClientPrefs.h"
#include "pgpMem.h"
#include "pgpMemoryMgr.h"
#include "pgpOpenPrefs.h"
#include "WarningAlert.h"

#include "CString.h"
#include "sharedmem.h"
#include "StPGPRefs.h"
#include "StSaveCurResFile.h"
#include "StSaveHeapZone.h"

#if PGP_FINDERMENU
#	include "CPGPFindermenu.h"
#else
#	include "CPGPClarisEmailermenu.h"
#	include "CPGPMicrosoftWordmenu.h"
#	include "CPGPOutlookExpressmenu.h"
#endif



namespace {
#	if BETA
		ConstStringPtr	kBetaHasExpired				=	"\pThis beta version of PGPmenu has"
														" expired and will now only decrypt"
														" and verify. Please contact the beta"
														" site or beta test coordinator for"
														" the latest version.";
#	endif
	const ResID			MENU_PGPmenu					=	17359;
	const PGPInt16		menuItem_Encrypt				=	1;
	const PGPInt16		menuItem_Sign					=	2;
	const PGPInt16		menuItem_EncryptAndSign			=	3;
	const PGPInt16		menuItem_DecryptVerify			=	4;
	const PGPInt16		menuItem_ClearPassphraseCaches	=	6;
	const PGPInt16		menuItem_PGPkeys				=	8;
	const PGPInt16		menuItem_PGPtools				=	9;
	const PGPInt16		menuItem_PGPnet					=	10;
	
	const ResID			ICNx_PGPmenu				=	17359;
	const ResID			ICNx_PGPkeys				=	17360;
	const ResID			ICNx_PGPtools				=	17361;
	const ResID			ICNx_PGPnet					=	17362;
	
	const ResID			STR_Error					=	17359;
	const ResID			STR_FailedToLoadError		=	17360;
	
	const ResID			STRx_Strings				=	17359;
	enum {				stringID_UnableToLaunchApp	=	1,
						stringID_PGPkeys			=	2,
						stringID_PGPtools			=	3,
						stringID_PGPnet				=	4
	};
	
	const StringPtr		kPGPPrefsUpdateCount			=	"\pPGPPrefsUpdateCount";
	
	const PGPUInt32		kPGPnetHLEventClass				=	'PGPn';
	const PGPUInt32		kPGPnetServiceID				=	'PNsv';
	const PGPUInt32		kPGPnetHLEvent_ClearPhrasePGP	=	'cPGP';
	const PGPUInt32		kPGPnetHLEvent_ClearPhrase509	=	'c509';
}


//	Our main entry point gets called from the MESP
	PGPError
main(
	ProcessInfoRec *	inProcInfo,
	FSSpec *			inSpec,
	SPGPmenuMESPData *	inMESPData)
{
	PGPError	result = kPGPError_NoErr;
	
	try {
		switch (inProcInfo->processSignature) {
#if PGP_FINDERMENU
			case CPGPFindermenu::kSignature:
			{
				CPGPmenu::Setmenu(new CPGPFindermenu(inSpec, inMESPData));
			}
			break;

#else
			case CPGPClarisEmailermenu::kSignature:
			{
				CPGPmenu::Setmenu(new CPGPClarisEmailermenu(inSpec, inMESPData));
			}
			break;
			
			
			case CPGPMicrosoftWordmenu::kSignature:
			{
				CPGPmenu::Setmenu(new CPGPMicrosoftWordmenu(inSpec, inMESPData));
			}
			break;
			
			
			case CPGPOutlookExpressmenu::kSignature:
			{
				CPGPmenu::Setmenu(new CPGPOutlookExpressmenu(inSpec, inMESPData));
			}
			break;
			
			
			default:
			{
				CPGPmenu::Setmenu(new CPGPAppmenu(inSpec, inMESPData));
			}
			break;
#endif
		}
		
		MacLeaks_Suspend();
		CPGPmenu::Getmenu()->Patch();
		MacLeaks_Resume();
	}
	
	catch (CPGPException & error) {
		result = error.GetPGPError();
	}
	
	catch (...) {
		result = kPGPError_UnknownError;
	}
	
	return result;
}



//	We redefine operators new and delete here in order to throw CPGPExceptions and to avoid
//	having Metrowerks allocate a large block in the app's memory space.
	void *
operator new(
	size_t	inSize)
{
	void *	theMemory = ::NewPtr(inSize);
	
	PGPThrowIfMemFail_(theMemory);
	
	return theMemory;
}



	void *
operator new[](
	size_t	size)
{
	void *	theMemory = ::NewPtr(size);
	
	PGPThrowIfMemFail_(theMemory);
	
	return theMemory;
}



	void
operator delete(
	void *	inMemory)
{
	if (inMemory != 0) {
		::DisposePtr(static_cast<Ptr>(inMemory));
	}
}



	void
operator delete[](
	void *	inMemory)
{
	if (inMemory != 0) {
		::DisposePtr(static_cast<Ptr>(inMemory));
	}
}




//	Definition of the CPGPmenu class
CPGPmenu *		CPGPmenu::sMenu				=	0;
const OSType	CPGPmenu::kPGPkeysType		=	'APPL';
const OSType	CPGPmenu::kPGPkeysCreator	=	'pgpK';
const OSType	CPGPmenu::kPGPtoolsType		=	'APPL';
const OSType	CPGPmenu::kPGPtoolsCreator	=	'pgpM';
const OSType	CPGPmenu::kPGPnetType		=	'appc';
const OSType	CPGPmenu::kPGPnetCreator	=	'PGPn';



CPGPmenu::CPGPmenu(
	FSSpec *	inSpec)
		:	mPGPmenuSpec(*inSpec), mPGPPrefsUpdateCount(0), mPatchExitToShell(true),
			mPatchDrawMenuBar(true), mPatchInsertMenu(true), mPatchMenuSelect(true),
			mPatchWaitNextEvent(true), mEncryptEnabled(true), mSignEnabled(true),
			mDecryptEnabled(true), mVerifyEnabled(true), mClearPassphraseCachesEnabled(true),
			mMenuHandle(0), mMenuIconSuite(0)
{
	StSaveHeapZone		savedZone(::SystemZone());
	StSaveCurResFile	curResFile;
	LFile				ourFile(mPGPmenuSpec);

	ourFile.OpenResourceFork(fsRdPerm);
#	if BETA
		CheckBeta();
#	endif
	pgpClearMemory(&mHotKeys, sizeof(PGPmenuHotkeys));
	CreateMenu();
}



CPGPmenu::~CPGPmenu()
{
	DeleteMenu();
}


	
	void
CPGPmenu::Initialize()
{
	UpdatePrefs();
}



	void
CPGPmenu::ShowError(
	CPGPException &	inError)
{
	if (! inError.IsCancelError()) {
		try {
			WarningAlert(kWAStopAlertType, kWAOKStyle, CString(CStringFromSTR(STR_Error)),
				CString(CStringFromInt(inError.GetError())), CString(inError.what()));
		}
		
		catch (...) {
		}
	}
}



	void
CPGPmenu::Patch()
{
	if (mPatchExitToShell) {
		new CPGPmenuExitToShellPatch;
	}
	if (mPatchDrawMenuBar) {
		new CPGPmenuDrawMenuBarPatch;
	}
	if (mPatchInsertMenu) {
		new CPGPmenuInsertMenuPatch;
	}
	if (mPatchMenuSelect) {
		new CPGPmenuMenuSelectPatch;
	}
	if (mPatchWaitNextEvent) {
		new CPGPmenuWaitNextEventPatch;
	}
}


	void
CPGPmenu::CreateMenu()
{
	OSStatus	err;
	Handle		tempHandle;
	Handle		iconSuiteHandle;
	
	mMenuHandle = ::GetMenu(MENU_PGPmenu);
	PGPThrowIfResFail_(mMenuHandle);
	::DetachResource(reinterpret_cast<Handle>(mMenuHandle));
	
	err = ::GetIconSuite(&tempHandle, ICNx_PGPmenu, svAllSmallData);
	PGPThrowIfOSError_(err);
	err = DuplicateIconSuite(tempHandle, &mMenuIconSuite);
	::DisposeIconSuite(tempHandle, true);
	PGPThrowIfOSError_(err);
	err = ::GetIconSuite(&tempHandle, ICNx_PGPkeys, svAllSmallData);
	PGPThrowIfOSError_(err);
	err = DuplicateIconSuite(tempHandle, &iconSuiteHandle);
	::DisposeIconSuite(tempHandle, true);
	PGPThrowIfOSError_(err);
	err = ::SetMenuItemIconHandle(mMenuHandle, menuItem_PGPkeys, kMenuIconSuiteType,
				iconSuiteHandle);
	PGPThrowIfOSError_(err);
	err = ::GetIconSuite(&tempHandle, ICNx_PGPtools, svAllSmallData);
	PGPThrowIfOSError_(err);
	err = DuplicateIconSuite(tempHandle, &iconSuiteHandle);
	::DisposeIconSuite(tempHandle, true);
	PGPThrowIfOSError_(err);
	err = ::SetMenuItemIconHandle(mMenuHandle, menuItem_PGPtools, kMenuIconSuiteType,
				iconSuiteHandle);
	PGPThrowIfOSError_(err);
	err = ::GetIconSuite(&tempHandle, ICNx_PGPnet, svAllSmallData);
	PGPThrowIfOSError_(err);
	err = DuplicateIconSuite(tempHandle, &iconSuiteHandle);
	::DisposeIconSuite(tempHandle, true);
	PGPThrowIfOSError_(err);
	err = ::SetMenuItemIconHandle(mMenuHandle, menuItem_PGPnet, kMenuIconSuiteType,
				iconSuiteHandle);
	PGPThrowIfOSError_(err);
	
	//	Format of the menu title for an icon is 0x0501xxxxxxxx where xxxxxxxx is the handle
	//	to the icon data
	(**mMenuHandle).menuData[0] = 0x05;
	(**mMenuHandle).menuData[1] = 0x01;
	*reinterpret_cast<Handle *>(&(**mMenuHandle).menuData[2]) = mMenuIconSuite;
}



	void
CPGPmenu::DeleteMenu()
{
	if (mMenuHandle != 0) {
		UInt8	type;
		Handle	iconSuiteHandle = 0;
		
		::GetMenuItemIconHandle(mMenuHandle, menuItem_PGPkeys, &type, &iconSuiteHandle);
		if (iconSuiteHandle != 0) {
			::DisposeIconSuite(iconSuiteHandle, true);
			iconSuiteHandle = 0;
		}
		::GetMenuItemIconHandle(mMenuHandle, menuItem_PGPtools, &type, &iconSuiteHandle);
		if (iconSuiteHandle != 0) {
			::DisposeIconSuite(iconSuiteHandle, true);
			iconSuiteHandle = 0;
		}
		::GetMenuItemIconHandle(mMenuHandle, menuItem_PGPnet, &type, &iconSuiteHandle);
		if (iconSuiteHandle != 0) {
			::DisposeIconSuite(iconSuiteHandle, true);
		}
		::DisposeHandle(reinterpret_cast<Handle>(mMenuHandle));
	}
	if (mMenuIconSuite != 0) {
		::DisposeIconSuite(mMenuIconSuite, true);
	}
}



	void
CPGPmenu::DrawMenuBar()
{
	MenuHandle	appleMenu = GetIndMenuInMenuBar(0);
	
	//	We insert our menu if the first character of the first menu's title is the appleMark
	//	and we aren't already inserted into the menu list
	if ((appleMenu != 0)
	&& ((**appleMenu).menuData[1] == appleMark)
	&& (::GetMenuHandle(MENU_PGPmenu) == 0)) {
		::InsertMenu(mMenuHandle, 0);
	}
	
}



	void
CPGPmenu::InsertMenu(
	short *	beforeID)
{
	//	If our menu is in the menulist and the app isn't attempting to insert a submenu,
	//	make sure that they get inserted before our menu
	if ((::GetMenuHandle(MENU_PGPmenu) != 0) && (*beforeID >= 0)
	&& (::GetMenuHandle(*beforeID) == 0)) {
		*beforeID = MENU_PGPmenu;
	}
}



	void
CPGPmenu::AdjustMenuItems()
{
	OSStatus	err;
	
	CheckPrefs();
	if (mEncryptEnabled) {
		::EnableItem(mMenuHandle, menuItem_Encrypt);
	} else {
		::DisableItem(mMenuHandle, menuItem_Encrypt);
	}
	if (mSignEnabled) {
		::EnableItem(mMenuHandle, menuItem_Sign);
	} else {
		::DisableItem(mMenuHandle, menuItem_Sign);
	}
	if (mEncryptEnabled && mSignEnabled) {
		::EnableItem(mMenuHandle, menuItem_EncryptAndSign);
	} else {
		::DisableItem(mMenuHandle, menuItem_EncryptAndSign);
	}
	if (mDecryptEnabled || mVerifyEnabled) {
		::EnableItem(mMenuHandle, menuItem_DecryptVerify);
	} else {
		::DisableItem(mMenuHandle, menuItem_DecryptVerify);
	}
	if (mClearPassphraseCachesEnabled) {
		::EnableItem(mMenuHandle, menuItem_ClearPassphraseCaches);
	} else {
		::DisableItem(mMenuHandle, menuItem_ClearPassphraseCaches);
	}

	::SetItemCmd(mMenuHandle, menuItem_Encrypt, mHotKeys.encryptKey);
	err = ::SetMenuItemModifiers(mMenuHandle, menuItem_Encrypt, mHotKeys.encryptModifiers);
	PGPThrowIfOSError_(err);
	::SetItemCmd(mMenuHandle, menuItem_Sign, mHotKeys.signKey);
	err = ::SetMenuItemModifiers(mMenuHandle, menuItem_Sign, mHotKeys.signModifiers);
	PGPThrowIfOSError_(err);
	::SetItemCmd(mMenuHandle, menuItem_EncryptAndSign, mHotKeys.encryptSignKey);
	err = ::SetMenuItemModifiers(mMenuHandle, menuItem_EncryptAndSign,
				mHotKeys.encryptSignModifiers);
	PGPThrowIfOSError_(err);
	::SetItemCmd(mMenuHandle, menuItem_DecryptVerify, mHotKeys.decryptKey);
	err = ::SetMenuItemModifiers(mMenuHandle, menuItem_DecryptVerify, mHotKeys.decryptModifiers);
	PGPThrowIfOSError_(err);
	::SetItemCmd(mMenuHandle, menuItem_ClearPassphraseCaches, mHotKeys.purgeKey);
	err = ::SetMenuItemModifiers(mMenuHandle, menuItem_ClearPassphraseCaches,
				mHotKeys.purgeModifiers);
	PGPThrowIfOSError_(err);
}



	long
CPGPmenu::FilterMenuSelect(
	long	inResult)
{
	long	result = inResult;
	
	if (HiWord(inResult) == MENU_PGPmenu) {
		result = 0;
		
		mForceRecipientsDialog = ((CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->
									theEvent->modifiers & optionKey) != 0)
								&& (CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->
									theEvent->what == mouseDown);
		switch (LoWord(inResult)) {
			case menuItem_Sign:
			{
				Sign();
			}
			break;
			
			
			case menuItem_Encrypt:
			{
				Encrypt();
			}
			break;
			
			
			case menuItem_EncryptAndSign:
			{
				EncryptAndSign();
			}
			break;
			
			
			case menuItem_DecryptVerify:
			{
				DecryptVerify();
			}
			break;
			
			
			case menuItem_ClearPassphraseCaches:
			{
				ClearPassphraseCaches();
			}
			break;
			
			
			case menuItem_PGPkeys:
			{
				LaunchPGPkeys();
			}
			break;
			
			
			case menuItem_PGPtools:
			{
				LaunchPGPtools();
			}
			break;
			
			
			case menuItem_PGPnet:
			{
				LaunchPGPnet();
			}
			break;
		}
	}
	
	return result;
}



	void
CPGPmenu::RestoreMenuItems()
{
	::SetItemCmd(mMenuHandle, menuItem_Encrypt, 0);
	::SetItemCmd(mMenuHandle, menuItem_Sign, 0);
	::SetItemCmd(mMenuHandle, menuItem_EncryptAndSign, 0);
	::SetItemCmd(mMenuHandle, menuItem_DecryptVerify, 0);
	::SetItemCmd(mMenuHandle, menuItem_ClearPassphraseCaches, 0);
}



	void
CPGPmenu::HandleKeyDown()
{
	long	result;
	
	AdjustMenuItems();
	result = ::MenuEvent(CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->
							theEvent);
	RestoreMenuItems();
	if (HiWord(result) == MENU_PGPmenu) {
		::HiliteMenu(0);
		CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->what = nullEvent;
		CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->result = false;
		FilterMenuSelect(result);
	}
}



	void
CPGPmenu::CheckPrefs()
{
	SInt32		error;
	PGPUInt32 *	sharedMem;

	error = GetNamedBlock(kPGPPrefsUpdateCount, reinterpret_cast<Ptr *>(&sharedMem));
	if ((error == noErr) && (*sharedMem > mPGPPrefsUpdateCount)) {
		mPGPPrefsUpdateCount = *sharedMem;
		UpdatePrefs();
	}
}


	void
CPGPmenu::UpdatePrefs()
{
	PGPError			pgpErr;
	StPGPMemoryMgrRef	memoryMgr;
	StPGPPrefRef		prefs;
	void *				hotkeys;
	PGPSize				dataSize;
	
	pgpErr = PGPNewMemoryMgr(0, &memoryMgr);
	PGPThrowIfPGPError_(pgpErr);
	pgpErr = PGPOpenClientPrefs(memoryMgr, &prefs);
	PGPThrowIfPGPError_(pgpErr);
	pgpErr = PGPGetPrefData(prefs, kPGPPrefHotKeyData, &dataSize, &hotkeys);
	PGPThrowIfPGPError_(pgpErr);
	pgpCopyMemory(hotkeys, &mHotKeys, sizeof(PGPmenuHotkeys));
	PGPDisposePrefData(prefs, hotkeys);
}


	void
CPGPmenu::Sign()
{
}



	void
CPGPmenu::Encrypt()
{
}



	void
CPGPmenu::EncryptAndSign()
{
}



	void
CPGPmenu::DecryptVerify()
{
}



	void
CPGPmenu::ClearPassphraseCaches()
{
	EventRecord			event;
	
	pgpClearMemory(&event, sizeof(EventRecord));
	event.what = kHighLevelEvent;
	event.message = kPGPnetHLEventClass;
	event.where.v = kPGPnetHLEvent_ClearPhrasePGP >> 16;
	event.where.h = kPGPnetHLEvent_ClearPhrasePGP & 0xFFFF;
	
	PostHighLevelEvent(&event, reinterpret_cast<void *>(kPGPnetServiceID), 0, 0, 0,
		receiverIDisSignature + nReturnReceipt);

	event.where.v = kPGPnetHLEvent_ClearPhrase509 >> 16;
	event.where.h = kPGPnetHLEvent_ClearPhrase509 & 0xFFFF;
	
	PostHighLevelEvent(&event, reinterpret_cast<void *>(kPGPnetServiceID), 0, 0, 0,
		receiverIDisSignature + nReturnReceipt);
}



	void
CPGPmenu::LaunchPGPkeys()
{
	if (BringAppToFront(kPGPkeysType, kPGPkeysCreator, kFindAppOnAllVolumes, true, 0, 0)
	!= noErr) {
		WarningAlert(kWAStopAlertType, kWAOKStyle, STRx_Strings, stringID_UnableToLaunchApp,
			CString(CStringFromSTRx(STRx_Strings, stringID_PGPkeys)));
		PGPThrowPGPError_(kPGPError_UserAbort);
	}
}



	void
CPGPmenu::LaunchPGPtools()
{
	if (BringAppToFront(kPGPkeysType, kPGPtoolsCreator, kFindAppOnAllVolumes, true, 0, 0)
	!= noErr) {
		WarningAlert(kWAStopAlertType, kWAOKStyle, STRx_Strings, stringID_UnableToLaunchApp,
			CString(CStringFromSTRx(STRx_Strings, stringID_PGPtools)));
		PGPThrowPGPError_(kPGPError_UserAbort);
	}
}



	void
CPGPmenu::LaunchPGPnet()
{
	if (BringAppToFront(kPGPkeysType, kPGPnetCreator, kFindAppOnAllVolumes, true, 0, 0)
	!= noErr) {
		WarningAlert(kWAStopAlertType, kWAOKStyle, STRx_Strings, stringID_UnableToLaunchApp,
			CString(CStringFromSTRx(STRx_Strings, stringID_PGPnet)));
		PGPThrowPGPError_(kPGPError_UserAbort);
	}
}



#if BETA
		void
	CPGPmenu::CheckBeta()
	{
		if (BetaExpired()) {
			StringPtr	betaExpiredNote;
			NMRecPtr	theNotification;
			
			betaExpiredNote = reinterpret_cast<StringPtr>(::NewPtr(kBetaHasExpired[0] + 1));
			PGPThrowIfMemFail_(betaExpiredNote);
			theNotification = reinterpret_cast<NMRecPtr>(::NewPtrClear(sizeof(NMRec)));
			PGPThrowIfMemFail_(betaExpiredNote);
			pgpCopyMemory(kBetaHasExpired, betaExpiredNote, kBetaHasExpired[0] + 1);
			theNotification->qType = nmType;
			theNotification->nmSound = reinterpret_cast<Handle>(-1);
			theNotification->nmStr = betaExpiredNote;
			theNotification->nmResp = reinterpret_cast<NMUPP>(-1);
			::NMInstall(theNotification);
			mEncryptEnabled = false;
			mSignEnabled = false;
		}
	}
#endif



//	PGPmenu patches
extern "C" {
	void __terminate();
}


	void
CPGPmenu::CPGPmenuExitToShellPatch::NewExitToShell()
{
	try {
		delete CPGPmenu::Getmenu();
		CPGPmenu::Setmenu(0);
	}
	
	catch (...) {
	}
	__terminate();
	OldExitToShell();
}



	void
CPGPmenu::CPGPmenuDrawMenuBarPatch::NewDrawMenuBar()
{
	try {
		CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
		StSaveHeapZone		savedZone(::SystemZone());
		StSaveCurResFile	curResFile;
		LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

		ourFile.OpenResourceFork(fsRdWrPerm);
		try {
			pgpmenu->DrawMenuBar();
		}
		
		catch (CPGPException & error) {
			CPGPmenu::ShowError(error);
		}
	}
	
	catch (...) {
	}
	
	OldDrawMenuBar();
}



	void
CPGPmenu::CPGPmenuInsertMenuPatch::NewInsertMenu(
	MenuRef	theMenu,
	short	beforeID)
{
	try {
		CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
		StSaveHeapZone		savedZone(::SystemZone());
		StSaveCurResFile	curResFile;
		LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

		ourFile.OpenResourceFork(fsRdWrPerm);
		try {
			pgpmenu->InsertMenu(&beforeID);
		}
		
		catch (CPGPException & error) {
			CPGPmenu::ShowError(error);
		}
	}
	
	catch (...) {
	}
	
	OldInsertMenu(theMenu, beforeID);
}



	long
CPGPmenu::CPGPmenuMenuSelectPatch::NewMenuSelect(
	Point	startPt)
{
	long	result = 0;
	
	// We use a semaphore to prevent reentry into our code.
	if (mSemaphore == 0) {
		try {
			CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
			StSaveHeapZone		savedZone(::SystemZone());
			StSaveCurResFile	curResFile;
			LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

			ourFile.OpenResourceFork(fsRdWrPerm);
			try {
				pgpmenu->AdjustMenuItems();
			}
			
			catch (CPGPException & error) {
				CPGPmenu::ShowError(error);
			}
		}
		
		catch (...) {
		}
	}
	
	result = OldMenuSelect(startPt);

	if (mSemaphore == 0) {
		mSemaphore++;
		
		try {
			CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
			StSaveHeapZone		savedZone(::SystemZone());
			StSaveCurResFile	curResFile;
			LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

			ourFile.OpenResourceFork(fsRdWrPerm);
			try {
				result = pgpmenu->FilterMenuSelect(result);
			}
			
			catch (CPGPException & error) {
				if (result == MENU_PGPmenu) {
					result = 0;
				}
				CPGPmenu::ShowError(error);
			}
		}
		
		catch (...) {
			if (result == MENU_PGPmenu) {
				result = 0;
			}
		}
		
		mSemaphore--;
	}
	
	try {
		CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
			
		pgpmenu->RestoreMenuItems();
	}
	
	catch (...) {
	}
	
	if (result == 0) {
		::HiliteMenu(0);
	}
	
	return result;
}



	void
CPGPmenu::CPGPmenuWaitNextEventPatch::FirstEvent()
{
	try {
		CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
		StSaveHeapZone		savedZone(::SystemZone());
		StSaveCurResFile	curResFile;
		LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

		ourFile.OpenResourceFork(fsRdWrPerm);
		try {
			pgpmenu->Initialize();
		}
		
		catch (CPGPException & error) {
			WarningAlert(kWAStopAlertType, kWAOKStyle,
				CString(CStringFromSTR(STR_FailedToLoadError)), CString(CStringFromInt(error.GetError())));
			::DisableItem(pgpmenu->mMenuHandle, 0);
			::DrawMenuBar();
		}
		
		catch (...) {
			WarningAlert(kWAStopAlertType, kWAOKStyle,
				CString(CStringFromSTR(STR_FailedToLoadError)), CString(CStringFromInt(kPGPError_UnknownError)));
			::DisableItem(pgpmenu->mMenuHandle, 0);
			::DrawMenuBar();
		}
	}
	
	catch (...) {
	}
}



	void
CPGPmenu::CPGPmenuWaitNextEventPatch::HandleKeyDown()
{
	try {
		CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
		StSaveHeapZone		savedZone(::SystemZone());
		StSaveCurResFile	curResFile;
		LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

		ourFile.OpenResourceFork(fsRdWrPerm);
		try {
			pgpmenu->HandleKeyDown();
		}
		
		catch (CPGPException & error) {
			CPGPmenu::ShowError(error);
		}
		
		catch (...) {
			CPGPmenu::ShowError(CPGPException(kPGPError_UnknownError));
		}
	}
	
	catch (...) {
	}
}



	void
CPGPmenu::CPGPmenuWaitNextEventPatch::HandleIdleEvents()
{
	try {
		CPGPmenu *			pgpmenu = CPGPmenu::Getmenu();
		StSaveHeapZone		savedZone(::SystemZone());
		StSaveCurResFile	curResFile;
		LFile				ourFile(*pgpmenu->GetPGPmenuSpec());

		ourFile.OpenResourceFork(fsRdWrPerm);
		try {
			pgpmenu->CheckPrefs();
		}
		
		catch (CPGPException & error) {
			CPGPmenu::ShowError(error);
		}
		
		catch (...) {
			CPGPmenu::ShowError(CPGPException(kPGPError_UnknownError));
		}
	}
	
	catch (...) {
	}
}
