/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: PGPclientLibInitAndTerm.cp,v 1.3 1999/03/10 02:47:45 heller Exp $
____________________________________________________________________________*/

#include "pgpConfig.h"

#include <CodeFragments.h>

#include "MacBasics.h"
#include "PGPclientLibUtils.h"
#include "pgpDebug.h"
#include "pgpMem.h"

PGP_BEGIN_C_DECLARATIONS

pascal OSErr 	INIT_PGPclientLib(CFragInitBlock *initBlock);
pascal void		TERM_PGPclientLib(void);

pascal OSErr __initialize(const CFragInitBlock *theInitBlock);
pascal OSErr __terminate(void);

PGP_END_C_DECLARATIONS

	pascal OSErr
INIT_PGPclientLib(CFragInitBlock *initBlock)
{
	OSErr	err = noErr;

	err = __initialize( initBlock );
	if( IsntErr( err ) )
	{
		/*
		** Check that some version of AppearanceLib is available. We weak link
		** against the library so we have to check for availability in code
		*/
		
		if( (long) RegisterAppearanceClient != kUnresolvedCFragSymbolAddress )
		{
			/*
			** Remember the FSSpec of the library file se we can open it's
			** resource fork later.
			*/
			
			if( IsntNull( initBlock ) )
			{
				err = SetLibraryFSSpec(
					initBlock->fragLocator.u.onDisk.fileSpec );
			}
			else
			{
				/* Actual error is not important here */
				
				pgpDebugMsg( "INIT_PGPclientLib: No initBlock" );
				err = -1;
			}
		}
		else
		{
			err = cfragNoLibraryErr;
		}
	}

	pgpLeaksBeginSession( "PGPclientLib" );
	
	pgpAssert( err == noErr );

	return( err );
}

	pascal void
TERM_PGPclientLib(void)
{
	pgpLeaksEndSession();
	
	__terminate();
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
