/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPFoneApplication.cp,v 1.9.6.1 1999/06/02 06:11:40 wprice Exp $
____________________________________________________________________________*/
#include <PP_Messages.h>
#include <PP_Resources.h>
#include <UAttachments.h>
#include <URegistrar.h>
#include <UEnvironment.h>
#include <UGraphicUtils.h>
#include <UDrawingState.h>
#include <UMemoryMgr.h>
#include <UDesktop.h>
#include <UAppleEventsMgr.h>
#include <UScreenPort.h>
#include <LComparator.h>
#include <LIconPane.h>
#include "CPGPAMEditTextImp.h"
#include <LGAFocusBorder.h>
#include <LMultiPanelView.h>
#include <LRadioGroup.h>
#include <LRadioGroupView.h>
#include <LTabGroup.h>
#include <LMenu.h>
#include <LGrowZone.h>

// Appearance classes
#include <LBevelButton.h>
#include <LChasingArrows.h>
#include <LCheckBox.h>
#include <LCmdBevelButton.h>
#include <LDisclosureTriangle.h>
#include <LEditText.h>
#include <LGADialog.h>
#include <LIconControl.h>
#include <LLittleArrows.h>
#include <LPlacard.h>
#include <LPopupButton.h>
#include <LProgressBar.h>
#include <LPushButton.h>
#include <LRadioButton.h>
#include <LScrollBar.h>
#include <LStdControlImp.h>
#include <LScrollerView.h>
#include <LSeparatorLine.h>
#include <LSlider.h>
#include <LStaticText.h>
#include <LTabsControl.h>
#include <LTextGroupBox.h>
#include <LWindowHeader.h>

// Appearance Manager Implementations
#include <LAMBevelButtonImp.h>
#include <LAMControlImp.h>
#include <LAMPlacardImp.h>
#include <LAMPopupButtonImp.h>
#include <LAMPushButtonImp.h>
#include <LAMStaticTextImp.h>
#include <LAMTabsControlImp.h>
#include <LAMTrackActionImp.h>

// Grayscale Implementations
#include <LGALittleArrowsImp.h>

#include "PGPFoneApplication.h"
#include "CPFTSerial.h"

#include "CPFWindow.h"
#include "PGPFMacUtils.h"
#include "CXferWindow.h"
#include "CFileDrop.h"
#include "CXferView.h"
#include "CGrayControls.h"
#include "CLevelMeter.h"
#include "CStatusPane.h"
#include "CTitleBox.h"
#include "CPacketWatch.h"
#include "CPFTInternet.h"
#include "CPFPrefDialog.h"
#include "COneClikListBox.h"
#include "CTriThreshold.h"
#include "CPFDirectoryWindow.h"
#include "CDirectoryNewDialog.h"
#include "CDirTitle.h"
#include "CDirTable.h"
#include "CPopupList.h"
#include "CPopupSlider.h"
#include "CFileTable.h"
#include "fastpool.h"
#include "CVersionCaption.h"
#include "CPGPStDialogHandler.h"
#include "MacInternet.h"
#include "CPicture.h"


const CommandT	cmd_PacketWatch						= 2002;
const ResIDT	wind_PGPFone						= 128;
const ResIDT	wind_About							= 9000;
const ResIDT	wind_PacketWatch					= 140;
const ResIDT	wind_Authenticate					= 142;

const short		kWindowSplash						= 9001;
const short		kSplashDisplayTime					= 120;
const short		kMiscStringsListResID				= 133;
const short		kPGPWebSiteURLStrIndex				= 1;
const short		kAboutCreditsButtonTitleStrIndex	= 2;
const short		kAboutInfoButtonTitleStrIndex		= 3;

const MessageT	kOwnerCaptionID						= 'cLic';

const long		ae_OpenURL							= 5000;


PGPFoneOptions gPGFOpts;					// Global options

	static void
RealMain(void)
{
	LGrowZone* growZone = new LGrowZone(20000 );

	PGPFoneApplication*	theApp = new PGPFoneApplication;
	theApp->Run();
	delete theApp;
	
	delete growZone;
}

void main(void)
{
	long gestValue;
	Boolean badSystem;

	badSystem = FALSE;
	InitializeHeap(3);
	UQDGlobals::InitializeToolbox(&qd);

#ifndef BETA
	PP_PowerPlant::UDebugging::gDebugThrow = debugAction_Nothing;
	PP_PowerPlant::UDebugging::gDebugSignal = debugAction_Nothing;
#else
	PP_PowerPlant::UDebugging::gDebugThrow = debugAction_SourceDebugger;
	PP_PowerPlant::UDebugging::gDebugSignal = debugAction_SourceDebugger;
#endif

#ifdef BETA
	DateTimeRec dtr;
	
	GetTime(&dtr);
	if(dtr.year>1998 || ((dtr.year==1998) && (dtr.month>=10) && (dtr.day>15)))
	{
		PGFAlert("This beta version of PGPfone has expired, contact PGP for a new version.",0);
		ExitToShell();
	}
#endif
	if(!UEnvironment::HasFeature(env_HasThreadsManager))
	{
		PGFAlert("PGPfone requires Threads Manager 2.0.1 or greater.",0);
		badSystem = TRUE;
	}
	if(Gestalt(gestaltSoundAttr, &gestValue) ||
		!(gestValue & (1<<gestalt16BitAudioSupport)))
	{
		PGFAlert("PGPfone requires Sound Manager 3.0 or greater.",0);
		badSystem = TRUE;
	}
	if(!(gestValue & (1<<gestaltHasSoundInputDevice)))
	{
		PGFAlert("PGPfone requires sound input hardware.",0);
		badSystem = TRUE;
	}
	if(badSystem)
		ExitToShell();
	pgpLeaksBeginSession("main" );
	//pgpLeaksSuspend();
	RealMain();
	pgpLeaksEndSession();
}

// Given no OS events, we allow FONEYIELDQUANTUM to pass by before
// giving up time to the rest of the system.  If an event occurs,
// we will yield time more often.  This is very important to
// making sure we get enough execution time for the real
// time operations.
#define FONEEVENTQUANTUM	30
#define FONEOSQUANTUM		2

CTimeAttachment::CTimeAttachment(CPFWindow *pfWindow)
	: LAttachment(msg_Event, true)
{
	mNextSystemTime = mNextOSTime = 0;
	mFoneTime = FALSE;
	mPFWindow = pfWindow;
}

void
CTimeAttachment::ExecuteSelf(
	MessageT	/*inMessage*/, 
	void		*/*ioParam*/)
{
	EventRecord event;
	
	if(!mFoneTime)
	{
		LThread::Yield();
		::OSEventAvail(everyEvent, &event);
		if((mLastModifiers & 0xd800) != (event.modifiers & 0xd800))
		{	// test to see if option or control has changed
			// this lets us dynamically set button names
			// in CPFWindow.
			
			mLastModifiers = (event.modifiers & 0xd800);
			mPFWindow->ModifiersChanged(mLastModifiers);
		}
	}
	else
	{
		Boolean flag;
		long tick;
		
		// a fone call is in progress, clear the streets!
		for(flag=FALSE;!flag;)
		{
			do
			{
				LThread::Yield();
				tick = LMGetTicks();
			} while((mNextOSTime > tick) && (mNextSystemTime > tick));
			if(mNextSystemTime <= tick)
			{
				mNextSystemTime = tick + FONEEVENTQUANTUM;
				mNextOSTime = tick + FONEOSQUANTUM;
				flag = TRUE;
			}
			else
			{
				flag = ::OSEventAvail(everyEvent, &event)
					|| ((long)LMGetCurActivate()>0) || ((long)LMGetCurDeactive()>0) ||
					CheckUpdate(&event);
				LPeriodical::DevoteTimeToRepeaters(event);
				mNextOSTime = LMGetTicks() + FONEOSQUANTUM;
				if(!flag)
					::SystemTask();
			}
		}
	}
}

void
CTimeAttachment::SetFoneTime(Boolean inFone)
{
	mFoneTime = inFone;
}

PGPFoneApplication::PGPFoneApplication()	:
	mMenuBar(0),
	mModelDirector(0)
{
	long gestValue;
	
#ifdef	PGPXFER
	LThread::AllocateThreads(FALSE,11,thread_DefaultStack);
#else
	LThread::AllocateThreads(FALSE,7,thread_DefaultStack);
#endif
	new UMainThread;
	UEnvironment::InitEnvironment();
	RegisterClass_( LWindow );
	RegisterClass_( LCicnButton );
	RegisterClass_( LPicture );
	RegisterClass_( LTextEditView );
	RegisterClass_( LDisclosureTriangle );
	RegisterClass_( LActiveScroller );
	RegisterClass_( LCaption );
	RegisterClass_( LGADialog );
	RegisterClass_( LGAFocusBorder );
	RegisterClass_( LMultiPanelView );
	RegisterClass_( LPaintAttachment );
	RegisterClass_( LScrollerView );
	RegisterClass_( LTabGroup );
	RegisterClass_( LTableView );
	RegisterClass_( LRadioGroup );
	RegisterClass_( LRadioGroupView );
	RegisterClass_( LView );
	
	// Appearance classes:
	
	RegisterClass_( LBevelButton );
	RegisterClass_( LChasingArrows );
	RegisterClass_( LCheckBox );
	RegisterClass_( LCmdBevelButton );
	RegisterClass_( LEditText );
	RegisterClass_( LIconControl );
	RegisterClass_( LLittleArrows );
	RegisterClass_( LPlacard );
	RegisterClass_( LPopupButton );
	RegisterClass_( LProgressBar );
	RegisterClass_( LPushButton );
	RegisterClass_( LRadioButton );
	RegisterClass_( LScrollBar );
	RegisterClass_( LSeparatorLine );
	RegisterClass_( LSlider );
	RegisterClass_( LStaticText );
	RegisterClass_( LTabsControl );
	RegisterClass_( LTextGroupBox );
	RegisterClass_( LWindowHeader );
	
	(void) RegisterAppearanceClient();

	RegisterClassID_( LAMControlImp, 		LChasingArrows::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LCheckBox::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LRadioButton::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LIconControl::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LProgressBar::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LTextGroupBox::imp_class_ID );		
	RegisterClassID_( LAMControlImp,		LScrollBar::imp_class_ID );
	RegisterClassID_( LAMControlImp,		LSeparatorLine::imp_class_ID );
	RegisterClassID_( CPGPAMEditTextImp,	LEditText::imp_class_ID );
	RegisterClassID_( LAMBevelButtonImp, 	LBevelButton::imp_class_ID );
	RegisterClassID_( LAMControlImp,		LDisclosureTriangle::imp_class_ID );
	RegisterClassID_( LAMPlacardImp, 		LPlacard::imp_class_ID );
	RegisterClassID_( LAMPopupButtonImp, 	LPopupButton::imp_class_ID );
	RegisterClassID_( LAMPushButtonImp,		LPushButton::imp_class_ID );
	RegisterClassID_( LAMStaticTextImp,		LStaticText::imp_class_ID );
	RegisterClassID_( LAMTrackActionImp, 	LSlider::imp_class_ID);
	RegisterClassID_( LAMTabsControlImp,	LTabsControl::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LWindowHeader::imp_class_ID );
	RegisterClassID_( LGALittleArrowsImp,	LLittleArrows::imp_class_ID );
	
	RegisterClass_(CPFWindow);
	RegisterClass_(CPFDirectoryWindow);
	RegisterClass_(CDirectoryNewDialog);
	RegisterClass_(CDirTable);
	RegisterClass_(CDirTitle);
	RegisterClass_(CXferWindow);
	RegisterClass_(CFileDrop);
	RegisterClass_(CXferView);
	RegisterClass_(CPFPrefDialog);
	RegisterClass_(CChangingCaption);
	RegisterClass_(COneClikListBox);
	RegisterClass_(CGrayEditField);
	RegisterClass_(CDarkEditField);
	RegisterClass_(CTitleBox);
	RegisterClass_(CStatusPane);
	RegisterClass_(CLevelMeter);
	RegisterClass_(CPopupList);
	RegisterClass_(CPopupSlider);
	RegisterClass_(CPacketWatch);
	RegisterClass_(CTriThreshold);
	RegisterClass_(CFileTable);
	
	RegisterClass_(CVersionCaption);
	RegisterClass_(CPicture);
	RegisterClass_(LIconPane);
	
	if(!Gestalt(gestaltOpenTpt, &gestValue) && gestValue!=0 && !InitOpenTransport())
		UEnvironment::SetFeature(env_HasOpenTransport, true);
	if(!Gestalt('mtcp', &gestValue))
		UEnvironment::SetFeature(env_HasMacTCP, true);

	::DoPrefs(0);
	InitSafeAlloc();
	mSplashScreen = NIL;
	/*if(gPGFOpts.licopt.installDate)
		ShowSplashScreen();*/
	CPFTSerial::FindDevices();
	mXferWindow = NIL;
#ifdef	PGPXFER
	mXferWindow = LWindow::CreateWindow(134, this);
#endif
	mAuthWindow = LWindow::CreateWindow(wind_Authenticate, this);
	mPFWindow = (CPFWindow *)LWindow::CreateWindow(wind_PGPFone, this);
	mPFWindow->SetSubs(mAuthWindow, mXferWindow);
	mSleepTime = 0;	// this is a real-time app, we got no time to lose
	mAdjustCursor = TRUE;
	StartIdling();
	mTimeAttachment = new CTimeAttachment(mPFWindow);
	LEventDispatcher::AddAttachment(mTimeAttachment);
}

PGPFoneApplication::~PGPFoneApplication()
{
	StopIdling();
	delete mPFWindow;
	delete mAuthWindow;
	delete mXferWindow;
	CPFTInternet::CleanUp();
	if(UEnvironment::HasFeature(env_HasOpenTransport))
		CloseOpenTransport();
	CPFTInternet::CleanUp();
	::DoPrefs(1);
	DisposeSafeAlloc();
	
	pgpAssertAddrValid(mMenuBar, VoidAlign );
	if(IsntNull(mMenuBar ) )
		delete mMenuBar;
		
	pgpAssertAddrValid(mModelDirector, LModelDirector);
	if(IsntNull(mModelDirector))
		delete mModelDirector;
}

void
PGPFoneApplication::ShowSplashScreen()
{
	mSplashScreen = (LGADialog *)LWindow::CreateWindow(kWindowSplash, this);
	mSplashDisplayTime = LMGetTicks();
}

void
PGPFoneApplication::EndSplashScreen()
{
	while((mSplashDisplayTime + kSplashDisplayTime > LMGetTicks()) && !Button())
		YieldToAnyThread();
	delete mSplashScreen;
	mSplashScreen = NIL;
	::FlushEvents(mDownMask, 0);
}

void
PGPFoneApplication::SpendTime(const EventRecord &/*inMacEvent*/)
{
	/*if(!gPGFOpts.licopt.installDate)
	{
		const short			kWindowRegister		= 138;
		const MessageT		kOwnerNameID		= 'eNam';
		const MessageT		kOwnerCompanyID		= 'eCom';
		const MessageT		kOwnerLicenseID		= 'eLic';

		CPGPStDialogHandler	regDialog(kWindowRegister, this);
		LWindow				*regLDialog;
		MessageT			message;
		
		::GetDateTime(&gPGFOpts.licopt.installDate);
		regLDialog = regDialog.GetDialog();
		do
		{
			message = regDialog.DoDialog();
		} while((message != msg_OK) && (message != msg_Cancel));
		if(message == msg_OK)
		{
			((LEditField *)regLDialog->FindPaneByID(kOwnerNameID))->
				GetDescriptor((uchar *)gPGFOpts.licopt.ownerName);
			((LEditField *)regLDialog->FindPaneByID(kOwnerCompanyID))->
				GetDescriptor((uchar *)gPGFOpts.licopt.ownerCompany);
			((LEditField *)regLDialog->FindPaneByID(kOwnerLicenseID))->
				GetDescriptor((uchar *)gPGFOpts.licopt.ownerLicense);
		}
		else
			::ExitToShell();
		
		::DoPrefs(1);
		ShowSplashScreen();
	}*/
	if(mSplashScreen)
	{
		EndSplashScreen();
	}
	AddRandomEntropy();
}

void
PGPFoneApplication::ShowAboutBox()
{
	CPGPStDialogHandler	aboutDialog(wind_About, this);
	LWindow			*theDialog;
	MessageT		message;
	Boolean			credits = FALSE;
	
	const MessageT		kPGPButtonMessage		= 'bPGP';
	const MessageT		kCreditsButtonMessage	= 'bCre';
	const MessageT		kOKButtonMessage		= 'bOK ';
	
	const PaneIDT		kCreditsButtonPaneID	= 'bCre';
	const PaneIDT		kAboutPicturePaneID		= 'APIC';
	const PaneIDT		kCreditsPicturePaneID	= 'CPIC';
	
	theDialog = aboutDialog.GetDialog();

	while((message = aboutDialog.DoDialog()) != kOKButtonMessage )
	{
		if( message == kPGPButtonMessage )
		{
			Str255	url;
			
			GetIndString( url, kMiscStringsListResID, kPGPWebSiteURLStrIndex );
			if( ! OpenURL( url, 'pgpF' ) )
			{
				SysBeep( 1 );
			}
		}
		else if ( message == kCreditsButtonMessage )
		{
			Str255	buttonTitle;
			
			if( credits )
			{
				theDialog->FindPaneByID( kAboutPicturePaneID )->Show();
				theDialog->FindPaneByID( kOwnerCaptionID )->Show();
				theDialog->FindPaneByID( kCreditsPicturePaneID )->Hide();
				
				GetIndString( buttonTitle, kMiscStringsListResID, kAboutCreditsButtonTitleStrIndex );
			}
			else
			{
				theDialog->FindPaneByID( kCreditsPicturePaneID )->Show();
				theDialog->FindPaneByID( kOwnerCaptionID )->Hide();
				theDialog->FindPaneByID( kAboutPicturePaneID )->Hide();
				
				GetIndString( buttonTitle, kMiscStringsListResID, kAboutInfoButtonTitleStrIndex );
			}
			
			((LControl *)theDialog->FindPaneByID(kCreditsButtonPaneID))->SetDescriptor( buttonTitle );

			credits = ! credits;
		}
	}
}

Boolean
PGPFoneApplication::ObeyCommand(
	CommandT	inCommand,
	void		*ioParam)
{
	Boolean	cmdHandled = true;

	switch (inCommand)
	{
		case cmd_Preferences:
			CPFPrefDialog *prefDlog;
			
			prefDlog = (CPFPrefDialog *) LWindow::CreateWindow(129, this);
			prefDlog->InitPrefs( mPFWindow );
			prefDlog->Show();
			break;
		case cmd_Quit:
		default:
			cmdHandled = LApplication::ObeyCommand(inCommand, ioParam);
			break;
	}
	return cmdHandled;
}

void
PGPFoneApplication::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	outUsesMark = false;
	switch(inCommand)
	{
		case cmd_Preferences:
			if(!CPFPrefDialog::PrefWindOpen())
				outEnabled=true;
			break;
		case cmd_About:
		case cmd_Quit:
			outEnabled=true;
			break;
		default:
			LApplication::FindCommandStatus(inCommand, outEnabled,
											outUsesMark, outMark, outName);
			break;
	}
}

//	Adds random stuff to the pool. Data from the mouse position and the
//	system clock is used.

	void
PGPFoneApplication::AddRandomEntropy()
{
	static Point oldMousePos = {0,0};
	Point mousePos;
	UnsignedWide curms;
	
	//	Add any new mouse position to the random pool.
	GetMouse(&mousePos);
	LocalToGlobal(&mousePos);
	if(!EqualPt(mousePos, oldMousePos))
	{
		oldMousePos = mousePos;
		randPoolAddBytes((uchar *)&mousePos, sizeof(Point));
	}
	
	//	Add current Microseconds since startup time
	//	This is a 64 bit value
	Microseconds(&curms);
	randPoolAddBytes((uchar *)&curms, 8);
}

	void
PGPFoneApplication::HandleAppleEvent(
	const AppleEvent&	inAppleEvent,
	AppleEvent&			outAEReply,
	AEDesc&				outResult,
	long				inAENumber)
{
	switch (inAENumber)
	{
		case ae_OpenURL:
		{
			StAEDescriptor	targD;
			SInt16			result = 0;

			targD.GetParamDesc( inAppleEvent, keyDirectObject, typeIntlText );
			if( targD.DescriptorType() == typeIntlText )
			{
				long		urlSize = GetHandleSize( ((AEDesc)targD).dataHandle );
				char *		urlP = *(char **)((AEDesc)targD).dataHandle;
				char *		urlEnd = urlP + urlSize;
				char *		mStr = "pgpfone://";
				char *		p = mStr;
				Str255		url;
				short		urlLen = 0;
				PGPBoolean	matched = FALSE;
				
				for( ; ( urlP < urlEnd ) && ( urlLen < 254 ); urlP++ )
				{
					if( matched )
					{
						if( ( ( *urlP >= 'A' ) && ( *urlP <='Z' ) ) ||
							( ( *urlP >= 'a' ) && ( *urlP <='z' ) ) ||
							( *urlP == '.' ) )
							url[++urlLen] = *urlP;
					}
					else
					{
						if( ( *urlP == *p ) || ( *urlP == ( *p - ( 'a' - 'A' ) ) ) )
						{
							++p;
							if( !*p )
								matched = TRUE;
						}
						else
							p = mStr;
					}
				}
				if( urlLen )
				{
					url[0] = urlLen;
					mPFWindow->AECall( url );
				}
			}
			AECreateDesc(typeShortInteger, &result, sizeof(result),
									&outResult);
			break;
		}
		default:
			LApplication::HandleAppleEvent(inAppleEvent, outAEReply,
								outResult, inAENumber);
			break;
	}
}

	void
PGPFoneApplication::MakeModelDirector()
{
	pgpLeaksSuspend();
	mModelDirector = new LModelDirector(this);
	pgpLeaksResume();
}

	void
PGPFoneApplication::MakeMenuBar()
{
	mMenuBar = new LMenuBar(MBAR_Initial);
}

Boolean
PGPFoneApplication::AllowSubRemoval(LCommander	*inSub)
{
	if((inSub==mAuthWindow) || (inSub==mXferWindow))
	{
		((LWindow *)inSub)->Hide();
		return false;
	}
	return true;
}

