/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CXferView.cp,v 1.4.10.1 1999/07/09 00:02:37 heller Exp $
____________________________________________________________________________*/
#include <UTextTraits.h>
#include <UDrawingUtils.h>


#include "CXferView.h"

#include "PGPFoneUtils.h"
#include "PGPFMacUtils.h"
#include <string.h>

static uchar NoSendStr[]="\pDrop files or folders here to send.";
static uchar NoRecvStr[]="\pNothing to receive.";
static uchar SendStr[]="\pSend:\xCA";
static uchar RecvStr[]="\pRecv:\xCA";
static uchar BytesStr[]="\pBytes: ";
static uchar SpeedStr[]="\pSpeed: ";
static RGBColor statusBarBgnd = {0xCCCC, 0xCCCC, 0xFFFF};
static RGBColor statusBarFgnd = {0x4444, 0x4444, 0x4444};


CXferView*
CXferView::CreateXferViewStream(
	LStream	*inStream)
{
	return (new CXferView(inStream));
}

CXferView::CXferView(
	LStream	*inStream)
		: LPane(inStream)
{
	mSending = false;
	mXI = NIL;
	mLastTotal = 0;
	mAbortButton = NIL;
}

CXferView::~CXferView()
{
}

void
CXferView::DrawSelf()
{
	DoDraw(1);
}

void
CXferView::DoDraw(short full)
{
	Rect frame;
	Int16 just;
	
	if(FocusDraw())
	{
		CalcLocalFrameRect(frame);
		if(full)
			GrayBorder(frame);
		::InsetRect(&frame, 4, 4);
		just = UTextTraits::SetPortTextTraits(129);
		ApplyForeAndBackColors();
		if(full)
		{
			EraseRect(&frame);
			mAbortButton->Draw(NIL);
			ApplyForeAndBackColors();
		}
		if(!mXI)
		{
			if(mSending)
				UTextDrawing::DrawWithJustification((Ptr)&NoSendStr[1], NoSendStr[0], frame, just);
			else
				UTextDrawing::DrawWithJustification((Ptr)&NoRecvStr[1], NoRecvStr[0], frame, just);
		}
		else
		{
			{
				ulong tempDone, tempTotal, tSoFar;
				ulong tempStart, tempLast;
				long j;
				Point curPen;
				uchar s[80], s2[80];
				Boolean highSpeed;
				Rect r;
				
				tempDone=mXI->bytesDone;
				tempTotal=mXI->bytesTotal;
				tempStart=mXI->startTime;
				tempLast=mXI->lastTime;
				tSoFar=tempDone-mXI->cpsBase;
				if(mLastTotal!=tempTotal || mXI->forceUpdate)
				{
					mXI->forceUpdate=0;
					full=1;
				}
				if(mSending)
					UTextDrawing::DrawWithJustification((Ptr)&SendStr[1], SendStr[0], frame, just);
				else
					UTextDrawing::DrawWithJustification((Ptr)&RecvStr[1], RecvStr[0], frame, just);
				TextFace(0);
				GetPen(&curPen);	curPen.h+=3;
				pstrcpy(s,mXI->file.name);
				while(StringWidth(s)>frame.right-curPen.h)
					s[--s[0]]=0xC9;	/* Ellipses */
				DrawString(s);
				MoveTo(frame.left,curPen.v+14);
				TextFace(bold);
				DrawString(BytesStr);
				TextFace(0);
				if(tempTotal >= 10000000)
				{
					num2str(s, tempDone / 1024, 0, -32);
					strcat((char *)s, "K");
				}
				else
					num2str(s, tempDone, 0, -32);
				if(tempTotal>0)
				{
					strcat((char *)s, "/");
					if(tempTotal > 10000000)
					{
						num2str(s2, tempTotal / 1024, 0, -32);
						strcat((char *)s2, "K");
					}
					else
						num2str(s2, tempTotal, 0, -32);
					strcat((char *)s,(char *)s2);
					mLastTotal=tempTotal;
				}
				c2pstr((char *)s);
				DrawString(s);
				MoveTo(frame.left,curPen.v+28);
				TextFace(bold);
				DrawString(SpeedStr);
				TextFace(0);
				j=tempLast-tempStart;
				highSpeed = FALSE;
				if(j>0 && tSoFar>0)
				{
					j=tSoFar*1000.0/j;
					if(j>=4096)
					{
						highSpeed = TRUE;
						j /= 1024;
					}
					num2str(s, j, 1, -32);
				}
				else
					strcpy((char *)s, "?");
				if(highSpeed)
					strcat((char *)s, " Kps\xCA\xCA\xCA\xCA\xCA");
				else
					strcat((char *)s, " cps\xCA\xCA\xCA\xCA\xCA");
				c2pstr((char *)s);
				DrawString(s);
				SetRect(&r,frame.left,curPen.v+34,frame.left+104,curPen.v+44);
				::ForeColor(blackColor);
				::BackColor(whiteColor);
				PenNormal();
				PenSize(1,1);
				//if(full)
					FrameRect(&r);
				InsetRect(&r, 1,1);
				RGBBackColor(&statusBarBgnd);
				RGBForeColor(&statusBarFgnd);
				EraseRect(&r);
				if(tempTotal>0)
				{
					// The following prevents integer overflow in this calculation
					// when sending files greater than about 28 MB.
					if(tempTotal > 20000000)
						j = r.left+((tempDone/1024)*(r.right-r.left)) / (tempTotal/1024);
					else
						j=r.left+(tempDone*(r.right-r.left)) / tempTotal;
					if(j<=r.right)
						r.right=j;
					PaintRect(&r);
				}
				ApplyForeAndBackColors();
			}
		}
	}
}

void
CXferView::SetDirection(Boolean sending)
{
	mSending = sending;
}

void
CXferView::SetAbortButton(LCicnButton *abortButton)
{
	mAbortButton = abortButton;
}

void
CXferView::StartXfer(XferInfo *xi)
{
	mXI = xi;
	Draw(NIL);
	StartIdling();
}

void
CXferView::EndXfer(short moreXfers)
{
	mXI = NIL;
	if(!moreXfers)
		Draw(NIL);
	StopIdling();
	mLastTotal = 0;
}

void
CXferView::SpendTime(const EventRecord &/*inMacEvent*/)
{
	DoDraw(0);
}

