/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CStatusPane.cp,v 1.4 1999/03/10 02:41:13 heller Exp $
____________________________________________________________________________*/
#include "CStatusPane.h"

#include "PGPFoneUtils.h"
#include <string.h>
#include <stdarg.h>
#include <stdio.h>

CStatusPane	*CStatusPane::sStatusPane;

CStatusPane *CStatusPane::CreateStatusPaneStream(LStream *inStream)
{
	return (new CStatusPane(inStream));
}

CStatusPane::CStatusPane()
{
}

CStatusPane::CStatusPane(LStream *inStream)
		: LView(inStream)
{
	sStatusPane = this;
	mBuffer[0]=0;
}

CStatusPane::~CStatusPane()
{
}

CStatusPane *
CStatusPane::GetStatusPane(void)
{
	return sStatusPane;
}

void
CStatusPane::FinishCreateSelf()
{
	mTE = (LTextEditView *)FindPaneByID('txSt');
	pgpAssert(IsntNull(mTE));
	if( IsntNull( mTE ) )
		mTEH = mTE->GetMacTEH();
}

void
CStatusPane::AddStatus(Boolean /*urgent*/, char *fmt, ...)
{
	va_list ap;
	char buf[1024];
	long len;
	
	va_start(ap, fmt);
	len = vsprintf(buf, fmt, ap);
	va_end(ap);
	strcat(buf,"\r");	len++;
	strcat(mBuffer, buf);
	StartRepeating();
	// Don't want to draw it now in case we're calling from
	// interrupts or other non event loop code.
}

void
CStatusPane::DrawSelf()
{
	Rect frame;
	
	CalcLocalFrameRect(frame);
	if(FocusDraw())
	{
		ForeColor(blackColor);
		BackColor(whiteColor);
		EraseRect(&frame);
	}
}

void
CStatusPane::SpendTime(const EventRecord &/*inMacEvent*/)
{
	long len;
	
	StopRepeating();
	if(mTE->FocusDraw())
	{
		len = strlen(mBuffer);
		ForeColor(blackColor);
		BackColor(whiteColor);
		if((*mTEH)->teLength > 30000)
		{
			::TESetSelect(0, 0x7FFF, mTEH);
			::TEDelete(mTEH);
		}
		::TESetSelect((*mTEH)->teLength, (*mTEH)->teLength, mTEH);
		::TEInsert(mBuffer, len, mTEH);
		mBuffer[0]=0;
		mTE->AdjustImageToText();
		mTE->UserChangedText();
		mTE->ScrollPinnedImageBy(0,36,1);
	}
}

