/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CTestDrive.cp,v 1.8 1999/03/10 02:41:35 heller Exp $
____________________________________________________________________________*/

#include <Timer.h>
#include <stddef.h>
#include "pgpMacMemory.h"
#include "MacFiles.h"

#include "DriverAPI.h"
#include "CTestDrive.h"
#include "CTestDrive.h"
#include "CSyncFileTester.h"
#include "CInterruptLevelTestMgr.h"


#if PGP_DEBUG	// [


CTestDrive::CTestDrive(void)
	{
	mInterruptTestMgr	= nil;
	mSyncTester			= nil;
	}
	
	
CTestDrive::~CTestDrive( )
	{
	Stop();
	}
	
	
	OSStatus
CTestDrive::Run( const TestDriveConfiguration *config )
	{
	OSStatus	err	= noErr;
	
	pgpAssertAddrValid( config, TestDriveConfiguration );
	pgpAssert( config->vRefNum < 0 );
	
	mTestConfiguration	= *config;
	
	err	= CreateAndOpenTestFile( mTestConfiguration.vRefNum, &mTestSpec,
				&mTestFileRefNum );
	if ( IsntErr( err ) )
		{
		StartInterruptDrivenTest( );
		
		mSyncTester	= new CSyncFileTester( mTestFileRefNum );
		pgpAssert( IsntNull( mSyncTester ) );
		}
	
	return( err );
	}


	
	OSErr
CTestDrive::AllocateSpaceToTestFile( short fileRefNum )
	{
	OSErr		err	= noErr;
	const ulong	kGigabyte	= 1024UL* 1024UL * 1024UL;
	
	short	vRefNum	= GetVolumeForFile( fileRefNum );
	ulong	freeBlocks	= GetVolumeFreeAllocBlocks( vRefNum ) *
			( GetVolumeAllocBlockSize( vRefNum ) / kDiskBlockSize );
	ulong	testSizeInBlocks;
	
	if ( freeBlocks > kMaximumBlocksIn4GB )
		freeBlocks	= kMaximumBlocksIn4GB;
	
	testSizeInBlocks	= freeBlocks / 4;
		
	err	= SetEOF( fileRefNum, testSizeInBlocks * kDiskBlockSize );
	AssertNoErr( err, "CTestDrive::AllocateAllSpaceOnDiskToFile" );
	
	return( err );
	}


	
	OSErr
CTestDrive::CreateAndOpenTestFile(
	short		vRefNum,
	FSSpec *	spec,
	short *		fileRefNum)
	{
	OSErr	err	= noErr;
	
	*fileRefNum	= 0;
	
	// create a test file with a random name
	spec->vRefNum	= vRefNum;
	spec->parID		= fsRtDirID;
	NumToString( TickCount(), spec->name );
	
	err	= FSpCreate( spec, 'Temp', 'Temp', smSystemScript );
	AssertNoErr( err, "CTestDrive::StartInterruptDrivenTest" );
	if ( IsntErr( err ) )
		{
		err	= FSpOpenDF( spec, fsRdWrPerm, fileRefNum );
		AssertNoErr( err, "CTestDrive::StartInterruptDrivenTest" );
		
		if ( IsntErr( err ) )
			{
			const ulong	kTestFileSize	= 10 * 1024UL * 1024UL;
			
			err	= AllocateSpaceToTestFile( *fileRefNum );
			AssertNoErr( err, "CTestDrive::CreateAndOpenTestFile" );
			}
		}
	
	return( err );
	}


	void
CTestDrive::Stop( void )
	{
	OSStatus	err	= noErr;
	
	StopInterruptDrivenTest();
	
	delete mSyncTester;
	mSyncTester	= nil;
	
	if ( mTestFileRefNum != 0 )
		{
		err	= FSClose( mTestFileRefNum );
		AssertNoErr( err, "CTestDrive::Stop" );
		
		mTestFileRefNum	= 0;
		(void)FSpDelete( &mTestSpec );
		}
	
	}



	void
CTestDrive::IdleConsumeStack( void )
	{
	char	eatStackSpace[ 8192 ];
	
	pgpClearMemory( eatStackSpace, sizeof( eatStackSpace ) );
	
	
	// waste some time while our stack is small to
	// cause a crash if the driver is using too much stack space
	ulong	counter	= 0;
	while ( counter < 8 * 1024UL )
		{
		++counter;
		}
	}



/*___________________________________________________________________________
	Test the ugly case of a synchronous read which executes out of IODone
	by first making an async drive call followed by a sync driver call.
___________________________________________________________________________*/
	void
CTestDrive::SpecialDriverTest( void )
	{
	short	driveNumber;
	short	driverRefNum;
	
	GetVolumeDriveNumberAndRefNum( mTestSpec.vRefNum, &driveNumber,
				&driverRefNum );
	
	const ulong	kTestSize	= 2 * 128UL * 1024UL;
	void *	buffer;
	ulong	bufferSize	= kTestSize;
	
	buffer	= pgpAllocMac( bufferSize, kMacMemory_PreferTempMem);
	if ( IsntNull( buffer ) )
		{
		OSErr			err;
		ParamBlockRec	pb1;
		
		// do two reads: the first one async, followed by a second sync
		// this tests a difficult case for the driver
		ulong			readSize	= bufferSize / 2;
		
		pb1.ioParam.ioCompletion	= nil;
		pb1.ioParam.ioVRefNum		= driveNumber;
		pb1.ioParam.ioRefNum		= driverRefNum;
		pb1.ioParam.ioBuffer		= (Ptr)buffer;
		pb1.ioParam.ioReqCount		= readSize;
		pb1.ioParam.ioPosMode		= fsFromStart;
		pb1.ioParam.ioPosOffset		= 0;
		(void)PBReadAsync( &pb1 );
		
		ParamBlockRec	pb2;
		pb2		= pb1;
		pb1.ioParam.ioPosMode		= fsFromStart;
		pb1.ioParam.ioPosOffset		= 0;
		pb2.ioParam.ioBuffer		= (Ptr)buffer + readSize;
		err	= PBReadSync( &pb2 );
		// the async case *must* have finished prior to the sync case.
		pgpAssert( pb1.ioParam.ioResult != 1 );
		
		pgpFreeMac( buffer );
		}
	
	}


	
	void
CTestDrive::Idle( void )
	{
	pgpAssert( IsntNull( mSyncTester ) );
	
	mSyncTester->Run();
	
	IdleConsumeStack();
	
	SpecialDriverTest();
	}


	void
CTestDrive::StartInterruptDrivenTest(  )
	{
	pgpAssert( IsNull( mInterruptTestMgr ) );
	
#if TARGET_RT_MAC_CFM
	pgpDebugMsg( "Interrupt driven tests are not supported on CFM builds" );
#else
	mInterruptTestMgr	= new CInterruptLevelTestMgr( mTestFileRefNum );
	pgpAssert( IsntNull( mInterruptTestMgr ) );
	
	if ( IsntNull( mInterruptTestMgr ) )
		{
		mInterruptTestMgr->Run();
		}
#endif
	}


	void
CTestDrive::StopInterruptDrivenTest( )
	{
	if( mInterruptTestMgr != nil )
		{
		delete mInterruptTestMgr;
		mInterruptTestMgr	= nil;
		}
	}
	
#endif	// ]

