/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPKeyServerGrafPort.cp,v 1.9.10.1 1998/11/12 03:20:32 heller Exp $
____________________________________________________________________________*/

#include <LPushButton.h>
#include <LStaticText.h>
#include <PP_Messages.h>

#include "MacStrings.h"
#include "pgpDialogs.h"
#include "pgpMem.h"

#include "CPGPKeyServerGrafPort.h"
#include "pgpKeyServerDialogCommon.h"
#include "PGPsdkUILibDialogs.h"


CPGPKeyServerGrafPortView::CPGPKeyServerGrafPortView(LStream *inStream)
	: CPGPUIGrafPortView(inStream)
{
	mLastEventTicks		= 0;
	mServerNameText		= NULL;
	mServerStatusText	= NULL;
	mKeyNameText		= NULL;
	mFilterUPP			= NULL;
	mLastKeyServerState	= kPGPKeyServerState_Invalid;
	mLastKeyServer		= kInvalidPGPKeyServerRef;
}

CPGPKeyServerGrafPortView::~CPGPKeyServerGrafPortView()
{
	if( IsntNull( mFilterUPP ) )
		DisposeRoutineDescriptor( mFilterUPP );
}

	void
CPGPKeyServerGrafPortView::FinishCreateSelf()
{
	CPGPUIGrafPortView::FinishCreateSelf();
	
	mServerNameText = (LStaticText *) FindPaneByID( kServerNamePaneID );
	pgpAssertAddrValid( mServerNameText, VoidAlign );

	mServerStatusText = (LStaticText *) FindPaneByID( kStatusPaneID );
	pgpAssertAddrValid( mServerStatusText, VoidAlign );
	
	mKeyNameText = (LStaticText *) FindPaneByID( kKeyNamePaneID );
	/* mKeyNameText may be NULL */
	
	mOKButton->Hide();
}

	PGPError
CPGPKeyServerGrafPortView::SetOptions(
	PGPContextRef 				context,
	CPGPKeyServerDialogOptions 	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	err = CPGPUIGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		mOptions = options;
	}
	
	return( err );
}

	void
CPGPKeyServerGrafPortView::DoIdle(const EventRecord &inMacEvent)
{
	(void) inMacEvent;
	
	CPGPUIGrafPortView::DoIdle(inMacEvent);
	
	// Force ModalDialog to exit.
	SetDismissMessage( msg_OK );
}

	PGPError
CPGPKeyServerGrafPortView::KeyServerCallbackProc(
	PGPContextRef 	context,
	struct PGPEvent *event,
	PGPUserValue 	userValue)
{
	CPGPKeyServerGrafPortView	*grafPortObj;

	(void) context;
	
	grafPortObj = (CPGPKeyServerGrafPortView *) userValue;
	pgpAssertAddrValid( grafPortObj, VoidAlign );
	
	return( grafPortObj->KeyServerCallback( event ) );
}

	PGPError
CPGPKeyServerGrafPortView::KeyServerCallback(PGPEvent *event)
{
	PGPError	err 		= kPGPError_NoErr;
	DialogPtr	theDialog 	= GetMacPort();
	short		saveWindowKind;
	
	/* Whack the window type back to kDialogWindowKind for the callback */
	
	saveWindowKind = GetWindowKind( theDialog );
	SetWindowKind( theDialog, kDialogWindowKind );

	if( ! IsWindowVisible( theDialog ) )
	{
		Str255	statusStr;
		
		GetIndString( statusStr, kPGPLibDialogsStringListResID,
							kKeyServerConnectingStrIndex );
		mServerStatusText->SetDescriptor( statusStr );

		InitCursor();
		ShowWindow( theDialog );
		SelectWindow( theDialog );
		UpdatePort();

		mFilterUPP = NewModalFilterProc( ModalFilterProcHandler );
	}
	
	switch( event->type )
	{
		case kPGPEvent_KeyServerIdleEvent:
		{
			if( IsWindowVisible( theDialog ) )
			{
				PGPUInt32	ticks;
				
				ticks = TickCount();
				if( ticks >= mLastEventTicks + 3 )
				{
					short		itemHit;
					MessageT	theMessage;
					
					SetDismissMessage( msg_Nothing );
					
					ModalDialog( mFilterUPP, &itemHit );

					theMessage = HandleMessage( GetDismissMessage() );
					if( theMessage == msg_Cancel )
					{
						err = kPGPError_UserAbort;
					}
					
					mLastEventTicks = ticks;
				}
			}
						
			break;
		}
			
		case kPGPEvent_KeyServerEvent:
		{
			if( PGPKeyServerRefIsValid(
						event->data.keyServerData.keyServerRef ) &&
				event->data.keyServerData.keyServerRef != mLastKeyServer )
			{
				const char	*hostName 		= NULL;
				PGPBoolean	freeHostName 	= FALSE;
				PGPUInt32	index;
				
				mLastKeyServer = event->data.keyServerData.keyServerRef;

				// Set the server name:
				
				for( index = 0; index < mOptions->mServerCount; index++ )
				{
					if( mOptions->mServerList[index].server == 
							event->data.keyServerData.keyServerRef )
					{
						hostName = mOptions->mServerList[index].serverName;
						break;
					}
				}
				
				if( IsNull( hostName ) )
				{
					if( IsntPGPError( PGPGetKeyServerHostName(
								mLastKeyServer, (char **) &hostName ) ) )
					{
						freeHostName = TRUE;
					}
				}
				
				if( IsntNull( hostName ) )
				{
					Str255	serverStr;
					
					CToPString( hostName, serverStr );
					mServerNameText->SetDescriptor( serverStr );
					
					if( freeHostName )
						PGPFreeData( (char *) hostName );
				}
			}
			
			if( event->data.keyServerData.state != mLastKeyServerState )
			{
				short	newStateStrIndex = 0;
			
				switch( event->data.keyServerData.state )
				{
					case kPGPKeyServerState_Opening:
						newStateStrIndex = kKeyServerConnectingStrIndex;
						break;
						
					case kPGPKeyServerState_Querying:
						newStateStrIndex = kKeyServerSearchingStrIndex;
						break;

					case kPGPKeyServerState_ProcessingResults:
						newStateStrIndex = kKeyServerProcessingStrIndex;
						break;

					case kPGPKeyServerState_Uploading:
						newStateStrIndex = kKeyServerSendingStrIndex;
						break;

					case kPGPKeyServerState_Deleting:
						newStateStrIndex = kKeyServerDeletingSendingStrIndex;
						break;

					case kPGPKeyServerState_Disabling:
						newStateStrIndex = kKeyServerDisablingSendingStrIndex;
						break;

					case kPGPKeyServerState_Closing:
						newStateStrIndex = kKeyServerClosingSendingStrIndex;
						break;
				}

				if( kPGPLibDialogsStringListResID != 0 )
				{
					Str255	statusStr;
					
					GetIndString( statusStr, kPGPLibDialogsStringListResID,
										newStateStrIndex );
					mServerStatusText->SetDescriptor( statusStr );
				}
					
				mLastKeyServerState = (PGPKeyServerState)
											event->data.keyServerData.state;
			}
			
			break;
		}
	}

	SetWindowKind( theDialog, saveWindowKind );
	
	return( err );
}
