/*____________________________________________________________________________
	Copyright (C) 1996,1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: MacQuickdraw.h,v 1.6.12.1 1998/11/12 03:19:46 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <QuickDraw.h>

#include "pgpBase.h"

typedef enum RectAlignment
{
	kAlignAtNone				= 0x00,

	kAlignAtTop					= 0x01,
	kAlignAtVerticalCenter		= 0x02,
	kAlignAtBottom				= 0x04,
	
	kAlignAtLeft				= 0x10,
	kAlignAtHorizontalCenter	= 0x20,
	kAlignAtRight				= 0x40,

	kAlignAtTopLeft				= (kAlignAtTop | kAlignAtLeft),
	kAlignAtTopCenter			= (kAlignAtTop | kAlignAtHorizontalCenter),
	kAlignAtTopRight			= (kAlignAtTop | kAlignAtRight),

	kAlignAtCenterLeft			= (kAlignAtVerticalCenter | kAlignAtLeft),
	kAlignAtAbsoluteCenter		=
		(kAlignAtVerticalCenter | kAlignAtHorizontalCenter),
	kAlignAtCenterRight			=
		(kAlignAtVerticalCenter | kAlignAtRight),

	kAlignAtBottomLeft			= (kAlignAtBottom | kAlignAtLeft),
	kAlignAtBottomCenter		= (kAlignAtBottom | kAlignAtHorizontalCenter),
	kAlignAtBottomRight			= (kAlignAtBottom | kAlignAtRight)

} RectAlignment;

typedef struct ColorPenState
{
	Boolean			colorPort;
	RGBColor		foreColor;
	RGBColor		backColor;
	PenState		pen;
	SInt16			textMode;
	PixPatHandle	pnPixPat;
	PixPatHandle	bkPixPat;
	Pattern			bkPat;
	UInt32			fgColor;
	UInt32			bkColor;

} ColorPenState;

PGP_BEGIN_C_DECLARATIONS

void		AlignRect(const Rect *staticRect,
				Rect *alignRect, RectAlignment howToAlign);
void		GetColorAndPenState( ColorPenState* state );
Boolean		IsColorGrafPort(GrafPtr thePort);
void		SetColorAndPenState( ColorPenState* state );
void		NormalizeColorAndPen();

PGP_END_C_DECLARATIONS