/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: MacEnvirons.c,v 1.11.16.1 1998/11/12 03:19:31 heller Exp $
____________________________________________________________________________*/

#include <Appearance.h>
#include <Dialogs.h>
#include <Fonts.h>
#include <Gestalt.h>
#include <Menus.h>
#include <Scrap.h>
#include <TextEdit.h>
#include <Traps.h>
#include <Windows.h>

#include "pgpMem.h"
#include "MacBasics.h"
#include "MacEnvirons.h"

#include "MacStrings.h"
#include "MacTraps.h"

	UInt16
GetSystemVersion( void )
{
	static UInt16	sSystemVersion	 = 0;
	
	if ( sSystemVersion == 0 )
	{
		long	gestaltResult;
		
		if( TrapAvailable( _Gestalt ) &&
			Gestalt( gestaltSystemVersion, &gestaltResult ) == noErr )
		{
			sSystemVersion	= (UInt16)gestaltResult;
		}
		else
		{
			pgpDebugPStr( "\pGetSystemVersion: "
			"gestaltSystemVersion undefined" );
			sSystemVersion	= 0x0600;
		}
	}
	
	return( sSystemVersion );
}



	Boolean
VirtualMemoryIsOn( void )
{
	static Boolean	sVirtualMemoryIsOn = 99;
	
	if ( sVirtualMemoryIsOn == 99 )
	{
		long	gestaltResult;
		OSErr	err	= noErr;
	
		err	= Gestalt( gestaltVMAttr, &gestaltResult );
		if ( IsntErr( err ) )
		{
			sVirtualMemoryIsOn	=
				(gestaltResult & (1UL << gestaltVMPresent)) != 0;
		}
		else
		{
			sVirtualMemoryIsOn	= FALSE;
		}
	}
		
	return( sVirtualMemoryIsOn );
}

	void
GetMachineOwnerName(StringPtr owner)
{
	short	saveResFile;
	uchar	**ownerNameRes;
	
	pgpAssertAddrValid( owner, uchar );

	owner[0] = 0;
	
	saveResFile = CurResFile();
	UseResFile( 2 );
	
	ownerNameRes = (uchar **) Get1Resource( 'STR ', -16096 );
	if( IsntNull( ownerNameRes ) && IsntNull( *ownerNameRes ) )
	{
		CopyPString( *ownerNameRes, owner );
	}
	
	UseResFile( saveResFile );
}


#if ! powerc

	Boolean
RunningOnPowerPC( void )
	{
	long		gestaltResult;
	Boolean		onPowerPC	= false;
	
	if ( Gestalt( gestaltSysArchitecture, &gestaltResult ) == noErr )
		{
		onPowerPC	= (gestaltResult == gestaltPowerPC);
		}
	return( onPowerPC );
	}

#endif
	

	void
InitMacToolbox(void)
{
	UnloadScrap();
	
	InitGraf( &qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs( nil );
	InitCursor();
	MaxApplZone();
}

	UInt16
GetAppearanceMgrVersion(void)
{
	static UInt16	version = 99;
	
	if( version == 99 )
	{
		long	gestaltResult;
		
		version = 0;
		
		if( Gestalt( gestaltAppearanceAttr, &gestaltResult ) == noErr &&
				( gestaltResult & (1L << gestaltAppearanceExists) ) != 0 )
		{
			version = 0x0100;
			
			if( Gestalt( gestaltAppearanceVersion, &gestaltResult ) == noErr )
			{
				version = (UInt16) gestaltResult;
			}
		}
	
	
	#if TARGET_RT_MAC_CFM
		/* Check for waek link failure */
		if( (void *) RegisterAppearanceClient ==
				(void *) kUnresolvedCFragSymbolAddress )
		{
			version = 0;
		}
	#endif
	}
	
	return( version );
}

