/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CWhiteList.cp,v 1.1.8.1 1998/11/12 03:07:17 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableArrayStorage.h>

#include "CWhiteList.h"


CWhiteList*
CWhiteList::CreateFromStream(
	LStream	*inStream)
{
	return (new CWhiteList(inStream));
}


CWhiteList::CWhiteList(
	LStream	*inStream)
		: LTableView(inStream)
{
	mTableGeometry = new LTableMonoGeometry(this, mFrameSize.width, 12);
	mTableSelector = new LTableSingleSelector(this);
	mTableStorage = new LTableArrayStorage(this, sizeof(Str31));
}

	void
CWhiteList::DrawSelf()
{
	Rect frame;

	CalcLocalFrameRect(frame);
	::RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
	::EraseRect(&frame);
	LTableView::DrawSelf();
}

	void
CWhiteList::DeactivateSelf()
{
	Draw( NULL );

	pgpFixBeforeShip( "This is a workaround for an LTabsControl bug. Is there a fix?" );
	LTableView::DeactivateSelf();
}

	void
CWhiteList::ActivateSelf()
{
	LTableView::ActivateSelf();

	pgpFixBeforeShip( "This is a workaround for an LTabsControl bug. Is there a fix?" );
	Refresh();
}

	void
CWhiteList::DrawCell(
	const STableCell	&inCell,
	const Rect			&inLocalRect)
{
	Uint32			dataSize = sizeof(Str31);
	Str31			name;
	
	GetCellData(inCell, name, dataSize);
	::ForeColor(blackColor);
	::BackColor(whiteColor);
	::TextSize(9);
	::TextFont(1);
	::TextFace(0);
	::MoveTo(inLocalRect.left + 4, inLocalRect.bottom - 2);
	::DrawString(name);
}

	void
CWhiteList::ClickCell(
	const STableCell&		inCell,
	const SMouseDownEvent&	inMouseDown)
{
	(void) inMouseDown;
	
	if(GetClickCount() == 2)
		BroadcastMessage(kWLCellDoubleClickedMessageID,
							(void *)inCell.row);
}

	void
CWhiteList::SelectionChanged()
{
	BroadcastMessage(kWLSelectionChangedMessageID, NULL);
}

