/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPDiskUtils.h,v 1.8.8.1 1998/11/12 03:06:13 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CComboError.h"
#include "PGPDisk.h"
#include "PGPDiskFileFormat.h"

#if PGPDISK_PUBLIC_KEY
#include "pgpKeys.h"
#endif

typedef struct PGPDiskFileInfo
{
	Boolean		fileIsOnLockedVolume;
	Boolean		fileIsLocked;
	Boolean		fileIsOpen;
	Boolean		fileIsInUseByDriver;
	Boolean		fileIsMounted;
	short		fileDriveNumber;	// Valid if fileIsInUseByDriver == TRUE

} PGPDiskFileInfo;

typedef OSStatus	(*MountDiskProgressProcPtr)(UInt32 percentComplete,
							void *userValue);

CComboError	MountPGPDisk(const FSSpec *file, Boolean firstTime,
					Boolean mountReadOnly, const uchar *passphrase,
					Boolean allowRecoveryUI, ConstStr255Param newVolumeName,
					MountDiskProgressProcPtr progressProc,
					void *progressUserValue);
OSStatus	GetPGPDiskFileInfo(const FSSpec *fileSpec,
					PGPDiskFileInfo *fileInfo);

OSStatus	CheckForLocalPGPDiskVolume(short vRefNum);

OSStatus	VerifyPassphrase(const FSSpec *file, const uchar *passphrase);
OSStatus	VerifyMasterPassphrase(const FSSpec *file,
					const uchar *passphrase);

OSStatus	ChangePassphrase(const FSSpec *fileSpec,
					const uchar *oldPassphrase, const uchar *newPassphrase);
OSStatus	AddPassphrase( const FSSpec * spec,
					ConstStr255Param masterPassphrase,
					ConstStr255Param newPassphrase, Boolean readOnly );
OSStatus	RemovePassphrase( const FSSpec * spec,
					ConstStr255Param passphrase );
OSStatus	RemoveAlternatePassphrases(const FSSpec *fileSpec);

void		GetAllPGPDiskDrivers( short driverRefNums[], ushort maxRefNums,
					ushort * numDrivers);
void		GetAllPGPDrives( short driveNumbers[], ushort maxDrives,
					ushort * numDriveNumbers);

Boolean		IsPGPDiskFileType(OSType fileCreator, OSType fileType);
OSStatus	VerifyPGPDiskFileIsModifiable(const FSSpec *fileSpec);

void		GetErrorString(OSStatus err, StringPtr errorStr);
void		GetComboErrorString(CComboError	err, StringPtr errorStr);

#if PGP_BUSINESS_SECURITY	/* [ */

PGPError	GetADKInfo(PGPBoolean *haveADK, PGPKeyID *keyID,
						PGPPublicKeyAlgorithm *algorithm );

#endif	/* ] PGP_BUSINESS_SECURITY */

extern short	gApplicationResFile;

