// (C) 1996 Jens von Pilgrim


/*DOC
CLASS XString
Author: Jens von Pilgrim

Last change:   13.03.1997
*/

/*
History
  16.08.1995: - FastFind noch nicht ausgereift!
  26.03.1996: - XString arbeitet jetzt schneller (Lnge wird gespeichert),
                 nicht mehr "direkt" kompatibel zu pszChar!
              - assert-Abfrage wird nur bei definierten DEBUG durchgefhrt
  27.03.1996: - neuer () Operator: Liefert char-Zeiger zurck,
                optionaler Parameter: Count analog zu Left()
              - Cast-Operatoren fr
                XString -> int, const int, long, const long, double, const double
                sowie
              - Konstruktoren fr Zahlen: XString(int|long [,radix]) 
  01.04.1996: - Copy-Konstruktor ohne Speicherreservierung fr den Char-String
                => vorsicht! Schnell aber gefhrlich!
  29.05.1996: - Strip-Funktion
              - [] - Operator
              - DelSubString
  05.06.1996: - Replace
              - Bug in Find behoben ( ./ in .../ nicht gefunden!
  06.06.1996: - Umstellung: signed nach XSIZE_T bei
                Find und m_Length (und allgemein wo From oder To oder so auftauchen!)
              => Umsetllung von Find:
                statt: Positon = Find(Was, Von, Bis) nun: 
                 gefunden = Find(Pos, Was, Von, Bis)
                Ergebnis: bool (true: Found, false: Not found)
  07.06.1996: - operatoren <, <=, >, <= funktionieren jetzt RICHTIG!
  06.08.1996: - Anpassungen fr Visual C++ 4.0 (operatoren als Friends...)
              - MakeUpper, MakeLower
  12.08.1996: - InCase - Flag bei Find/FindRev/Replace
			  - neue Funktion UpperC
  17.10.1006: - diverse Anpassungen fuer Visual C++ 4.0 und XVT
              - BOOL (und TRUE, FALSE) werden durch bool, true und false ersetzt
  20.11.1996: Anpasungen fr VC4.0:
              - Operatoren ==, <=, >=, <, > 3 mal vorhanden:
			    XString-XString, lpszChar-XString, XString-lpszChar
			  - []-Operator 3-mal: [XSIZE_T], [ULONG], [int]
  20.11.1996: []-Operator liefert Refernez auf Zeichen, so dass
              z.B.:  A[i]='x' mglich ist
			  01.02.1997: zustzliche Find/FindRev-Funktion ohne 
			              Rckparameter der gefundenen Stelle
  08.02.1997: - Folgende Funktionen als const definiert:	
                Find, FindRev, SFind, SFindRev, IsEmpty, StrCmp,
				Mid, Left, Right, GetLength
				caster: int, long, char etc...
			  - statt XBOOL jetzt: bool aus bool.h der STL	
			  - neue Funktion:
			    StripWhitespaces ( int where = XBOTH )
  11.02.1997: - stream-operatoren: << und >>
  12.02.1997: - neue Funktionalitt:
				XString knnen "undefiniert" sein, also
				nicht initialisiert bzw. definiert NULL.
				Der Standardkonstruktor erzeugt einen
				"undefinierten" String, welcher sich
				aber voll kompatibel zur vorherigen Version
				zeigt.
				Folgende Funktionen sind daher neu:
				bool IsNULL() const;
				void MakeNULL();

				Zur leichterten Lesbarkeit wurde auch die
				"Empty-"Funktionalitt berarbeitet:
				bool IsEmpty() const; // wie gehabt
				void MakeEmpty();

				smtliche (potentielle) Schreibfunktionen
				haben als Nachbedingung IsNULL()==false
				(auch DelSubString, +=, MakeUpper, Strip,
				 ReleaseBuffer, MakeEmpty)
				ABER: = kopiert Zustand!
  13.03.1997: - Umbenannt:
                sFind -> Search 
				sFindRev -> SearchRev
			  - neue Funktionen:
                FindWhitespace
				SearchWhitespace 
 24.03,1997: - NEUE TEMPLATE-CLASS: XSplitableString
                 - Split // by Separator
				 - Split // by Whitespaces
				 - GetTableDatas 

****************************************************************************/


#ifndef _XSTRING_H_
#define _XSTRING_H_

#include <bool.h> // the STL bool.h: bool, true, false (as int)
#include "xlib.h"

#include <iostream.h>
#include <stdarg.h>
#include <ctype.h>

#ifndef NULL
  #define NULL 0
#endif

#ifndef XLEFT
  #define XALL 0
  #define XLEFT 1
  #define XRIGHT 2
  #define XBOTH 3
#endif


#define _XSTRING_DECL_  

#define _LINK_TO_
// #define _BUILD_DLL_

#ifdef _BUILD_DLL_
#undef _XSTRING_DECL_
  #define _XSTRING_DECL_ _declspec (dllexport)
#else
  #ifndef _LINK_TO_
#undef _XSTRING_DECL_
  #define _declspec (dllimport) 
  #endif
#endif


class _XSTRING_DECL_ XString
{

  public:

    XString();
    XString(const XString &aString);
	
    XString(char aChar);
	XString(char *pszChar);
    XString(const char *pszChar);

    XString(int aNumber, int Radix = 10);
    XString(long aNumber, int Radix = 10);
  
    virtual ~XString();

  protected:
	 XString(char *pszChar, int duplicate);

  public:

/////////////////////////
//  cast - operators
    operator const char *const() const;
    operator const int() const;
    operator const long() const;
    operator const double() const;


    const char *const operator() () const;
	char* operator() (XSIZE_T inCount); // == Left(inCount)

    char& operator[] (XSIZE_T inZeroIndex) const; // neu 20.11
	char& operator[] (int inZeroIndex) const;     // neu 20.11

    char& At(XSIZE_T inZeroIndex) const;
 
    XString operator =(const XString &aString);
    
    virtual int StrCmp(const XString &inThen) const;

	 




    XString operator +=(const XString &Str);
    XString operator +=(const char *Str);

    virtual XString Mid(XSIZE_T From, XSIZE_T Count) const;
    virtual XString Left(XSIZE_T Count) const;
    virtual XString Right(XSIZE_T Count) const;
    virtual  XSIZE_T GetLength() const;

    bool IsEmpty() const;
	void MakeEmpty();

	bool IsNULL() const;
	void MakeNULL();

    bool Find(XSIZE_T &outPos, const XString &SubString, XSIZE_T From = 0, XSIZE_T inTo = 0, bool inInCase=false) const;
    bool FindRev(XSIZE_T &outPos, const XString &SubString, XSIZE_T From = 0, XSIZE_T inTo = 0, bool inInCase=false) const;

	bool Search(const XString &SubString, XSIZE_T From = 0, XSIZE_T inTo = 0, bool inInCase=false) const;
    bool SearchRev(const XString &SubString, XSIZE_T From = 0, XSIZE_T inTo = 0, bool inInCase=false) const;

	bool FindWhitespace ( XSIZE_T &outPos, XSIZE_T inFrom = 0, XSIZE_T inTo = 0) const;
	bool SearchWhitespace ( XSIZE_T inFrom = 0, XSIZE_T inTo = 0) const;

	bool FindAlpha ( XSIZE_T &outPos, XSIZE_T inFrom = 0, XSIZE_T inTo = 0) const;
	bool FindNonAlpha ( XSIZE_T &outPos, XSIZE_T inFrom = 0, XSIZE_T inTo = 0) const;
	bool SearchAlpha( XSIZE_T inFrom = 0, XSIZE_T inTo = 0) const;
	bool SearchNonAlpha ( XSIZE_T inFrom = 0, XSIZE_T inTo = 0) const;

    int Strip(int inWhere = XBOTH, char inChar = ' ');
	int StripWhitespaces ( int inWhere = XBOTH );
    int DelSubString(XString inSubString);
    int DelSubString(XSIZE_T inFrom, XSIZE_T inCount=1);

    int Replace(XString inSearch, XString inReplace, int inTimes=XALL, XSIZE_T inFrom=0, XSIZE_T inTo=0, bool inInCase=false);
 
    char* GetBuffer(int Size);

    char* GetBuffer(XSIZE_T Size=0);
    int ReleaseBuffer(XSIZE_T Length=0);

    void MakeUpper();
	void MakeLower();
    
    static char UpperChar(char inChar);
	
    
/////////////////////////
// Friends

	/////////////////////////
	//  streams:
	_XSTRING_DECL_ friend ostream& operator<<(ostream&, const XString& );
	_XSTRING_DECL_ friend istream& operator>>(istream&, XString& );

	/////////////////////////
	// Compare (weitere Compare-Funktionen sttzen sich
	// auf == und < ab, mssen also keine Friends sein!
//    _XSTRING_DECL_ friend XString operator +(const XString Str1, const char *pszChar2);
//    _XSTRING_DECL_ friend XString operator +(const char *pszChar1, const XString Str2);
    _XSTRING_DECL_ friend XString operator +(const XString& Str1, const XString& Str2);
    
    _XSTRING_DECL_ friend int operator ==(const XString &inS1, const XString &inS2) ;
	_XSTRING_DECL_ friend int operator ==(const XString &inS1, const char *pszChar2) ;
	_XSTRING_DECL_ friend int operator ==(const char *pszChar1, const XString &inS2) ;

	_XSTRING_DECL_ friend int operator <(const XString &inS1, const XString &inS2);
	_XSTRING_DECL_ friend int operator <(const XString &inS1, const char *pszChar2);
	_XSTRING_DECL_ friend int operator <(const char *pszChar1, const XString &inS2);
	
////////////////


private:
    char *m_pszChar;
    XSIZE_T  m_Length;
	bool m_isNULL;

};


////////////////////////////////////////////////
// Friends - Prototypes

_XSTRING_DECL_ ostream& operator<<(ostream&, const XString& );
_XSTRING_DECL_ istream& operator>>(istream&, XString& );

// _XSTRING_DECL_ XString operator +(const XString Str1, const char *pszChar2);
// _XSTRING_DECL_ XString operator +(const char *pszChar1, const XString Str2);
_XSTRING_DECL_ XString operator +(const XString& Str1, const XString& Str2);

_XSTRING_DECL_ int operator ==(const XString &inS1, const XString &inS2) ;
_XSTRING_DECL_ int operator !=(const XString &inS1, const XString &inS2) ;
_XSTRING_DECL_ int operator <=(const XString &inS1, const XString &inS2);
_XSTRING_DECL_ int operator >=(const XString &inS1, const XString &inS2);
_XSTRING_DECL_ int operator >(const XString &inS1, const XString &inS2);
_XSTRING_DECL_ int operator <(const XString &inS1, const XString &inS2);

_XSTRING_DECL_ int operator ==(const XString &inS1, const char *pszChar2) ;
_XSTRING_DECL_ int operator !=(const XString &inS1, const char *pszChar2) ;
_XSTRING_DECL_ int operator <=(const XString &inS1, const char *pszChar2);
_XSTRING_DECL_ int operator >=(const XString &inS1, const char *pszChar2);
_XSTRING_DECL_ int operator >(const XString &inS1, const char *pszChar2);
_XSTRING_DECL_ int operator <(const XString &inS1, const char *pszChar2);

_XSTRING_DECL_ int operator ==(const char *pszChar1, const XString &inS2) ;
_XSTRING_DECL_ int operator !=(const char *pszChar1, const XString &inS2) ;
_XSTRING_DECL_ int operator <=(const char *pszChar1, const XString &inS2);
_XSTRING_DECL_ int operator >=(const char *pszChar1, const XString &inS2);
_XSTRING_DECL_ int operator >(const char *pszChar1, const XString &inS2);
_XSTRING_DECL_ int operator <(const char *pszChar1, const XString &inS2);







///////////////////////////////////////////////////////////////////
// XSplitableString



template <class T>
class XSplitableString: public XString
{
public:
	XSplitableString ();
	XSplitableString (const XSplitableString&);
	XSplitableString (const XString &);
	XSplitableString (const char*);

	~XSplitableString();

	int Split ( const XString& inSeparator, T& ) const;
	int Split ( T& ) const; // by Whitespaces

	int GetTableDatas ( T&, XSIZE_T, ... ); // last Pos must be 0!
};

template <class T>
XSplitableString<T>::XSplitableString ()
: XString()
{
}

template <class T>
XSplitableString<T>::XSplitableString (const XSplitableString& inStr)
:XString ( inStr() )
{
}


template <class T>
XSplitableString<T>::XSplitableString (const XString &inStr)
: XString (inStr)
{
}


template <class T>
XSplitableString<T>::XSplitableString (const char* inChars)
: XString (inChars)
{
}


template <class T>
XSplitableString<T>::~XSplitableString()
{
}


template <class T>
int XSplitableString<T>::Split ( const XString &inSeparator, T& inT) const
{
	
	inT.erase ( inT.begin(), inT.end());
	
	if (!GetLength()) return 0;


	XSIZE_T from=0, to;
	XString piece;
	int count = 0;

	while (from < GetLength() )
	{
		if ( !Find ( to, inSeparator, from) )
			to = GetLength();
		
		piece = Mid ( from, to-from );
		inT.insert(inT.end(), piece);
		count ++;

		to += inSeparator.GetLength();
		from = to;
	} 
	return count;
}
		

	
template <class T>
int XSplitableString<T>::Split ( T& inT) const  //by Whitespaces
{
	inT.erase ( inT.begin(), inT.end());

	if (!GetLength()) return 0;

	XSIZE_T from=0, to;
	XString item;
	int itemCount = 0;

	while ( from < GetLength() )
	{
		while ( isspace(At(from)) )
		{
			from++;
			if (from == GetLength()) return itemCount;
		}

		if (!FindWhitespace ( to, from ) ) 
			to = GetLength();

		item = Mid(from, to-from);

		inT.insert(inT.end(), item);
		itemCount++;

		from = to+1;

	}
	return itemCount;
}
	



template <class T>

int XSplitableString<T>::GetTableDatas (T& inT, XSIZE_T inPos, ... )
{
	XSIZE_T from=inPos, to, actArg;
	int count=0;
	va_list vl;
	XString piece;
	va_start (vl, inPos);

	do
	{
		actArg = va_arg(vl, XSIZE_T);
		to = ( actArg == 0 ) ? GetLength() : actArg;

		if ( to>GetLength() ) 
			piece.MakeNULL();
		else
			piece = Mid(from, to-from);
		inT.insert(inT.end(), piece);
		count ++;
		from=to;

	} while ( actArg != 0);


	va_end(vl);

	return count;
}










#endif



