/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPRecipientTable.h,v 1.3 1999/03/10 02:41:15 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <LBroadcaster.h>
#include <LTableView.h>

const MessageT	kUpdateMissingRecipientsMsg = 'URcp';

typedef enum TableItemKind
{
	kTableItemKindKey	= 1,
	kTableItemKindMissingKey
	
} TableItemKind;

typedef struct RecipientTableItem
{
	TableItemKind			itemKind;
	char					description[256];
	PGPInt8					sortGrouping;
	PGPBoolean				isMissingRecipients;
	PGPKeyRef				keyRef;
	PGPPublicKeyAlgorithm	algorithm;
	
} RecipientTableItem;


class CPGPRecipientTable : public LTableView, public LBroadcaster
{
public:

	enum { class_ID = 'RTbl' };
	
						CPGPRecipientTable(LStream *inStream);
	virtual				~CPGPRecipientTable();

	PGPError			AddKey(PGPKeyRef theKey);
	PGPError			AddMissingUserID(const char *userID);
	void				AddTableItem(RecipientTableItem *inTableItem,
								Boolean inRefresh);
	void				DrawSelf();
	
protected:

	virtual void		ClickCell(
								const STableCell		&inCell,
								const SMouseDownEvent	&inMouseDown);
	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);

private:

	LArray				*mStorageArray;
	
	void				DrawCellContents(const STableCell &inCell,
								const Rect &inLocalRect);
	void				GetCellColumnRects(const Rect *cellRect,
								Rect *iconColumnRect,
								Rect *userIDColumnRect);
	void				PrepareToDraw(void);
};

