/*____________________________________________________________________________
	Copyright (C) 1997-1999 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: MacTraps.c,v 1.5 1999/03/10 03:06:32 heller Exp $
____________________________________________________________________________*/

#include <Traps.h>

#include "MacTraps.h"

#define kToolTrapMask 0x0800

	short
NumToolboxTraps(void)
{
	if( NGetTrapAddress( _InitGraf, ToolTrap ) ==
			NGetTrapAddress( 0xAA6E, ToolTrap ) )
	{
		return( 0x0200 );
	}
	else
	{
		return( 0x0400 );
	}
}

	TrapType
GetTrapType(short theTrap)
{
	if( (theTrap & kToolTrapMask) != 0 )
	{
		return ( ToolTrap );
	}
	else
	{
		return ( OSTrap );
	}
}

	Boolean
TrapAvailable(short theTrap)
{
	TrapType	trapType;

	trapType = GetTrapType(theTrap);
	if(trapType == ToolTrap)
	{
		theTrap = theTrap & 0x07FF;
	}
	
	if ( theTrap >= NumToolboxTraps() )
	{
		theTrap = _Unimplemented;
	}
	
	return ( NGetTrapAddress( theTrap, trapType ) !=
		NGetTrapAddress( _Unimplemented, ToolTrap ) );
}

	Boolean
PFLPatchTrap(short trapNum, UniversalProcPtr newAddr, UniversalProcPtr *oldAddr)
{
	TrapType			trapType;
	
	trapType	= GetTrapType( trapNum );
	*oldAddr	= NGetTrapAddress( trapNum, trapType );
	newAddr		= (UniversalProcPtr) StripAddress( newAddr );
	
	if ( newAddr != *oldAddr )
	{
		NSetTrapAddress( newAddr, trapNum, trapType );
		return( TRUE );
	}
	
	return( FALSE );
}
