/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc. and it's affiliated companies
	All rights reserved.

	$Id: PGPsdaMacDecrypt.h,v 1.3 1999/02/26 02:14:01 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "pgpBase.h"

enum
{
	kSDAError_InvalidArchive		= 110000,
	kSDAError_IncorrectPassphrase	= 110001,
	kSDAError_ChecksumFailed		= 110002
};

typedef struct PGPsdaDecryptProgressInfo
{
	PGPUInt32	bytesProcessed;
	PGPUInt32	totalBytesToProcess;

} PGPsdaDecryptProgressInfo;

PGP_BEGIN_C_DECLARATIONS

typedef OSStatus	(*PGPsdaDecryptProgressProc)(
							const PGPsdaDecryptProgressInfo *progressInfo,
							PGPUserValue userValue);
							
void		DecryptSDA(Boolean promptForSource);
OSStatus	PGPsdaDecrypt(const FSSpec *inFileSpec,
					const FSSpec *outFolderSpec, const char *passphrase,
					PGPsdaDecryptProgressProc progressProc,
					PGPUserValue userValue);
					
PGP_END_C_DECLARATIONS
