/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPAppleEventmenu.cp,v 1.3 1999/04/21 09:21:47 jason Exp $
____________________________________________________________________________*/

#include <AEObjects.h>
#include <AEPackObject.h>
#include <AERegistry.h>

#include <UAppleEventsMgr.h>
#include <UExtractFromAEDesc.h>

#include "pgpMemoryMgr.h"
#include "pgpMem.h"

#include "StPGPRefs.h"

#include "CPGPAppleEventmenu.h"


CPGPAppleEventmenu::CPGPAppleEventmenu(
	FSSpec *			inFSSpec,
	SPGPmenuMESPData *	inMESPData)
		: CPGPAppmenu(inFSSpec, inMESPData)
{
}



CPGPAppleEventmenu::~CPGPAppleEventmenu()
{
}



	void
CPGPAppleEventmenu::Initialize()
{
	CPGPAppmenu::Initialize();
	UAppleEventsMgr::Initialize();
}



	void
CPGPAppleEventmenu::Patch()
{
	mPatchEventAvail = false;
	mPatchGetKeys = false;
	mPatchPutScrap = false;
	CPGPAppmenu::Patch();
}



	void
CPGPAppleEventmenu::DoOperation(
	EOperation	inOperation)
{
	StPGPDataRef	input;
	PGPSize			inputSize;
	StPGPDataRef	output;
	PGPSize			outputSize;
	PGPBoolean		isSelected = true;
	
	GetSelection(&input, &inputSize);
	if (inputSize == 0) {
		isSelected = false;
		GetContents(&input, &inputSize);
	}
	if (inputSize > 0) {
		switch (inOperation) {
			case op_Sign:
			{
				AppSign(input, inputSize, reinterpret_cast<char **>(&output), &outputSize);
			}
			break;
			
			
			case op_Encrypt:
			{
				PGPUInt32		numRecipients;
				StPGPDataRef	recipients;
				
				GetRecipients(&numRecipients, reinterpret_cast<PGPRecipientSpec **>(&recipients));
				AppEncrypt(numRecipients, reinterpret_cast<PGPRecipientSpec *>(
					static_cast<PGPByte *>(recipients)), input, inputSize,
					reinterpret_cast<char **>(&output), &outputSize);
			}
			break;
			
			
			case op_EncryptAndSign:
			{
				PGPUInt32		numRecipients;
				StPGPDataRef	recipients;
				
				GetRecipients(&numRecipients, reinterpret_cast<PGPRecipientSpec **>(&recipients));
				AppEncryptAndSign(numRecipients, reinterpret_cast<PGPRecipientSpec *>(
					static_cast<PGPByte *>(recipients)), input, inputSize,
					reinterpret_cast<char **>(&output), &outputSize);
			}
			break;
			
			
			case op_DecryptVerify:
			{
				AppDecryptVerify(input, inputSize, reinterpret_cast<char **>(&output),
					&outputSize);
			}
			break;
		}
		if (isSelected) {
			SetSelection(output, outputSize);
		} else {
			SetContents(output, outputSize);
		}
	}
}



	void
CPGPAppleEventmenu::GetSelection(
	PGPByte **	outData,
	PGPSize *	outDataSize)
{
	*outData = 0;
	*outDataSize = 0;
}



	void
CPGPAppleEventmenu::SetSelection(
	PGPByte *	inData,
	PGPSize		inDataSize)
{
	(void) inData;
	(void) inDataSize;
}



	void
CPGPAppleEventmenu::GetContents(
	PGPByte **	outData,
	PGPSize *	outDataSize)
{
	*outData = 0;
	*outDataSize = 0;
}



	void
CPGPAppleEventmenu::SetContents(
	PGPByte *	inData,
	PGPSize		inDataSize)
{
	(void) inData;
	(void) inDataSize;
}



	void
CPGPAppleEventmenu::GetRecipients(
	PGPUInt32 *			outNumRecipients,
	PGPRecipientSpec **	outRecipients)
{
	*outNumRecipients = 0;
	*outRecipients = 0;
}
