/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPhotoUserID.h,v 1.8 1999/03/10 02:38:55 heller Exp $
____________________________________________________________________________*/

#include <LCommander.h>
#include <LDragAndDrop.h>
#include <LPane.h>

#include "pgpJPEG.h"
#include "pgpMem.h"
#include "pgpClientShared.h"

typedef enum PGPPhotoUserIDStatus
{
	kPGPPhotoUserIDStatus_Normal	= 1,
	kPGPPhotoUserIDStatus_NoValidity,
	kPGPPhotoUserIDStatus_Revoked,
	kPGPPhotoUserIDStatus_Expired
	
} PGPPhotoUserIDStatus;

class CPhotoUserID : 	public LPane,
						public LCommander,
						public LDragAndDrop
{
public:

	enum { class_ID = 'PhID' };
	
						CPhotoUserID(LStream *inStream);
	virtual				~CPhotoUserID(void);

	OSStatus			AddPictureFromFile(const FSSpec *fileSpec);
	void				ClearPicture(void);
	virtual void		ClickSelf(const SMouseDownEvent &inMouseDown);
	virtual void		FindCommandStatus(CommandT inCommand,
								Boolean &outEnabled, Boolean &outUsesMark,
								Char16 &outMark, Str255 outName);
	OSStatus			GetPhotoData(PGPContextRef context, void **data,
								PGPSize *dataSize);
	OSStatus			GetPictureData(PicHandle *picture);
	Boolean				HavePicture(void) { return( IsntNull( mGWorld ) ); };
	virtual void		HiliteDropArea(	DragReference	inDragRef);
	Boolean				IsLocked(void) { return( mLocked ); };
	virtual Boolean		ItemIsAcceptable(DragReference inDragRef,
								ItemReference inItemRef);
	void				Lock(void) { mLocked = TRUE; };
	virtual Boolean		ObeyCommand(CommandT inCommand, void *ioParam);
	virtual void		ReceiveDragItem(DragReference inDragRef,
								DragAttributes inDragAttrs,
								ItemReference inItemRef,
								Rect &inItemBounds);
	OSStatus			SetPhotoData(PGPContextRef context,
								void *data, PGPSize dataSize,
								Boolean scaleToFit);
	OSStatus			SetPictureData(PicHandle picture, Boolean scaleToFit);
	void				SetStatus(PGPPhotoUserIDStatus status);
	virtual void		UnhiliteDropArea(DragReference inDragRef);
	void				Unlock(void) { mLocked = FALSE; };

protected:

	virtual void		DrawSelf(void);
	
private:

	Boolean					mLocked;
	Point					mGWorldSize;
	GWorldPtr				mGWorld;
	Rect					mImageRect;
	PGPPhotoUserIDStatus	mStatus;
	
	OSStatus			AllocateGWorld(Point imageSize);
	Point				CalcScaledImageSize(Point imageSize);
	OSStatus			CreateTempJPEGFile(FSSpec *fileSpec);
	void				DoDropAreaHilite(DragReference inDragRef,
								Boolean showHilite);
	void				DrawPhoto(const Rect *photoRect, SInt16 inBitDepth);
	void				FreeGWorld(void);
	OSStatus			GWorldToJPEG(JPEGCompressionContext *jpegContext);
	OSStatus			JPEGToGWorld(JPEGDecompressionContext *jpegContext);
};