/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CCAServer.h,v 1.2 1999/03/13 14:07:44 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include <LThread.h>
#include "CPGPKeys.h"

enum PGPkeysCAOp_
{
	kPGPCA_OP_RequestCert,
	kPGPCA_OP_RetrieveCert,
	kPGPCA_OP_UpdateCRL,

	PGP_ENUM_FORCE( PGPkeysCAOp_ )
};
PGPENUM_TYPEDEF( PGPkeysCAOp_, PGPkeysCAOp );

#define kPGPCA_InProgress		1


class CAThread		:	public LThread
{
public:
					CAThread(
							PGPkeysCAOp				op,
							PGPKeyRef				key,
							PGPUserIDRef			userID,
							PGPKeySetRef			keySet,
							PGPAttributeValue*		avList,
							PGPUInt32				numAVs,
							PGPEventHandlerProcPtr	eventHandler,
							PGPUserValue			userValue,
							PGPError *				outErr );
					~CAThread();
	void			*Run(void);

private:
	PGPkeysCAOp				mOp;
	PGPKeyRef				mKey;
	PGPUserIDRef			mUserID;
	PGPKeySetRef			mKeySet;
	PGPAttributeValue*		mAVList;
	PGPUInt32				mNumAVs;
	PGPEventHandlerProcPtr	mEventHandler;
	PGPUserValue			mUserValue;
};

