/*____________________________________________________________________________
	Copyright (C) 1997 Pretty Good Privacy, Inc.
	All rights reserved.
	
	$Id: pgpClientLib.h,v 1.64 1999/05/23 16:23:13 heller Exp $
____________________________________________________________________________*/

#ifndef Included_pgpClientLib_h	/* [ */
#define Included_pgpClientLib_h

#include "pgpPubTypes.h"

#include "pflPrefs.h"
#include "pgpGroups.h"
#include "pgpKeyServerPrefs.h"
#include "pgpUserInterface.h"
#include "pgpPassBuffer.h"
#include "pgpTLS.h"

PGP_BEGIN_C_DECLARATIONS

#if PRAGMA_IMPORT_SUPPORTED
#pragma import on
#endif

typedef enum PGPFileSelector
{
	kPGPFileSelector_PublicKeys	= 1,
	kPGPFileSelector_PrivateKeys,
	kPGPFileSelector_RandomSeed,
	kPGPFileSelector_Groups,
	kPGPFileSelector_KeyShares

} PGPFileSelector;

enum
{
	/* relevant signing and encryption for files */
	kPGPUISettingsTextOutput		= (1UL << 0 ),
	kPGPUISettingsNoMacBinary		= (1UL << 1),
	kPGPUISettingsSmartMacBinary	= (1UL << 2),
	kPGPUISettingsForceMacBinary	= (1UL << 3),
	
	/* encryption only */
	kPGPRecipientSettingsWipeOriginal		= (1UL << 8), /* files */
	kPGPRecipientSettingsConvEncrypt		= (1UL << 9),
	kPGPRecipientSettingsFYEO				= (1UL << 10),
	kPGPRecipientSettingsSDA				= (1UL << 11), /* files */
	
	/* signing only */
	kPGPGetPassphraseSettingsDetachedSig	= (1UL << 16)
};

enum
{
	kPGPSelectKeysImportVariation	= (1L << 0),
	kPGPSelectKeysSingleKey			= (1L << 1),

	kPGPSelectKeysDefault = 0
};

enum
{
	kPGPSelect509CanSignOnly		= (1L << 0),
	kPGPSelect509NoSplit			= (1L << 1),
	kPGPSelect509CAOnly				= (1L << 2),

	kPGPSelect509Default = 0
};

typedef PGPFlags	PGPUISettings;
typedef PGPFlags	PGPRecipientSettings;
typedef PGPFlags	PGPSelectKeysSettings;
typedef PGPFlags	PGPSelect509Settings;



/* PGPRecipientOptions */
typedef PGPFlags	PGPRecipientOptions;
enum
{
	kPGPRecipientOptionsHideFileOptions		= (1L << 0),
	kPGPRecipientOptionsAlwaysShowDialog	= (1L << 1),
	kPGPRecipientOptionsShowFYEO			= (1L << 2),
	kPGPRecipientOptionsShowSDA				= (1L << 3),

	kPGPRecipientOptionsDefault = 0
};

#define kPGPRecipientSettingsDefault		0
#define kPGPGetPassphraseSettingsDefault	0

enum
{
	kPGPGetPassphraseOptionsHideFileOptions	= (1L << 0),

	kPGPGetPassphraseOptionsDefault = 0
};

typedef PGPFlags	PGPGetPassphraseOptions;
typedef PGPFlags	PGPGetPassphraseSettings;

//	numDefaultRecipients containes the number of recipients already present
//	in the recipients list. Specify 0 for no default recipients.
//	defaultRecipients is the list of numDefaultRecipients recipients. Specify
//	nil for no default recipients.
//	dialogOptions contains programatic options for controlling dialog behavior.
//	defaultSettings contains the initial states of the dialog checkboxes.
//	userSettings contains the final states of the dialog checkboxes.
//	actualRecipients specifies the PGP encrypted
//  recipients chosen by the user. Use PGPFreeRecipientList() to delete the
//  recipient list. 

	PGPError
PGPClientRecipientDialog(
	PGPContextRef			context,					
	PGPtlsContextRef		tlsContext,
	PGPKeySetRef			allKeys,					
	PGPUInt32				numDefaultRecipients,		
	const PGPRecipientSpec	*defaultRecipients,			
	PGPRecipientOptions		dialogOptions,				
	PGPRecipientSettings	defaultSettings,
	PGPRecipientSettings	*userSettings,			
	PGPKeySetRef			*actualRecipients,			
	PGPKeySetRef			*newKeys);			
							 
			
/* caller must call PGPFreeKey() on actualSigningKey */
	PGPError
PGPClientSigningPassphraseDialog(
	PGPContextRef				context,				
	PGPKeySetRef				allKeys,				
	const char 					*prompt,				
	PGPGetPassphraseOptions		dialogOptions,			
	PGPGetPassphraseSettings	defaultSettings,		
	PGPKeyRef					defaultSigningKey,		
	char						passphrase[256],
	PGPGetPassphraseSettings	*userSettings,			
	PGPKeyRef 					*actualSigningKey);		

	PGPError
PGPClientDecryptionPassphraseDialog(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	const char			*prompt,						
	PGPKeySetRef		recipientKeys,
	const PGPKeyID		keyIDList[],		
	PGPUInt32			keyIDCount,
	PGPOptionListRef	additionalOptions,
	char				**passphrase,
	PGPKeyRef 			*decryptionKey,
	PGPKeySetRef		*newKeys);
	
	PGPError
PGPSelectKeysDialog(
	PGPContextRef			context,
	PGPSelectKeysSettings	settings,
	const char				*prompt,							
	PGPKeySetRef			fromSet,							
	PGPKeySetRef			validitySet,	/* can be NULL */
	PGPKeySetRef			*selectedSet);	/* Caller is responsible for	*/
											/* freeing selectedSet			*/
	PGPError
PGPSelect509Dialog(
	PGPContextRef			context,
	PGPSelectKeysSettings	settings,
	const char				*prompt,							
	PGPKeySetRef			fromSet,							
	PGPKeySetRef			*selectedSet,
	PGPKeyRef				*selectedKey,
	PGPSigRef				*selectedCert );

	PGPError
PGPX509CertFromExport(
	PGPContextRef		context,
	PGPUInt32			uX509Alg,
	PGPByte*			expkeyidX509,
	PGPByte*			pIASNX509,
	PGPUInt32			uX509IASNLength,
	PGPKeySetRef		keyset,
	PGPKeyRef*			pkeyX509,
	PGPSigRef*			psigX509 );

	PGPError
PGPX509CertToExport(
	PGPContextRef		context,
	PGPKeyRef			keyCert,
	PGPSigRef			sigCert,
	PGPUInt32*			puX509Alg,
	PGPByte*			pexpkeyidX509,
	PGPByte**			ppIASNX509,
	PGPUInt32*			puX509IASNLength );

	PGPError
PGPGetCACertReqAVList(
	PGPContextRef			context,
	PGPBoolean				force,
	PGPUserIDRef			userID,
	PGPKeyServerClass		serverClass,
	PGPAttributeValue **	pAVList,
	PGPUInt32 *				pNumAVs );

	PGPError
PGPFreeCACertReqAVList(
	PGPAttributeValue *	pAVList,
	PGPUInt32			numAVs );

	PGPError
PGPGetAVAttributeString(
	PGPContextRef		pgpContext,
	PGPAVAttribute		attr,
	Str255				attrStr );

/* Caller must free data with PGPFreeData */
	PGPError
PGPAVPairsToData(
	PGPMemoryMgrRef		memoryMgr, 
	PGPAttributeValue*	avPairs, 
	PGPUInt32			numAV, 
	PGPByte**			data,
	PGPSize*			dataSize);


/* Caller must supply function to free data allocated for the avPairs
   array */
	PGPError 
PGPDataToAVPairs(
	PGPMemoryMgrRef		memoryMgr, 
	PGPByte*			data,
	PGPSize				dataSize, 
	PGPAttributeValue**	avPairs, 
	PGPUInt32*			numAV);

	PGPError 
PGPParseCommonName(
	PGPMemoryMgrRef	memoryMgr, 
	char*			commonname, 
	char**			pfirstname,
	char**			pmiddlename,
	char**			plastname);

	PGPError
PGPGetKeyFromServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeyRef			key,
	PGPKeySetRef		*resultSet);

	PGPError
PGPGetKeyIDFromServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeyID const *	keyID,
	PGPKeySetRef		*resultSet);

	PGPError
PGPGetGroupFromServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPGroupSetRef		groupSet,
	PGPGroupID			groupID,
	const char			*domain,	/* if not-NULL, used for domain info */
	PGPUInt32			dialogDelayTicks,
	PGPKeySetRef		*resultSet);

	PGPError
PGPGroupListOperationOnServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeySetRef		allKeys,
	PGPBoolean			sendGroups,
	PGPGroupSetRef		*groupSet );

	PGPError
PGPSendKeyToServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeyRef			key,
	PGPKeyServerEntry	*targetServer);	/* if NULL, follows domain */
	
	PGPError
PGPGuaranteeMinimumEntropy(
	PGPContextRef		context);

	PGPError
PGPReconstitutionDialog(
	PGPKeyRef			keyToCollect,
	PGPKeySetRef		keySet, 	/* used to find decryption key for key */
									/* share files and SKEP authentication */
	PGPtlsContextRef	tlsContext,	/* can be kInvalidPGPtlsContextRef */
	PGPByte **			passKey,	/* should be freed with PGPFreeData */
	PGPSize *			passKeySize);
	
	PGPError
PGPForYourEyesOnlyDialog(
	PGPContextRef	inContext,
	const char *	inString);
	
	PGPError
PGPOutputDialog(
	PGPContextRef	inContext,
	const char *	inString,
	PGPBoolean *	outCopyToClipboard);

	PGPError
PGPConfirmRemoteKeyDialog(
	const char *			prompt,
	const char *			remoteHostName,
	PGPKeyRef				keyToConfirm,
	PGPtlsCipherSuiteNum	tlsCipher,
	PGPBoolean				askConfirm );

/*	If addedKeySetToJob is true, you will get another kPGPEvent_SignatureEvent
	for the signature. If you pass a keyset into defaultKeySet,
	PGPSignerKeyLookup will attempt to selectively import the new keys into
	your default key ring. If you pass a pointer to a keysetref into 
	newKeySet, PGPSignerKeyLookup will return the new keys.
*/
	PGPError
PGPSignerKeyLookup(
	PGPContextRef	context,
	PGPEvent *		event,				/*	the kPGPEvent_SignatureEvent */
	PGPKeySetRef	defaultKeySet,		/*	used for selective import validity
											(optional) */
	PGPBoolean *	addedKeySetToJob,	/* 	true if a keyset was added to the
											job */
	PGPKeySetRef *	newKeySet);			/*	signer key (optional) */
	
enum
{
	kPGPPrefDialog_ChangedKeyFiles 		= (1L << 0),
	kPGPPrefDialog_ChangedServerList	= (1L << 1)
};

typedef PGPFlags	PGPPrefDialogFlags;

PGPError	PGPPreferencesDialog(
					PGPContextRef 		context,
					PGPKeySetRef		allKeys,		/* Optional */
					PGPPrefRef 			clientPrefs,	/* Optional */
					PGPPrefRef 			adminPrefs,		/* Optional */
					PGPPrefDialogFlags 	*flags);		/* Optional */

typedef struct PGPClientDecodeEventHandlerData
{
	PGPContextRef			context;
	PGPtlsContextRef		tlsContext;
	PGPKeySetRef			allKeys;
	PGPKeyRef				decryptionKey;
	PGPBoolean				conventional;
	PGPBoolean				split;
	PGPPassBufferRef		passBuffer;
	PGPKeySetRef			newKeySet;
	PGPKeySetRef			recipientKeySet;
	PGPKeyID				*recipientKeyIDList;
	PGPUInt32				recipientKeyIDCount;
	char					prompt[256];
	PGPByte					*outputBuffer;
	PGPSize					outputBufferSize;
	PGPEventSignatureData	signatureData;
	PGPBoolean				signatureDataValid;
	PGPAnalyzeType			sectionType;
	
} PGPClientDecodeEventHandlerData;

PGPError	PGPInitClientDecodeEventHandlerData( PGPContextRef context,
					PGPtlsContextRef tlsContext, PGPKeySetRef allKeys,
					PGPClientDecodeEventHandlerData *data );
void		PGPCleanupClientDecodeEventHandlerData(
					PGPClientDecodeEventHandlerData *data );
PGPError	PGPClientDecodeEventHandler( PGPContextRef context,
					struct PGPEvent *event,
					PGPClientDecodeEventHandlerData *data );
Boolean		PGPClientVerifyEnvironment(void);
					
OSStatus	PGPGetClientLibFSSpec(FSSpec *fileSpec);
PGPError	PGPGetPGPFileName(PGPContextRef context, PGPFileSelector whichFile,
						StringPtr fileName);
PGPError	PGPGetPGPFileDefaultFSSpec(PGPContextRef context,
						PGPFileSelector whichFile, FSSpec *fileSpec);
PGPError	PGPSetPGPFileFSSpec(PGPContextRef context,
						PGPFileSelector whichFile, const FSSpec *fileSpec );
PGPError	PGPSelectPGPFile(PGPContextRef context, PGPFileSelector whichFile,
						FSSpec *fileSpec);
						
	PGPError
PGPCheckAutoUpdateKeysFromServer(
	PGPMemoryMgrRef	memoryMgr,
	PGPBoolean		launchKeys,
	PGPBoolean *	updateAllKeys,				/* can be NULL */
	PGPBoolean *	updateTrustedIntroducers);	/* can be NULL */
	
	PGPError
PGPRSASupported(
	PGPBoolean *	hasRSA);
	
	PGPError
PGPIsAdminConfigured(
	PGPBoolean *	isConfigured);
	
	

typedef enum PGPIconID {
	kPGPIconID_DSARevokedKey	=	3012,
	kPGPIconID_RSARevokedKey	=	3004,
	kPGPIconID_DSAExpiredKey	=	3013,
	kPGPIconID_RSAExpiredKey	=	3005,
	kPGPIconID_DSADisabledKey	=	3006,
	kPGPIconID_RSADisabledKey	=	3010,
	kPGPIconID_DSASplitKeyPair	=	3018,
	kPGPIconID_RSASplitKeyPair	=	3019,
	kPGPIconID_DSAKeyPair		=	3008,
	kPGPIconID_RSAKeyPair		=	3001,
	kPGPIconID_DSAKey			=	3007,
	kPGPIconID_RSAKey			=	3000
} PGPIconID;
	
	PGPError
PGPGetKeyIcon(
	PGPKeyRef	inKey,
	PGPIconID *	outIconID,	/* can be NULL */
	Handle *	outSuite);	/* can be NULL */
							/* free with DisposeIconSuite(outSuite, TRUE) */
	
	PGPError
PGPGetIconIDSuite(
	PGPContextRef	inContext,
	PGPIconID		inIconID,
	Handle *		outSuite);	/* free with DisposeIconSuite(outSuite, TRUE) */

	void
PGPGetHashStringEven(
	PGPByte			index,
	Str255			str );

	void
PGPGetHashStringOdd(
	PGPByte			index,
	Str255			str );



typedef struct PGPClientEncodeDecodeData *		PGPClientEncodeDecodeDataRef;
#define	kInvalidPGPClientEncodeDecodeDataRef	((PGPClientEncodeDecodeDataRef) NULL)
#define PGPClientEncodeDecodeDataRefIsValid( ref )	( (ref) != kInvalidPGPClientEncodeDecodeDataRef )

	PGPError
PGPInitClientEncodeDecode(
	PGPContextRef					inContext,
	PGPtlsContextRef				inTLSContext,
	PGPClientEncodeDecodeDataRef *	outRef);

	void
PGPCleanupClientEncodeDecode(
	PGPClientEncodeDecodeDataRef	inRef);
	
	PGPError
PGPClearClientEncodeDecodeCaches(
	PGPClientEncodeDecodeDataRef	inRef,
	PGPBoolean						inClearSigningCache,
	PGPBoolean						inClearDecryptCache);

	PGPError
PGPClientEncode(
	PGPClientEncodeDecodeDataRef	inRef,
	PGPBoolean						inSign,
	PGPGetPassphraseSettings		inSignSettings,
	PGPGetPassphraseOptions			inSignOptions,
	PGPBoolean						inUseSigningCache,
	PGPBoolean						inClearSign,
	PGPBoolean						inDataIsText,
	PGPBoolean						inEncrypt,
	PGPRecipientSettings			inEncryptSettings,
	PGPRecipientOptions				inEncryptOptions,
	PGPUInt32						inNumDefaultRecipients,
	const PGPRecipientSpec *		inDefaultRecipients,
	PGPBoolean						inArmorOutput,
	const PGPByte *					inData,
	PGPSize							inDataSize,
	PGPByte **						outData,
	PGPSize *						outDataSize);

	PGPError
PGPClientDecode(
	PGPClientEncodeDecodeDataRef	inRef,
	PGPBoolean						inUseDecryptCache,
	const PGPByte *					inData,
	PGPSize							inDataSize,
	PGPByte **						outData,
	PGPSize *						outDataSize);

PGPUInt32 PGPGetPGPPrefsUpdateCount();
void PGPIncPGPPrefsUpdateCount();

	void
PGPMakeLicenseStr(
	PGPContextRef					context,
	Str255							outLicenseStr );

		
#if PRAGMA_IMPORT_SUPPORTED
#pragma import reset
#endif

PGP_END_C_DECLARATIONS

/* Stack based class for saving and restoring thread storage */

#ifdef __cplusplus	/* [ */
class StPGPPreserveKeyServerStorage {
public:
			StPGPPreserveKeyServerStorage() : mStorage(NULL)
				{ PGPKeyServerCreateThreadStorage(&mStorage); }
			~StPGPPreserveKeyServerStorage()
				{ PGPKeyServerDisposeThreadStorage(mStorage); }

protected:
	PGPKeyServerThreadStorageRef	mStorage;
};
#endif	/* ] __cplusplus */

#endif /* ] Included_pgpClientLib_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
