/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: PGPadmin.cp,v 1.32 1999/05/23 16:51:30 heller Exp $
____________________________________________________________________________*/

#include <LGrowZone.h>
#include <PP_Messages.h>
#include <PP_Resources.h>
#include <UDrawingState.h>
#include <UGraphicUtils.h>
#include <UMemoryMgr.h>
#include <URegistrar.h>
#include <LMultiPanelView.h>
#include <LSeparatorLine.h>
#include <LCaption.h>
#include <LPopupButton.h>
#include <LPushButton.h>
#include <LStaticText.h>
#include <LEditText.h>
#include <LTextEditView.h>
#include <LCheckbox.h>
#include <LTextGroupBox.h>
#include <LWindowHeader.h>
#include <LIconControl.h>
#include <LTabGroup.h>
#include <LScrollerView.h>
#include <LScrollBar.h>

#include <LAMPushButtonImp.h>
#include <LAMPopupButtonImp.h>
#include <LAMControlImp.h>
#include <LAMStaticTextImp.h>
#include <LAMEditTextImp.h>
#include <LAMControlViewImp.h>
#include <LAMWindowHeaderImp.h>
#include <LAMTrackActionImp.h>

#include <LStdScrollBarImp.h>

#include "PowerPlantLeaks.h"

#include "pgpClientPrefs.h"
#include "pflPrefTypes.h"
#include "pgpOpenPrefs.h"
#include "pgpSDKPrefs.h"
#include "pgpMemoryMgr.h"
#include "pgpUtilities.h"
#include "pgpClientLib.h"

#include "MacEnvirons.h"
#include "MacInternet.h"
#include "CPGPStDialogHandler.h"
#include "CPicture.h"
#include "CVersionCaption.h"
#include "CWarningAlert.h"

#include "StSaveCurResFile.h"
#include "CPGPException.h"
#include "CString.h"
#include "CRestorePortColorsAttachment.h"
#include "CPanel.h"

#include "CKeyTable.h"

#include "CAdminDialog.h"
#include "PGPadmin.h"


const ResIDT	ppob_Admin		=	128;

const ResIDT	STRx_AdminApp	=	1001;
const SInt16	kURLID			=	1;
const SInt16	kCreditsID		=	2;
const SInt16	kInfoID			=	3;
const SInt16	kBadConfigID	=	4;

const ResID		ppob_About	=	131;

PGPContextRef	gPGPContext = kInvalidPGPContextRef;


	void
main(void)
{
	// Set Debugging options
	SetDebugThrow_(debugAction_Alert);
	SetDebugSignal_(debugAction_Alert);

	// Init
	InitializeHeap(3);
	UQDGlobals::InitializeToolbox(&qd);
	new LGrowZone(20000);
	
	if( PGPClientVerifyEnvironment() )
	{
		// Create our context
		PGPError	pgpErr;
		
		pgpErr = PGPNewContext( kPGPsdkAPIVersion, &gPGPContext);
		if (IsntPGPError(pgpErr)) {
			{
	#if USE_MAC_DEBUG_LEAKS
				{ CForceInitLPeriodical	temp; }
	#endif

				pgpLeaksBeginSession("PGPadmin");
				{
					CAdminApp	theApp;
				
					theApp.Run();
					URegistrar::DisposeClassTable();
				}
				pgpLeaksEndSession();
			}
			PGPFreeContext(gPGPContext);
		}
	}
}



CAdminApp::CAdminApp()
{
	// Register functions to create classes
// Suspend for first call to URegistrar
MacLeaks_Suspend();
	RegisterClass_(CAdminDialog);
MacLeaks_Resume();
	RegisterClass_(CRestorePortColorsAttachment);
	RegisterClass_(CPicture);
	RegisterClass_(CVersionCaption);
	RegisterClass_(CWarningAlert);
	RegisterClass_(LGADialog);
	RegisterClass_(LCaption);
	RegisterClass_(LMultiPanelView);
	RegisterClass_(LView);
	RegisterClass_(LTabGroup);
	RegisterClass_(LTextEditView);
	RegisterClass_(CKeyTable);
	RegisterClass_(CPanel);
	RegisterClass_(LScrollerView);
	RegisterClass_(CWarningAlert);
	RegisterClass_(LPopupButton);
	RegisterClass_(LPushButton);
	RegisterClass_(LSeparatorLine);
	RegisterClass_(LStaticText);
	RegisterClass_(LEditText);
	RegisterClass_(LCheckBox);
	RegisterClass_(LTextGroupBox);
	RegisterClass_(LWindowHeader);
	RegisterClass_(LIconControl);
	RegisterClass_(LScrollBar);

	::RegisterAppearanceClient();
	
	RegisterClassID_(LAMPushButtonImp, LPushButton::imp_class_ID);
	RegisterClassID_(LAMPopupButtonImp, LPopupButton::imp_class_ID);
	RegisterClassID_(LAMControlImp, LSeparatorLine::imp_class_ID);
	RegisterClassID_(LAMStaticTextImp, LStaticText::imp_class_ID);
	RegisterClassID_(LAMEditTextImp, LEditText::imp_class_ID);
	RegisterClassID_(LAMControlImp, LCheckBox::imp_class_ID);
	RegisterClassID_(LAMControlViewImp, LTextGroupBox::imp_class_ID);		
	RegisterClassID_(LAMWindowHeaderImp,  LWindowHeader::imp_class_ID);
	RegisterClassID_(LAMControlImp, LIconControl::imp_class_ID);
	RegisterClassID_(LAMTrackActionImp, LScrollBar::imp_class_ID);
}



CAdminApp::~CAdminApp()
{
}



void
CAdminApp::StartUp()
{
	PGPError		err;
	PGPKeySetRef	keys;
	
	PGPsdkLoadDefaultPrefs(gPGPContext);
	err = PGPOpenDefaultKeyRings( gPGPContext, 0, &keys );
	if( PGPKeySetRefIsValid( keys ) )
		PGPFreeKeySet( keys );
	if( IsPGPError( err ) )
	{
		CWarningAlert::Display(	kWAStopAlertType,
						kWAOKStyle,
						STRx_AdminApp,
						kBadConfigID );
		ObeyCommand(cmd_Quit, nil);
	}
	else
		ObeyCommand(cmd_New, nil);
}



	Boolean
CAdminApp::ObeyCommand(
	CommandT	inCommand,
	void		*ioParam)
{
	Boolean		cmdHandled = true;

	switch (inCommand) {
		case cmd_New:
		{
			LWindow *	theWindow;
			
			theWindow = LWindow::CreateWindow(ppob_Admin, this);	
			theWindow->Show();
		}
		break;


		default:
		{
			cmdHandled = LApplication::ObeyCommand(inCommand, ioParam);
		}
		break;
	}
	
	return cmdHandled;
}



	void
CAdminApp::FindCommandStatus(
	CommandT	inCommand,
	Boolean &	outEnabled,
	Boolean &	outUsesMark,
	Char16 &	outMark,
	Str255		outName)
{

	switch (inCommand) {
		default:
		{
			LApplication::FindCommandStatus(	inCommand,
												outEnabled,
												outUsesMark,
												outMark,
												outName);
		}
		break;
	}
}

	void
CAdminApp::ShowAboutBox()
{
	Boolean				didShowDialog = false;
	
	try {
		FSSpec				libraryFileSpec;
		OSStatus			err;
		StSaveCurResFile	savedResfile;
		LFile				libraryFile;

		// Open the libarary resource file at the top of the resource chain so
		// we get our pictures.
		err = PGPGetClientLibFSSpec(&libraryFileSpec);
		PGPThrowIfOSError_(err);
		libraryFile.SetSpecifier(libraryFileSpec);
		libraryFile.OpenResourceFork(fsRdPerm);

		// Handle the dialog
		{
			CPGPStDialogHandler	aboutDialog(ppob_About, this);
			LWindow				*theDialog;
			MessageT			message;
			Boolean				credits = false;
			CString				licenseStr;
			
			const MessageT		kPGPButtonMessage		= 'bPGP';
			const MessageT		kCreditsButtonMessage	= 'bCre';
			const MessageT		kOKButtonMessage		= 'bOK ';
			
			const PaneIDT		kCreditsButtonPaneID	= 'bCre';
			const PaneIDT		kAboutPicturePaneID		= 'APIC';
			const PaneIDT		kCreditsPicturePaneID	= 'CPIC';
			const PaneIDT		kBSAFEPicturePaneID		= 'RPIC';
			const PaneIDT		kLicenseCaptionID		= 'cLic';

			theDialog = aboutDialog.GetDialog();
			
			didShowDialog = true;
			
			PGPMakeLicenseStr( gPGPContext, licenseStr );
			theDialog->FindPaneByID(kLicenseCaptionID)->SetDescriptor(licenseStr);

			while ((message = aboutDialog.DoDialog()) != kOKButtonMessage) {
				if (message == kPGPButtonMessage) {
					err = OpenURL(CString(CStringFromSTRx(STRx_AdminApp, kURLID)), 'PGPa');
					PGPThrowIfOSError_(err);
				} else if (message == kCreditsButtonPaneID) {
					SInt16	buttonTitleID;
					
					if (credits) {
						theDialog->FindPaneByID(kAboutPicturePaneID)->
									Show();
						theDialog->FindPaneByID(kCreditsPicturePaneID)->
									Hide();
					#if CREDIT_RSA_BSAFE
						theDialog->FindPaneByID(kBSAFEPicturePaneID)->
									Hide();
					#endif
						buttonTitleID = kCreditsID;
					} else {
						theDialog->FindPaneByID(kCreditsPicturePaneID)->
									Show();
					#if CREDIT_RSA_BSAFE
						theDialog->FindPaneByID(kBSAFEPicturePaneID)->
									Show();
					#endif
						theDialog->FindPaneByID(kAboutPicturePaneID)->
									Hide();
						buttonTitleID = kInfoID;
					}
					
					((LControl *) theDialog->FindPaneByID(
								kCreditsButtonPaneID))->SetDescriptor(
								CString(CStringFromSTRx(STRx_AdminApp, buttonTitleID)));

					credits = ! credits;
				}
			}
		}
	}
	
	catch (...) {
	}
	
	if (! didShowDialog) {
		::SysBeep(0);
	}
}
