/*____________________________________________________________________________
	CEncryptTranslator.cp
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CEncryptTranslator.cp,v 1.28 1999/04/26 09:40:02 heller Exp $
____________________________________________________________________________*/
#include <string.h>

#include "pgpErrors.h"
#include "pgpKeys.h"
#include "MacStrings.h"
#include "MacFiles.h"
#include "MyMIMEUtils.h"
#include "TranslatorIDs.h"
#include "TranslatorUtils.h"
#include "CPGPFree.h"
#include "TranslatorFactory.h"
#include "pgpVersionHeader.h"

#include "CEncryptTranslator.h"


CEncryptTranslator::CEncryptTranslator(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	emsProgress			progressHook,
	CipherOutputType	outputType, 
	Boolean				doSign )
	: CTranslator( context, tlsContext, progressHook)
{
	mOutputType	= outputType;
	
	mDoSign		= doSign;
}




#pragma global_optimizer on


	PluginError
CEncryptTranslator::TranslateFile(
	emsTranslatorP 		trans,
	emsDataFileP 		inFile,
    emsDataFileP 		outFile,
    emsResultStatusP 	transStatus)
{
	CComboError				err;
	Boolean					usePGPMime	= ( mOutputType == kUsePGPMIME );
	char					mimeDelimiter[ kPGPMimeSeparatorSize ];
	PGPOptionListRef		options	= kInvalidPGPOptionListRef;
	PGPContextRef			c	= mContext;

	(void) trans;
	(void) transStatus;
	
	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &inFile->file,
				"\pEncryptIn" );
			
	if ( ! usePGPMime )
	{
		// use PGPMIME if we're processing anything other than text
		if ( ! MatchMIMEType( inFile->mimeInfo, "\ptext", "\pplain" ) )
		{
			usePGPMime	= true;
		}
	}
	
	
	if ( (! usePGPMime ) &&
		MatchMIMEType( inFile->mimeInfo, "\ptext", "\pplain" ) )
	{
		// only eliminate it for plain text, not text/enriched
		err.err	= EliminateMIMEHeader( c, &inFile->file );
	}
	
	
	err.pgpErr	= PGPBuildOptionList( c, &options,
		PGPOOutputLineEndType( c, kPGPLineEnd_CRLF),
		PGPOLastOption(c)
		);
		
	if ( err.IsntError() && usePGPMime )
	{
		PGPSize		mimeBodyOffset;
		
		err.pgpErr	= PGPAppendOptionList( options, 
				PGPOPGPMIMEEncoding( c, TRUE,
					&mimeBodyOffset, mimeDelimiter ),
				PGPOOmitMIMEVersion( c, TRUE),
				PGPOLastOption(c) );
	}
	
	if ( err.IsntError() )
	{
		err	= HandleEncryptSign( &inFile->file, &outFile->file, inFile->header,
				mDoSign, options, true );
	}
			
	if ( PGPOptionListRefIsValid( options ) )
		PGPFreeOptionList( options );
	
	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &outFile->file, 
				"\pEncryptFinalOut" );
		
	// finish up by creating appropriate MIME types and parameters
	// and by putting output data into appropriate format
	if ( err.IsntError() )
	{
		ConstStringPtr	mimeParamValueString	= nil;
		
		// put output data into appropriate format
		if ( usePGPMime )
		{
			err.err	= BuildEncryptedPGPMIMEType( &outFile->mimeInfo,
					mimeDelimiter );
		}
		else
		{
			err.err	= CreateMIMEType( "\ptext", "\pplain", &outFile->mimeInfo );
		}
	}


	ReportError( err );
	
	return( CComboErrorToEudoraError( err ) );
}






