/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFWindow.cp,v 1.6.10.1 1999/07/09 00:02:37 heller Exp $
____________________________________________________________________________*/
#include <UModalDialogs.h>
#include <LDisclosureTriangle.h>
#include <LBevelButton.h>
#include <LCicnButton.h>
#include <CTBUtilities.h>
#include <LBroadcaster.h>
#include <LEditText.h>
#include <PP_KeyCodes.h>
#include <string.h>
#include "CPFWindow.h"

#include "PGPFMacUtils.h"
#include "CXferWindow.h"
#include "CPFDirectoryWindow.h"
#include "PGPFoneApplication.h"
#include "CPopupSlider.h"
#include "CControlThread.h"
#include "CCoderRegistry.h"
#include "CLevelMeter.h"
#include "CMessageQueue.h"
#include "CPacketWatch.h"
#include "CGrayControls.h"
#include "CSoundInput.h"
#include "CSoundOutput.h"
#include "CPopupList.h"
#include "CTriThreshold.h"
#include "CPFTAppleTalk.h"

//	The following define the vertical pixel levels at which the main
//	window divides into beginning/intermediate/advanced.
#define FIRSTLEVELDIVIDER		83
#define SECONDLEVELDIVIDER		118
#define THIRDLEVELDIVIDER		242

CPFWindow *
CPFWindow::CreateCPFWindowStream(
	LStream *inStream)
{
	return (new CPFWindow(inStream));
}

CPFWindow::CPFWindow()
{
}

CPFWindow::CPFWindow(LStream *inStream)
	: LWindow(inStream)
{
	mState = _cs_uninitialized;
	mSpeaker = FALSE;
	mControlThread = NIL;
	mXferButton = NIL;
	mXferWindow = NIL;
	mDirWindow = NIL;
	mNumDecoders = mNumEncoders = 0;
	mDecoder = mEncoder = 0;
	mModifierKeys = 0;
	mSIUpdate = mStatUpdate = FALSE;
}

CPFWindow::~CPFWindow()
{
	short count = 0, in, ad;
	
	mControlThread->AbortSync(TRUE);
	while(!mControlResult)
	{
		LThread::GetCurrentThread()->Yield();
		//pgpAssert(++count < 100);
	}
	delete mControlQueue;
	mSoundInput->AbortSync();
	mSoundOutput->GetPlayQueue()->Send(_mt_quit);
	while(!mSoundInputResult || !mSoundOutputResult)
	{
		LThread::GetCurrentThread()->Yield();
		//pgpAssert(++count < 100);
	}
	gPGFOpts.popt.siGain=((CPopupSlider *)FindPaneByID('psMi'))->GetValue();
	CalcPortFrameRect(gPGFOpts.sysopt.pgfWindowBounds);
	PortToGlobalPoint(topLeft(gPGFOpts.sysopt.pgfWindowBounds));
	PortToGlobalPoint(botRight(gPGFOpts.sysopt.pgfWindowBounds));
	in = mIntermTriangle->GetValue();
	ad = mAdvancedTriangle->GetValue();
	if(in && ad)
		gPGFOpts.sysopt.pgfWindowState = 2;
	else if(in)
		gPGFOpts.sysopt.pgfWindowState = 1;
	else if(ad)
		gPGFOpts.sysopt.pgfWindowState = 3;
	else
		gPGFOpts.sysopt.pgfWindowState = 0;
}

void
CPFWindow::FinishCreateSelf()
{
	long defaultVolume;
	CPopupSlider *cps;
	LControl *cont;
	
	LWindow::FinishCreateSelf();
	mSoundInIcon=(LCicnButton *)FindPaneByID('ciSD');
	(mXferButton = (LCicnButton *)FindPaneByID('bXFR'))->AddListener(this);
	mStatusCaption = (LCaption *)FindPaneByID('cSta');
	mEncryptCaption = (LCaption *)FindPaneByID('cEnc');
	mLocalCaption = (LCaption *)FindPaneByID('cLAd');
	mAddrCaption = (LCaption *)FindPaneByID('cAdd');
	mLocalAddress[0]=0;
	mRIDTitleCaption = (LCaption *)FindPaneByID('cRID');
	mRIDCaption = (LCaption *)FindPaneByID('cRIN');
	mExchangeCaption = (LCaption *)FindPaneByID('cExc');
	mConButton=(LBevelButton *)FindPaneByID('bCal');
	if( mConButton )
		mConButton->AddListener(this);
	mTalkButton=(LBevelButton *)FindPaneByID('bTlk');
	if( mTalkButton )
		mTalkButton->AddListener(this);
	mNumberEdit = (LEditText *)FindPaneByID('eNum');
	mDirectoryButton = (LBevelButton *)FindPaneByID('bDir');
	if( mDirectoryButton )
		mDirectoryButton->AddListener(this);
	
	(mDecoderPopup=(CPopupList *)FindPaneByID('pDec'))->AddListener(this);
	mDecoderPopup->Hide();
	
	(mEncoderPopup=(CPopupList *)FindPaneByID('pEnc'))->AddListener(this);
	mEncoderPopup->Hide();
	
	(cps=(CPopupSlider *)FindPaneByID('psMi'))->SetValue(gPGFOpts.popt.siGain);
	cps->AddListener(this);
	::GetDefaultOutputVolume(&defaultVolume);
	(cps=(CPopupSlider *)FindPaneByID('psVo'))->SetValue(defaultVolume & 0xfff);
	cps->AddListener(this);
	(mSoundOutput = new CSoundOutput(this, (void **)&mSoundOutputResult))->Resume();
	gPacketWatch->SetSoundOutput(mSoundOutput);
	(mSoundInput = new CSoundInput(this, (CLevelMeter *)FindPaneByID('pMet'),
										(void **)&mSoundInputResult))->Resume();
	(cont=(LControl *)FindPaneByID('ttTh'))->AddListener(this);
	cont->SetValue(gPGFOpts.popt.siThreshold);
	mSoundInput->SetThreshold(gPGFOpts.popt.siThreshold);
	(mIntermTriangle=(LDisclosureTriangle *)FindPaneByID('trIn'))->AddListener(this);
	(mAdvancedTriangle=(LDisclosureTriangle *)FindPaneByID('trAd'))->AddListener(this);
	mControlQueue = new CMessageQueue(16);
	(mControlThread = new CControlThread(mControlQueue, this, mSoundInput, mSoundOutput,
										(void **)&mControlResult))->Resume();
	mSoundOutput->SetControlThread(mControlThread);
	(new CCoderRegistry(mControlThread, (void **)&mRegistryResult))->Resume();
	SetState(_cs_uninitialized);
	if(gPGFOpts.popt.alwaysListen)
		mControlQueue->Send(_mt_waitCall);
	StartIdling();
	if((gPGFOpts.sysopt.pgfWindowBounds.left > 0) ||
		(gPGFOpts.sysopt.pgfWindowBounds.top > 0))
	{
		switch(gPGFOpts.sysopt.pgfWindowState)
		{
			case 2:
				mIntermTriangle->SetValue(1);
				mAdvancedTriangle->SetValue(1);
				gPGFOpts.sysopt.pgfWindowBounds.bottom = 
					gPGFOpts.sysopt.pgfWindowBounds.top + THIRDLEVELDIVIDER;
				break;
			case 1:
				mIntermTriangle->SetValue(1);
				gPGFOpts.sysopt.pgfWindowBounds.bottom = 
					gPGFOpts.sysopt.pgfWindowBounds.top + SECONDLEVELDIVIDER;
				break;
			case 3:
				mAdvancedTriangle->SetValue(1);
			case 0:
				gPGFOpts.sysopt.pgfWindowBounds.bottom = 
					gPGFOpts.sysopt.pgfWindowBounds.top + FIRSTLEVELDIVIDER;
				break;
		}
		DoSetBounds(gPGFOpts.sysopt.pgfWindowBounds);
	}
	else
	{
		Rect bounds;
		
		CalcStandardBounds(bounds);
		bounds.bottom = bounds.top + FIRSTLEVELDIVIDER;
		DoSetBounds(bounds);
	}
	Show();
}

Boolean
CPFWindow::HandleKeyPress(
	const EventRecord	&inKeyEvent)
{
	Boolean	keyHandled = false;
	
	switch(inKeyEvent.message & charCodeMask)
	{
		case char_Enter:
		case char_Return:
			if((mState == _cs_connected) && (mControlThread->GetControlState() == _con_Phone))
				ListenToMessage(1001,NIL);
			else
				ListenToMessage(1000,NIL);
			keyHandled = true;
			break;
		default:
			keyHandled = LWindow::HandleKeyPress(inKeyEvent);
			break;
	}
	return keyHandled;
}

void
CPFWindow::SetSubs(LWindow *authWindow, LWindow *xferWindow)
{
	mAuthWindow = authWindow;
	mXferWindow = (CXferWindow *)xferWindow;
#ifdef	PGPXFER
	mControlThread->SetXferWindow(mXferWindow);
#endif
}

void
CPFWindow::ShowAuthParams(char *params)
{
	LCaption *authCaption = (LCaption *)mAuthWindow->FindPaneByID('cAut');
	
	c2pstr(params);
	authCaption->SetDescriptor((uchar *)params);
	mAuthWindow->Show();
	authCaption->Draw(NIL);
}

void
CPFWindow::HideAuthParams()
{
	mAuthWindow->Hide();
}

void
CPFWindow::ClearDecoderList()
{
	mDecoderPopup->ClearItems();
	mNumDecoders = 0;
	mDecoder = 0;
}

void
CPFWindow::SetDecoderList(uchar *decoders, short numDecoders)
{
	short i, cur;
	char s[80];
	ulong coder;

	cur = -1;
	ClearDecoderList();
	mNumDecoders = numDecoders;
	pgp_memcpy(mVoiceDecoders, decoders, numDecoders * 4);
	
	for(i=0;i<numDecoders;i++)
	{
		coder = *(ulong *)(decoders + i * 4);
		strcpy(s, mControlThread->GetCoderName(coder));
		c2pstr(s);
		mDecoderPopup->AddItem((uchar *)s);
		if(coder = mDecoder)
			cur = i;
	}
	if(cur>=0)
		mDecoderPopup->SetValue(cur);
}

void
CPFWindow::ClearEncoderList()
{
	mEncoderPopup->ClearItems();
	mNumEncoders = 0;
	mEncoder = 0;
}

void
CPFWindow::SetEncoderList(uchar *encoders, short numEncoders)
{
	short i, cur;
	char s[80];
	ulong coder;

	cur = -1;
	ClearEncoderList();
	mNumEncoders = numEncoders;
	pgp_memcpy(mVoiceEncoders, encoders, numEncoders * 4);
	for(i=0;i<numEncoders;i++)
	{
		coder = *(ulong *)(encoders + i * 4);
		strcpy(s, mControlThread->GetCoderName(coder));
		c2pstr(s);
		mEncoderPopup->AddItem((uchar *)s);
		if(coder = mEncoder)
			cur = i;
	}
	if(i>=0)
		mEncoderPopup->SetValue(cur);
}

void
CPFWindow::SetDecoder(ulong coder)
{
	short inx;
	
	for(inx=0;inx<mNumDecoders;inx++)
		if(coder == mVoiceDecoders[inx])
			mDecoderPopup->SetValue(inx);
	mDecoder = coder;
}

void
CPFWindow::SetEncoder(ulong coder)
{
	short inx;
	
	for(inx=0;inx<mNumEncoders;inx++)
		if(coder == mVoiceEncoders[inx])
			mEncoderPopup->SetValue(inx);
	mEncoder = coder;
}

// SetEncryption handles title display of the encryptor.
// They were originally written for a pre-release version of
// PGPfone which handled double-encryption.  This was later
// removed, but should it ever be put back in, these
// are already setup for it.

void
CPFWindow::SetEncryption(ulong cryptor1, ulong cryptor2)
{
	char pname[64];
	
	switch(cryptor1)
	{
		case 'CAST':
			strcpy(pname, "CAST");
			break;
		case 'TDEA':
			strcpy(pname, "TripleDES");
			break;
		case 'BLOW':
			strcpy(pname, "Blowfish");
			break;
		case 'NONE':
			strcpy(pname, "None");
			break;
		default:
			pname[0]=0;
			break;
	}
	switch(cryptor2)
	{
		case 'BLOW':
			strcat(pname, "/Blow");
			break;
		case '3DES':
			strcat(pname, "/3DES");
			break;
		default:
			break;
	}
	c2pstr(pname);
	mEncryptCaption->SetDescriptor((uchar *)pname);
	mEncryptCaption->Draw(NIL);
	mCryptor = cryptor1;
}

void
CPFWindow::ListenToMessage(MessageT inMessage, void *ioParam)
{
	ContactEntry *contact;
	Rect bounds;
	Str255 s;
	short inx;
	long codernum;
	
	switch(inMessage)
	{
		case 1000:	// Connect button
			switch(mState)
			{
				case _cs_listening:
					mControlThread->GetTransport()->AbortSync();
				case _cs_none:
				case _cs_uninitialized:
					if(IsFullDuplexMac() && (mModifierKeys & optionKey) && (mModifierKeys & controlKey))
					{
						if(mSoundInput->Recording())
						{
							mSoundInput->Record(FALSE);
							mSoundOutput->Play(FALSE);
						}
						else
						{
							mSoundInput->SetCodec(gPGFOpts.popt.prefCoder);
							mSoundOutput->SetCodec(gPGFOpts.popt.prefCoder);
							mSoundInput->SetOutput(mSoundOutput, mSoundOutput->GetPlayQueue());
							mSoundInput->Record(TRUE);
							mSoundOutput->Play(TRUE);
						}
					}
					else switch(gPGFOpts.popt.connection)
					{
						case _cme_Serial:
							if(mModifierKeys & optionKey)
								mControlQueue->SendUnique(_mt_answer);
							else
							{
								if(contact = (ContactEntry *)
												pgp_mallocclear(sizeof(ContactEntry)))
								{
									contact->method = _cme_Serial;
									mNumberEdit->GetDescriptor((uchar *)contact->phoneNumber);
									p2cstr((uchar *)contact->phoneNumber);
									if(mModifierKeys & controlKey)
										contact->phoneNumber[0]=0;
									mControlQueue->SendUnique(_mt_call, contact);
								}
							}
							break;
						case _cme_AppleTalk:
						doATalkCall:
							mNumberEdit->GetDescriptor(s);
							if(!s[0])
							{
								Point where={60,60};
								char typ[32];
								NLType nlt;
								NBPReply nbpReply;
								
								strcpy(typ, gPGPFNBPTypeStr);	c2pstr(typ);
								nlt[0].hIcon = NIL;	pstrcpy(nlt[0].typeStr, (uchar *)typ);
								memset(&nbpReply, 0, sizeof(NBPReply));
								if(nlOk == ::StandardNBP(where, "\pSelect PGPfone to call:",
															1, nlt, NIL, NIL, NIL, &nbpReply))
								{
									pstrcpy(s, nbpReply.theEntity.zoneStr);
									pstrcat(s, "\p;");
									pstrcat(s, nbpReply.theEntity.objStr);
									mNumberEdit->SetDescriptor(s);
									goto doATalkCall;
								}
								
							}
							else
							{
								for(inx = 1;inx<=s[0];inx++)
									if(s[inx] == ';' && inx != 1)
									{
										if(contact = (ContactEntry *)
											pgp_mallocclear(sizeof(ContactEntry)))
										{
											s[inx] = s[0]-inx;
											pstrcpy((uchar *)contact->nbpListener, &s[inx]);
											s[0] = inx -1;
											pstrcpy((uchar *)contact->nbpZone, s);
											p2cstr((uchar *)contact->nbpListener);
											p2cstr((uchar *)contact->nbpZone);
											contact->method = _cme_AppleTalk;
											mControlQueue->SendUnique(_mt_call, contact);
										}
									}
							}
							break;
						case _cme_Internet:
							mNumberEdit->GetDescriptor(s);
							if(!s[0])
								PGFAlert("You must enter a valid Internet address"
										" in DNS or dot notation.", 0);
							else
							{
								if(contact = (ContactEntry *)
									pgp_mallocclear(sizeof(ContactEntry)))
								{
									contact->method = _cme_Internet;
									contact->useIPSearch = 0;
									p2cstr(s);
									strcpy(contact->internetAddress, (char *)s);
									mControlQueue->SendUnique(_mt_call, contact);
								}
							}
							break;
					}
					break;
				case _cs_connected:
					mControlThread->AbortSync(FALSE);
					break;
				case _cs_calldetected:
					mControlThread->GetTransport()->Answer();
					break;
				case _cs_initializing:
				case _cs_connecting:
				case _cs_disconnecting:
					mControlThread->GetTransport()->AbortSync();
					break;
			}
			break;
		case 1001:		//	talk button
			if(mControlThread->GetControlState() == _con_Phone)
			{
				if(mSpeaker)
					mControlQueue->SendUnique(_mt_listen);
				else
					mControlQueue->SendUnique(_mt_talk);
			}
			break;
		case 1003:
			codernum = *(Int32 *)ioParam;
			if((codernum>=0) && (codernum < mNumDecoders))
				mControlQueue->SendUnique(_mt_changeDecoder, (void *)mVoiceDecoders[codernum]);
			break;
		case 1004:
			codernum = *(Int32 *)ioParam;
			if((codernum>=0) && (codernum < mNumEncoders))
				mControlQueue->SendUnique(_mt_changeEncoder, (void *)mVoiceEncoders[codernum]);
			break;
		case 1010:		// authenticate
			mAuthWindow->Hide();
			mControlThread->SetAuthentication(TRUE);
			break;
		case 'intm':
			CalcStandardBounds(bounds);
			if(*(long *)ioParam == 1)
			{
				if((LControl *)FindPaneByID('trAd')->GetValue())
				{
					bounds.bottom = bounds.top + THIRDLEVELDIVIDER;
					gPGFOpts.sysopt.pgfWindowState = 2;
				}
				else
				{
					bounds.bottom = bounds.top + SECONDLEVELDIVIDER;
					gPGFOpts.sysopt.pgfWindowState = 1;
				}
			}
			else
			{
				bounds.bottom = bounds.top + FIRSTLEVELDIVIDER;
				gPGFOpts.sysopt.pgfWindowState = 0;
			}
			DoSetBounds(bounds);
			break;
		case 'adva':
			CalcStandardBounds(bounds);
			if(*(long *)ioParam == 1)
			{
				bounds.bottom = bounds.top + THIRDLEVELDIVIDER;
				gPGFOpts.sysopt.pgfWindowState = 2;
			}
			else
			{
				bounds.bottom = bounds.top + SECONDLEVELDIVIDER;
				gPGFOpts.sysopt.pgfWindowState = 1;
			}
			DoSetBounds(bounds);
			break;
		case 'siMd':
			mSoundInput->SetGain(*(short *)ioParam);
			break;
		case 'soMd':
			mSoundOutput->SetVolume(*(short *)ioParam);
			break;
		case 'ttTh':
			mSoundInput->SetThreshold(*(long *)ioParam);
			gPGFOpts.popt.siThreshold = *(long *)ioParam;
			break;
		case 'bDir':
			if(!mDirWindow)
				mDirWindow = (CPFDirectoryWindow *)LWindow::CreateWindow(136, this);
			break;
#ifdef	PGPXFER
		case 'bXFR':
			if(!mXferWindow->IsVisible())
			{
				mXferWindow->Show();
				mXferWindow->Select();
			}
			else
				mXferWindow->Hide();
			break;
#endif
	}
}

Boolean
CPFWindow::AllowSubRemoval(LCommander *inSub)
{
	if(inSub==mDirWindow)
		mDirWindow = NIL;
	return true;
}

void
CPFWindow::ModifiersChanged(ushort modifiers)
{
	mModifierKeys = modifiers;
	ShowStatus();
}

void
CPFWindow::ShowCaller()
{
	uchar s[64];
	
	mControlThread->GetRemoteName((char *)s);
	c2pstr((char *)s);
	mRIDCaption->SetDescriptor(s);
	mNumberEdit->Hide();
	mRIDCaption->Show();
	mRIDTitleCaption->Show();
}

void
CPFWindow::ShowStatus(void)
{
	uchar *status;
	
	if( mConButton )
	switch(mState)
	{
		case _cs_none:
		case _cs_uninitialized:
		case _cs_listening:
			mLocalCaption->Hide();
			mAddrCaption->Hide();
			if(IsFullDuplexMac() && (mModifierKeys & optionKey) && (mModifierKeys & controlKey))
				mConButton->SetDescriptor("\pTest Audio");
			else switch(gPGFOpts.popt.connection)
			{
				case _cme_Internet:
					mConButton->SetDescriptor("\pConnect");
					mLocalCaption->Show();
					mAddrCaption->SetDescriptor(mLocalAddress);
					mAddrCaption->Show();
					break;
				case _cme_AppleTalk:
					mConButton->SetDescriptor("\pConnect...");
					break;
				case _cme_Serial:
					if(mModifierKeys & optionKey)
						mConButton->SetDescriptor("\pAnswer");
					else if(mModifierKeys & controlKey)
						mConButton->SetDescriptor("\pOriginate");
					else
						mConButton->SetDescriptor("\pDial");
					break;
			}
			mTalkButton->Hide();
			mDecoderPopup->Hide();
			mEncoderPopup->Hide();
			((PGPFoneApplication *)GetSuperCommander())->mTimeAttachment->SetFoneTime(FALSE);
			mRIDCaption->Hide();
			mRIDTitleCaption->Hide();
			mNumberEdit->Show();
			SetLatentSub(mNumberEdit);
			SwitchTarget(mNumberEdit);
			mNumberEdit->SelectAll();
			break;
		case _cs_connected:
			mLocalCaption->Hide();
			mAddrCaption->Hide();
			if(mControlThread->GetControlState() == _con_Phone)
			{
				SetSpeaker(mSpeaker, mFullDuplex);
				mTalkButton->Show();
				mDecoderPopup->Show();
				mEncoderPopup->Show();
			}
			else
			{
				mConButton->SetDescriptor("\pHangup");
				mTalkButton->Hide();
				mDecoderPopup->Hide();
				mEncoderPopup->Hide();
			}
			((PGPFoneApplication *)GetSuperCommander())->mTimeAttachment->SetFoneTime(TRUE);
			ShowCaller();
			break;
		case _cs_calldetected:
			mConButton->SetDescriptor("\pAnswer");
			ShowCaller();
			break;
		case _cs_connecting:
		case _cs_disconnecting:
		case _cs_initializing:
			if(mState == _cs_initializing)
				mConButton->SetDescriptor("\pCancel");
			else
				mConButton->SetDescriptor("\pHangup");
			mTalkButton->Hide();
			mDecoderPopup->Hide();
			mEncoderPopup->Hide();
			((PGPFoneApplication *)GetSuperCommander())->mTimeAttachment->SetFoneTime(FALSE);
			break;
	}
	switch(mState)
	{
		case _cs_listening:
			status = "\pWaiting for call";
			break;
		case _cs_none:
		case _cs_uninitialized:
			status = "\pIdle";
			break;
		case _cs_connected:
			switch(mControlThread->GetControlState())
			{
				default:
				case _con_Configuring:
					status = "\pConfiguring";
					break;
				case _con_Phone:
					if(mCryptor == 'NONE')
						status = "\pInsecure call";
					else
						status = "\pSecure call";
					break;
				case _con_Disconnecting:
					status = "\pConfirming Hangup";
					break;
			}
			break;
		case _cs_calldetected:
			status = "\pRinging";
			break;
		case _cs_connecting:
			status = "\pConnecting";
			break;
		case _cs_disconnecting:
			status = "\pDisconnecting";
			break;
		case _cs_initializing:
			status = "\pInitializing modem";
			break;
	}
	mStatusCaption->SetDescriptor(status);
	mStatusCaption->Draw(NIL);
}

void
CPFWindow::AllowXfers(Boolean allow)
{
	if(allow)
		mXferButton->Show();
	else
	{
		mXferButton->Hide();
		mXferWindow->Hide();
	}
}

void
CPFWindow::SetKeyExchange(char *exchangeStr)
{
	Str255 s;
	
	strcpy((char *)s, exchangeStr);
	c2pstr((char *)s);
	mExchangeCaption->SetDescriptor(s);
}

void
CPFWindow::AECall(Str255	phone)
{
	if((mState == _cs_none) || (mState == _cs_uninitialized) ||
		(mState == _cs_listening))
	{
		mNumberEdit->SetDescriptor(phone);
		if(gPGFOpts.popt.connection != _cme_Internet)
		{
			gPGFOpts.popt.connection = _cme_Internet;
			mControlThread->ResetTransport();
		}
		ListenToMessage(1000, NIL);
	}
	else
		PGFAlert("PGPfone is not ready to make a call right now.", 0);
}


void
CPFWindow::DirectoryCall(DirectoryEntry *dirEntry)
{
	mDirWindow = NIL;
	if((mState == _cs_none) || (mState == _cs_uninitialized) ||
		(mState == _cs_listening))
	{
		mNumberEdit->SetDescriptor(dirEntry->address);
		if(gPGFOpts.popt.connection != dirEntry->connection)
		{
			gPGFOpts.popt.connection = dirEntry->connection;
			mControlThread->ResetTransport();
		}
		ListenToMessage(1000, NIL);
	}
	else
		PGFAlert("PGPfone is not ready to make a call right now.", 0);
}

void
CPFWindow::SetSoundInStatus(Boolean sending)
{
	// This could be called during interrupts, only do safe stuff
	if(sending != mSoundInOn)
	{
		mSIUpdate = TRUE;
		mSoundInOn = sending;
	}
}

void
CPFWindow::SpendTime(const EventRecord &/* inMacEvent */)
{
	if(mStatUpdate)
		ShowStatus();
	if(mSIUpdate)
	{
		if(mSoundInOn)
			mSoundInIcon->SetCicns(2049,0);
		else
			mSoundInIcon->SetCicns(2048,0);
		mSoundInIcon->Draw(NIL);
	}
	mSIUpdate = mStatUpdate = FALSE;
}

void
CPFWindow::SetState(enum CSTypes newState)
{
	mState = newState;
	mStatUpdate = TRUE;
}

void
CPFWindow::SetLocalAddress(uchar *localAddr)
{
	pstrcpy(mLocalAddress, localAddr);
	mStatUpdate = TRUE;
}

void
CPFWindow::SetSpeaker(Boolean speaker, Boolean fullDuplex)
{
	mSpeaker = speaker;
	mFullDuplex = fullDuplex;
	if( !mTalkButton )
		return;
	if(speaker)
	{
		if(fullDuplex)
			mTalkButton->SetDescriptor("\pMute");
		else
			mTalkButton->SetDescriptor("\pTalk Now(Click to Listen)");
	}
	else
	{
		if(fullDuplex)
			mTalkButton->SetDescriptor("\pUnmute");
		else
			mTalkButton->SetDescriptor("\pClick to Talk");
	}
}

enum CSTypes
CPFWindow::GetState()
{
	return mState;
}

