/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPDiskPreferences.c,v 1.7 1999/05/05 23:26:00 heller Exp $
____________________________________________________________________________*/

#include "pgpMacMemory.h"
#include "MacStrings.h"

#include "pgpClientPrefs.h"
#include "PGPDisk.h"
#include "PGPDiskPreferences.h"
#include "PGPDiskResources.h"
#include "PGPDiskUtils.h"
#include "PGPOpenPrefs.h"
#include "SleepAlert.h"

const OSType	kPrefsMagic 		= 'Pref';
const UInt8		kPrefsMajorVersion	= 0x01;
const UInt8		kPrefsMinorVersion	= 0x01;


PGPDiskPrefs	gPGPDiskPrefs;

	static void
InitDefaultPreferences(PGPDiskPrefs *prefs)
{
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	pgpClearMemory( prefs, sizeof( *prefs ) );
	
	prefs->magic 		= kPrefsMagic;
	prefs->majorVersion	= kPrefsMajorVersion;
	prefs->minorVersion	= kPrefsMinorVersion;
	
	prefs->driverPrefs.unmountDrivesOnPBSleep	= TRUE;
	prefs->driverPrefs.unmountAfterIdleTime		= TRUE;
	prefs->driverPrefs.unmountIdleTimeSeconds	= 15 * 60UL;	/* 15 minutes */
	prefs->driverPrefs.warnSleepUnmountFailed	= TRUE;
	
	prefs->newDiskDefaultSize	= 10;
	prefs->newDiskDefaultIsMB	= TRUE;
	prefs->mainWindowLocation.v	= 0;
	prefs->mainWindowLocation.h	= 0;
}

	void
WritePreferences(const PGPDiskPrefs *prefs)
{
	PGPError		err;
	PGPMemoryMgrRef	memoryMgr;
	
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	err = PGPNewMemoryMgr( 0, &memoryMgr );
	if( IsntPGPError( err ) ) 
	{
		PGPPrefRef		clientPrefsRef;
		
		err = PGPOpenClientPrefs( memoryMgr, &clientPrefsRef );
		if( IsntPGPError( err ) )
		{
			err = PGPSetPrefData( clientPrefsRef, kPGPPrefPGPdiskMacPrivateData,
						sizeof( *prefs ), prefs );
						
			(void) PGPSavePrefFile( clientPrefsRef );
			(void) PGPClosePrefFile( clientPrefsRef );
		}

		PGPFreeMemoryMgr( memoryMgr );
	}
	
	CopySleepAlertToPrefs();

	pgpAssertNoErr( err );
}

	void
ReadPreferences(PGPDiskPrefs *prefs)
{
	PGPError		err;
	PGPMemoryMgrRef	memoryMgr;
	Boolean			gotPrefs = FALSE;
	
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	err = PGPNewMemoryMgr( 0, &memoryMgr );
	if( IsntPGPError( err ) ) 
	{
		PGPPrefRef		clientPrefsRef;
		
		err = PGPOpenClientPrefs( memoryMgr, &clientPrefsRef );
		if( IsntPGPError( err ) )
		{
			void	*prefData;
			PGPSize	prefDataLength;
			
			err = PGPGetPrefData( clientPrefsRef, kPGPPrefPGPdiskMacPrivateData,
						&prefDataLength, &prefData );
			if( IsntPGPError( err ) )
			{
				PGPDiskPrefs	*checkPrefs = (PGPDiskPrefs *) prefData;
				
				if( checkPrefs->magic == kPrefsMagic &&
					checkPrefs->majorVersion <= kPrefsMajorVersion )
				{
					pgpCopyMemory( checkPrefs, prefs, sizeof( *prefs ) );
					gotPrefs = TRUE;
				}
				
				(void) PGPDisposePrefData( clientPrefsRef, prefData );
			}
				
			(void) PGPClosePrefFile( clientPrefsRef );
		}

		PGPFreeMemoryMgr( memoryMgr );
	}

	if( ! gotPrefs )
	{
		InitDefaultPreferences( prefs );
	}
}

	OSStatus
SendPreferencesToAllDrivers(const PGPDiskDriverPrefs *driverPrefs)
{
	OSStatus		err	= nsDrvErr;
	const ushort	kMaxDrivers	= 100;
	short			driverRefNums[ kMaxDrivers ];
	ushort 			numDrivers;
	
	pgpAssertAddrValid( driverPrefs, PGPDiskDriverPrefs );

	GetAllPGPDiskDrivers( driverRefNums, kMaxDrivers, &numDrivers);
	for( ushort driverIndex = 0; driverIndex < numDrivers; ++driverIndex )
	{
		OSStatus	tempErr;
		
		tempErr = SendPreferencesToDriver( driverRefNums[ driverIndex ],
						driverPrefs );
		if( IsErr( tempErr ) && IsntErr( err ) )
			err = tempErr;
	}
		
	return( err );
}

