/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CNewDiskWizardDialog.h,v 1.10 1999/05/19 07:23:59 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include <LBroadcaster.h>
#include <LPeriodical.h>

#include "pgpKeys.h"

#include "CComboError.h"
#include "CPGPDiskDialog.h"
#include "MacSecureMemory.h"

// It is assumed that this enum is kept in user presentation order.
typedef enum NewDiskView
{
	kNewDiskView_Invalid			= 1,
	kNewDiskView_Introduction,
	kNewDiskView_GetInfo,
#if PGP_BUSINESS_SECURITY
	kNewDiskView_ADKWarning,
#endif
	kNewDiskView_GetPassphrase,
	kNewDiskView_GatherRandomData,
	kNewDiskView_Formatting,
	kNewDiskView_Error,
	kNewDiskView_Conclusion,
	kNewDiskView_Exit				// Not a real view
	
} NewDiskView;

class CPassphraseEdit;
class LCheckBox;
class LProgressBar;
class LPushButton;

class CNewDiskWizardDialog : 	public CPGPDiskDialog,
								public LPeriodical
{
public:
	enum { class_ID = 'NDsk' };
	
						CNewDiskWizardDialog(LStream *inStream);
	virtual				~CNewDiskWizardDialog();

	virtual	void		ListenToMessage(MessageT inMessage, void *ioParam);
	virtual void		SpendTime(const EventRecord &inMacEvent);
	void				SetParams( PGPContextRef context ) { mContext = context; }
	
#if PGP_BUSINESS_SECURITY
	void				SetADK(PGPKeySetRef keySet, PGPKeyRef adkRef);
#endif

	static void			SetNewView(NewDiskView newView);

protected:

	virtual	void		FinishCreateSelf(void);

private:

	NewDiskView			mCurrentView;
	LView				*mCurrentViewObj;
	LPushButton			*mNextButton;
	LPushButton			*mPreviousButton;
	LPushButton			*mCancelButton;
	Str32				mDiskName;
	UInt32				mDiskSize;
	Boolean				mDiskSizeIsMB;
	FSSpec				mDiskFileSpec;
	ScriptCode			mDiskFileScript;
	CSecurePString255	mPassphrase;
	Boolean				mCollectingRandomData;
	Boolean				mFormattingNewDisk;
	UInt32				mRandomDataCount;
	
	LEditText			*mDiskNameEdit;
	LEditText			*mDiskSizeEdit;
	
	CPassphraseEdit		*mPassphraseEdit;
	CPassphraseEdit		*mConfirmationEdit;
	LCheckBox			*mHideTypingCheckbox;
	LProgressBar		*mQualityProgressBar;
	
	LProgressBar		*mRandomDataProgressBar;
	PGPContextRef		mContext;

#if PGP_BUSINESS_SECURITY
	PGPKeySetRef		mAllKeys;
	PGPKeyRef			mADKRef;
#endif

	static NewDiskView	mNewView;
	static CComboError	mNewDiskError;
	static LProgressBar	*mFormattingProgressBar;
	
	void				AdjustControlsForView(NewDiskView theView);
	void				EnterGetInfoView(void);
	void				EnterGetPassphraseView(void);
	void				EnterView(NewDiskView newView);
	NewDiskView			GetNextView(NewDiskView theView);
	NewDiskView			GetPreviousView(NewDiskView theView);
	NewDiskView			LeaveCurrentView(NewDiskView newView);
	NewDiskView			LeaveGetInfoView(NewDiskView newView);
	NewDiskView			LeaveGetPassphraseView(NewDiskView newView);
	void				SwitchToView(NewDiskView newView);
	Boolean				ValidateCurrentView(void);
	
	static OSStatus		NewDiskProgressProc(UInt32 pctComplete,
								void *userValue);
};

