/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CSocket.h,v 1.15.10.1 1998/11/12 03:22:36 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include <map>
#include <set>

#include <OpenTransport.h>
#include <OpenTptInternet.h>
#include <Threads.h>

#define PGP_MACINTOSH 1
#include "pgpBinaryTree.h"
#include "PGPSockets.h"
#include "CInternetUtilities.h"
#include "pgpTLS.h"

class CInternetUtilities;
struct SThreadContext {
	Boolean					isBusy;
	PGPError				lastError;
	char					hNameBuffer[kMaxHostNameLen + 1];
	char **					hAliasesBuffer;
	UInt32 *				hAddressesListBuffer[kMaxHostAddrs];
	UInt32					hAddressesBuffer[kMaxHostAddrs];
	PGPHostEntry			hostEntry;
	PGPProtocolEntry		protocolEntry;
	PGPServiceEntry			serviceEntry;
	char					dottedStringBuffer[17];
	PGPEventHandlerProcPtr	idleEventHandler;
	PGPUserValue			idleEventHandlerData;
};

class CSocket {
public:
	static void						Initialize();

	static void						SetIdleEventHandler(
										PGPEventHandlerProcPtr inCallback,
										PGPUserValue inUserData);
	static void						GetIdleEventHandler(
										PGPEventHandlerProcPtr * outCallback,
										PGPUserValue * outUserData);
	static PGPError					CallIdleEventHandler();
	
	static void						CreateThreadStorage(
										SThreadContext ** outContext);
	static void						DisposeThreadStorage(
										SThreadContext * inContext);

	static CSocket *				CreateSocket(SInt32 inType);
	static Boolean					VerifyPGPSocketRef(CSocket * inSocketRef);
	static void						CleanupSockets();

	static SInt32					Select(PGPSocketSet * ioReadSet,
										PGPSocketSet * ioWriteSet,
										PGPSocketSet * ioErrorSet,
										const PGPSocketsTimeValue * inTimeout);
									
	static SThreadContext *			GetThreadContext();
	
									CSocket();
	virtual							~CSocket();
	
	virtual void					Bind(const PGPSocketAddressInternet *
											inAddress) = 0;
	virtual void					Connect(const PGPSocketAddressInternet *
											inAddress) = 0;
	virtual SInt32					Send(const void * inBuffer,
										SInt32 inLength,
										SInt32 inFlags) = 0;
	virtual SInt32					SendTo(const void * inBuffer,
										SInt32 inLength,
										const PGPSocketAddressInternet *
												inAddress) = 0;
	virtual SInt32					Receive(void * outBuffer, SInt32 inLength,
										SInt32 inFlags) = 0;
	virtual SInt32					ReceiveFrom(void * outBuffer,
										SInt32 inSize,
										PGPSocketAddressInternet * outAddress,
										SInt32 * ioAddressLength) = 0;
	virtual void					Listen(SInt32 inMaxBacklog) = 0;
	virtual CSocket *				Accept(
										PGPSocketAddressInternet * outAddress,
										SInt32 * ioAddressLength) = 0;
	virtual void					Close() = 0;
	
	virtual void					GetSocketName(PGPSocketAddressInternet *
										outName) = 0;
	virtual void					GetPeerName(PGPSocketAddressInternet *
										outName) = 0;
	
	virtual void					IOControlSocket(SInt32 inCommand,
										UInt32 * ioParam) = 0;
	virtual void					GetSocketOptions(SInt32 inOptionName,
										SInt32 * outOptionValue);
										
	virtual SInt16					GetSocketType() { return mSocketType; }
										
	virtual Boolean					HasTLSSession()
										{ return mTLSSession != 
										  kInvalidPGPtlsSessionRef; }
	virtual void					SetTLSSession(PGPtlsSessionRef inSession)
										{ mTLSSession = inSession; }
	virtual PGPtlsSessionRef		GetTLSSession()
										{ return mTLSSession; }
										
	virtual Boolean					IsInCallback()
										{ return mInCallback; }
										
	static CInternetUtilities *		sInternetUtilities;

protected:
	static Boolean					sInitialized;
	static Boolean					sUseOT;
	
	static set<CSocket *>			sSocketsSet;
	static map<ThreadID, SThreadContext>	sThreadContextMap;
	
	SInt16							mSocketType;
	Boolean							mInCallback;
	
	PGPtlsSessionRef				mTLSSession;
	
	virtual Boolean					IsReadable() = 0;
	virtual Boolean					IsWriteable() = 0;
	virtual Boolean					IsError() = 0;
	
	virtual Boolean					IsListening() { return false; }
};