/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CMacTCPTCPSocket.h,v 1.7.10.1 1998/11/12 03:22:28 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CMacTCPInternetSocket.h"




class CMacTCPTCPSocket : public CMacTCPInternetSocket {
public:
							CMacTCPTCPSocket();
	virtual					~CMacTCPTCPSocket();
	
	virtual void			Connect(const PGPSocketAddressInternet *
									inAddress);
	virtual SInt32			Send(const void * inBuffer, SInt32 inLength,
								SInt32 inFlags);
	virtual SInt32			SendTo(const void * inBuffer, SInt32 inLength,
								const PGPSocketAddressInternet * inAddress);
	virtual SInt32			Receive(void * outBuffer, SInt32 inLength,
								SInt32 inFlags);
	virtual SInt32			ReceiveFrom(void * outBuffer, SInt32 inSize,
								PGPSocketAddressInternet * outAddress,
								SInt32 * ioAddressLength);
	virtual void			Listen(SInt32 inMaxBacklog);
	virtual CSocket *		Accept(PGPSocketAddressInternet * outAddress,
								SInt32 * ioAddressLength);
								
	virtual void			IOControlSocket(SInt32 inCommand,
								UInt32 * ioParam);

	virtual void			GetSocketName(PGPSocketAddressInternet * outName);
	virtual void			GetPeerName(PGPSocketAddressInternet * outName);

protected:
	StreamPtr				mStream;
	Boolean					mIsListening;
	char *					mReceiveBuffer;
	Boolean					mConnectionAborted;
	TCPNotifyUPP			mNotifyProcUPP;
	TCPiopb					mListenParams;
	CMacTCPTCPSocket *		mFirstListenQ;
	CMacTCPTCPSocket *		mLastListenQ;
	CMacTCPTCPSocket *		mNext;

	virtual Boolean			IsReadable();
	virtual Boolean			IsWriteable();
	virtual Boolean			IsError() { return mConnectionAborted; }

	virtual Boolean			IsListening() { return mIsListening; }
	
	void					PushListenQ();
	
	static pascal void		TCPNotifyProc(StreamPtr inTCPStream,
								UInt16 inEventCode,
								Ptr inUserData, UInt16 inTermReason,
								struct ICMPReport * inICMPMsg);
};

