/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CUserIDTable.h,v 1.9.12.1 1998/11/12 03:20:56 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <string.h>

#include <LBroadcaster.h>
#include <LCommander.h>
#include <LDragAndDrop.h>
#include <LTableView.h>

#include "pgpMem.h"

#include "pgpUserInterface.h"
#include "pgpKeys.h"
#include "pgpGroups.h"

const short 	kMaxKeypressInterval	= 60;
const short		kMaxSearchStringSize	= 64;

struct PGPRecipientUser;

class	CUserIDTable :	public LTableView,
						public LBroadcaster,
						public LCommander,
						public LDragAndDrop
{
public:

	enum { class_ID = 'UItv' };
	
						CUserIDTable(LStream *inStream);
	virtual				~CUserIDTable();
	static CUserIDTable *CreateFromStream(LStream *inStream);

	virtual Boolean		AllowTargetSwitch(LCommander *inNewTarget);
	virtual void		ApplyForeAndBackColors() const;
	void				DisallowSelections(void);
	void				DrawSelf();
	void				FinishCreateSelf();
	void				GetCellUser(const STableCell &inCell,
								PGPRecipientUser **tableItemPtr) const;
	LArray				*GetStorageArray(void) { return( mStorageArray ); };
	Boolean				HandleKeyPress(const EventRecord&	inKeyEvent);
	virtual Boolean		ObeyCommand(CommandT inCommand, void *ioParam);
	virtual void		ResizeFrameBy(Int16 inWidthDelta, Int16 inHeightDelta,
									Boolean inRefresh);
	void				SetAllowDeleteKeyToSend(Boolean allowSend)
									{ mDeleteSendsMessage = allowSend; };
	void				SetCellUser(const STableCell &inCell,
									const PGPRecipientUser *tableItemPtr);
	void				SetPreferences(Boolean showMarginalValidity,
									Boolean	marginalIsInvalid);

protected:

	virtual void		ClickCell(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
	virtual void		ClickSelf(
								const SMouseDownEvent	&inMouseDown);
	virtual void		DisableSelf(void);
	virtual void		DontBeTarget();
	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);
	virtual void		EnableSelf(void);
	virtual void		HiliteCellActively(
								const STableCell		&inCell,
								Boolean					inHilite);
	virtual void		HiliteCellInactively(
								const STableCell		&inCell,
								Boolean					inHilite);
	virtual Boolean		ItemIsAcceptable( DragReference inDragRef,
								ItemReference 			inItemRef );
	virtual void		ReceiveDragItem( DragReference inDragRef,
								DragAttributes inDragAttrs,
								ItemReference inItemRef,
								Rect &inItemBounds );
	virtual void		UnhiliteDropArea(DragReference	inDragRef);

private:

	PGPUInt32			mLastClickTime,
						mLastKeypress;
	STableCell			mLastClickCell;
	char				mSearchString[kMaxSearchStringSize];
	LArray				*mStorageArray;
	Boolean				mDeleteSendsMessage;
	PixPatHandle		mBarberPixPat;
	Boolean				mShowMarginalValidity;
	Boolean				mMarginalIsInvalid;
	
	void				DragSelectedCells(const EventRecord& inMacEvent);
	void				DrawCellContents(const STableCell &inCell,
								const Rect &inLocalRect,
								UInt32 inBitDepth);
	void				DrawValidity(const PGPRecipientUser *tableItem,
								const Rect *columnRect,
								UInt16 bitDepth);
	void				GetCellColumnRects(const Rect *cellRect,
								Rect *iconColumnRect,
								Rect *userIDColumnRect,
								Rect *validityColumnRect,
								Rect *keySizeColumnRect);
	void				SelectSearchString(void);
};

