/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPUIGrafPortView.cp,v 1.3.12.1 1998/11/12 03:20:51 heller Exp $
____________________________________________________________________________*/

#include "MacStrings.h"
#include "pgpDialogs.h"
#include "pgpMem.h"

#include "CPGPUIGrafPortView.h"

CPGPUIGrafPortView::CPGPUIGrafPortView(LStream *inStream)
	: CPGPModalGrafPortView(inStream)
{
	mOptions 	= NULL;
	mContext	= kInvalidPGPContextRef;
}

CPGPUIGrafPortView::~CPGPUIGrafPortView()
{
}

	PGPError
CPGPUIGrafPortView::SetOptions(
	PGPContextRef 		context,
	CPGPDialogOptions 	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	PGPValidateParam( PGPContextRefIsValid( context ) );
	PGPValidatePtr( options );
	
	mContext = context;
	mOptions = options;
	
	if( IsntNull( options->mWindowTitle ) )
	{
		Str255	title;

		CToPString( options->mWindowTitle, title );
		SetWTitle( GetMacPort(), title );
	}

	return( err );
}