/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPKeyPassphraseGrafPort.h,v 1.6.10.1 1998/11/12 03:20:32 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPPassphraseGrafPortView.h"

class CPGPKeyPassphraseGrafPortView : public CPGPPassphraseGrafPortView
{
public:

	enum
	{
		class_ID 			= 'KPGP',

		kKeyIDTextPaneID	= 'cKey'
	};

						CPGPKeyPassphraseGrafPortView(LStream *inStream);
	virtual				~CPGPKeyPassphraseGrafPortView();

	PGPError			SetOptions(PGPContextRef context,
							CPGPKeyPassphraseDialogOptions *options);
							
protected:

	virtual PGPKeyRef	GetPassphraseKey(void);
	virtual MessageT	HandleMessage(MessageT theMessage);
	virtual Boolean		VerifyPassphrase(void);
	
private:

	const CPGPKeyPassphraseDialogOptions		*mOptions;
};

class CPGPKeySetPassphraseGrafPortView : public CPGPKeyPassphraseGrafPortView
{
public:

	enum
	{
		class_ID = 'KSPG'
	};

						CPGPKeySetPassphraseGrafPortView(LStream *inStream);
	virtual				~CPGPKeySetPassphraseGrafPortView();

	PGPError			SetOptions(PGPContextRef context,
							CPGPKeySetPassphraseDialogOptions *options);
							
protected:

	virtual PGPKeyRef	FindKeyForPassphrase(PGPKeySetRef keySet,
								const char *passphrase) = 0;
	virtual Boolean		VerifyPassphrase(void);
	
private:

	const CPGPKeySetPassphraseDialogOptions		*mOptions;
};
