/*____________________________________________________________________________
	MacQuickdraw.c
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: MacQuickdraw.c,v 1.6.12.1 1998/11/12 03:19:45 heller Exp $
____________________________________________________________________________*/

#include "MacQuickdraw.h"
#include "pgpDebug.h"

/*____________________________________________________________________________
	Align one rectangle inside another
____________________________________________________________________________*/

	void
AlignRect(const Rect *staticRect, Rect *alignRect, RectAlignment howToAlign)
{
	short	vOffset = 0;
	short	hOffset = 0;

	pgpAssertAddrValid( staticRect, Rect );
	pgpAssertAddrValid( alignRect, Rect );
	
	if( ( howToAlign & kAlignAtTop ) != 0 )
	{
		vOffset = staticRect->top - alignRect->top;
	}
	else if( ( howToAlign & kAlignAtBottom ) != 0 )
	{
		vOffset = staticRect->bottom - alignRect->bottom;
	}
	else if( ( howToAlign & kAlignAtVerticalCenter ) != 0 )
	{
		vOffset = ( ( staticRect->top + staticRect->bottom ) -
						( alignRect->top + alignRect->bottom ) ) / 2;
	}

	if( ( howToAlign & kAlignAtLeft ) != 0 )
	{
		hOffset = staticRect->left - alignRect->left;
	}
	else if( ( howToAlign & kAlignAtRight ) != 0 )
	{
		hOffset = staticRect->right - alignRect->right;
	}
	else if( ( howToAlign & kAlignAtHorizontalCenter ) != 0 )
	{
		hOffset = ( ( staticRect->left + staticRect->right ) -
						( alignRect->left + alignRect->right ) ) / 2;
	}
	
	OffsetRect( alignRect, hOffset, vOffset );
}

/*
** 	The following three routines have been liberally borrowed from Apple's
**	Appearance Manager SDK sample code.
**
**	Gets the current drawing environment and stores the data in state.
**	We copy pen and back pix pats only if they are not type 0 (plain ol
**	expanded black and white patterns).
*/

	void
GetColorAndPenState( ColorPenState* state )
{
	GrafPtr			curPort;
	
	GetPort( &curPort );
	
	state->pnPixPat = nil;
	state->bkPixPat = nil;

	state->colorPort = IsColorGrafPort( curPort );

	state->bkPat = curPort->bkPat;
	state->bkColor = curPort->bkColor;
	state->fgColor = curPort->fgColor;

	if ( state->colorPort )
	{
		GetForeColor( &state->foreColor );
		GetBackColor( &state->backColor );
		
			/*
			** If the pen pattern is not an old style pattern,
			** copy the handle. If it is an old style pattern,
			** GetPenState below will save the right thing.
			*/
			
		if ( (**((CGrafPtr)curPort)->pnPixPat).patType != 0 )
		{
			state->pnPixPat = ((CGrafPtr)curPort)->pnPixPat;
		}
		
			/*
			** If the pen pattern is not an old style pattern,
			** copy the handle, else get the old pattern into
			** bkPat for restoring that way.
			*/
			
		if ( (**((CGrafPtr)curPort)->bkPixPat).patType != 0 )
		{
			state->bkPixPat = ((CGrafPtr)curPort)->bkPixPat;
		}
		else
		{
			state->bkPat =
				*(PatPtr)(*(**((CGrafPtr)curPort)->bkPixPat).patData);
		}
	}
		
	GetPenState( &state->pen );
	state->textMode = curPort->txMode;
}

/* Sets the current drawing environment based on the data in state. */

	void
SetColorAndPenState( ColorPenState* state )
{
	GrafPtr		curPort;
	
	GetPort( &curPort );

	SetPenState( &state->pen );

	if ( IsColorGrafPort( curPort ) && state->colorPort )
	{
		RGBForeColor( &state->foreColor );
		RGBBackColor( &state->backColor );

		if ( state->pnPixPat )
			PenPixPat( state->pnPixPat );

		if ( state->bkPixPat )
			BackPixPat( state->bkPixPat );
		else
			BackPat( &state->bkPat );
	}
	else
	{
		BackPat( &state->bkPat );
		ForeColor( state->fgColor );
		BackColor( state->bkColor );
	}

	TextMode( state->textMode );
}

/* Sets up our environment to standard drawing fare. */

	void
NormalizeColorAndPen()
{
	RGBColor		black, white;
	Pattern			whitePat ={ 0x00, };
	GrafPtr			curPort;
	
	GetPort( &curPort );
	
	black.red = black.green = black.blue = 0x0000;
	white.red = white.green = white.blue = 0xFFFF;
	
	if ( IsColorGrafPort( curPort ) )
	{
		RGBForeColor( &black );
		RGBBackColor( &white );
	}
	PenNormal();
	BackPat( &whitePat );
	TextMode( srcOr );
}

	Boolean
IsColorGrafPort(GrafPtr thePort)
{
	return( (thePort->portBits.rowBytes & 0xC000) == 0xC000 );
}

