/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPGAPopupButtonImp.cp,v 1.1.18.1 1998/11/12 03:19:13 heller Exp $
____________________________________________________________________________*/

#include <UDrawingState.h>
#include <UTextTraits.h>

#include "CPGPGAPopupButtonImp.h"


CPGPGAPopupButtonImp::CPGPGAPopupButtonImp(LControlPane *inControlPane)
		: LGAPopupButtonImp( inControlPane )
{
}

CPGPGAPopupButtonImp::CPGPGAPopupButtonImp(LStream *inStream)
		: LGAPopupButtonImp( inStream )
{
}

CPGPGAPopupButtonImp::~CPGPGAPopupButtonImp(void)
{
}

	void
CPGPGAPopupButtonImp::SetDescriptor(ConstStringPtr inDescriptor)
{
	LGAPopupButtonImp::SetDescriptor( inDescriptor );

	// Stupid PP does not support dynamically changing the popup's title.
	// Recompute the width here and call SetLabelWidth().
	
	if( HasLabel() )
	{
		StTextState		theTextState;
		StColorPenState	thePenState;
	
		// Get the port setup with the text traits
		UTextTraits::SetPortTextTraits ( GetTextTraitsID() );
		SetLabelWidth( StringWidth( inDescriptor ) + 5 );
	}
}
