/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPOpenPrefs.cp,v 1.15.8.1 1998/11/12 03:09:47 heller Exp $
____________________________________________________________________________*/

#include <TextUtils.h>

#include "PGPOpenPrefs.h"

#include "MacErrors.h"
#include "MacFiles.h"
#include "pgpClientPrefs.h"
#include "pgpAdminPrefs.h"
#include "pgpSDKPrefs.h"
#include "pgpFileSpec.h"
#include "CComboError.h"
#include "pgpClientErrors.h"

const ResID		kPrefsNameListID			=	14444;
const short		kClientPrefsFilenameStrIndex=	1;


	PGPError
PGPOpenClientPrefs(
	PGPMemoryMgrRef	memoryMgr,
	PGPPrefRef		*prefRef)
{
	CComboError		err;
	FSSpec			fsSpec;
	Boolean			created = FALSE;
	
	PGPValidatePtr( prefRef );
	*prefRef	= NULL;
	
	err.err = FindPGPPreferencesFolder(-1, &fsSpec.vRefNum, &fsSpec.parID);
	if ( err.IsntError() )
	{
		PFLFileSpecRef	fsRef	= NULL;
		
		GetIndString( fsSpec.name, kPrefsNameListID,
					kClientPrefsFilenameStrIndex);
		pgpAssert( fsSpec.name[0] != 0 );
		
		/* create it if it doesn't already exist */
		if ( ! FSpExists( &fsSpec ) )
		{
			err.err	= FSpCreate( &fsSpec, 'pgpK', 'pref', smSystemScript );
			created = TRUE;
		}
		
		if ( err.IsntError() )
			err.pgpErr	= PFLNewFileSpecFromFSSpec( memoryMgr, &fsSpec, &fsRef);
			
		if ( err.IsntError() )
		{
			err.pgpErr = PGPOpenPrefFile(fsRef, clientDefaults, 
							clientDefaultsSize, prefRef);
			
			PFLFreeFileSpec( fsRef );
		}
	}
	
	return( err.ConvertToPGPError() );
}

	PGPError
PGPGetGroupsFileFSSpec(FSSpec *fileSpec)
{
	PGPError		err;
	PGPContextRef	context;
	
	PGPValidatePtr( fileSpec );

	err = PGPNewContext( kPGPsdkAPIVersion, &context );
	if( IsntPGPError( err ) )
	{
		err = PGPsdkLoadDefaultPrefs( context );
		if( IsntPGPError( err ) )
		{
			PGPFileSpecRef	fileSpecRef;
		
			err = PGPsdkPrefGetFileSpec( context, kPGPsdkPref_GroupsFile,
						&fileSpecRef );
			if( IsntPGPError( err ) )
			{
				err = PGPGetFSSpecFromFileSpec( fileSpecRef, fileSpec );
				
				PGPFreeFileSpec( fileSpecRef );
			}
		}
		
		PGPFreeContext( context );
	}
	
	return( err );
}

