/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CWindowRefArray.cp,v 1.2.20.1 1998/11/12 03:10:39 heller Exp $
____________________________________________________________________________*/

#include "CWindowRefArray.h"



CWindowRefArray::CWindowRefArray()
	: LArray(sizeof(SWindowRef))
{
}



CWindowRefArray::~CWindowRefArray()
{
}



	ArrayIndexT
CWindowRefArray::FetchIndexOfWindowRef(
	const WindowRef	inWindowRef)
{
	SWindowRef	theItem = {inWindowRef, nil};
	
	SetComparator(new CWindowRefComparator);
	return FetchIndexOf(&theItem, sizeof(SWindowRef));
}



	ArrayIndexT
CWindowRefArray::FetchIndexOfGrafPortView(
	const LGrafPortView *	inGrafPortView)
{
	SWindowRef	theItem = {nil, const_cast<LGrafPortView *>(inGrafPortView)};
	
	SetComparator(new CGrafPortViewComparator);
	return FetchIndexOf(&theItem, sizeof(SWindowRef));
}
