/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CSetMenuBarPatcher.cp,v 1.3.8.1 1998/11/12 03:10:22 heller Exp $
____________________________________________________________________________*/

#include <SetupA4.h>

#include "CSetMenuBarPatcher.h"



// Define statics
CSetMenuBarPatcher *	CSetMenuBarPatcher::sSetMenuBarPatcher = nil;

CSetMenuBarPatcher::CSetMenuBarPatcher()
{
	// Current version will only install one patch
	if (sSetMenuBarPatcher == nil) {
		Patch(_SetMenuBar, kProcInfo, (ProcPtr) SetMenuBarCallback);
		sSetMenuBarPatcher = this;
	}
}



CSetMenuBarPatcher::~CSetMenuBarPatcher()
{
}



void
CSetMenuBarPatcher::NewSetMenuBar(
	Handle	menuList)
{
	// default just calls through to the original
	OldSetMenuBar(menuList);
}



void
CSetMenuBarPatcher::OldSetMenuBar(
	Handle	menuList)
{
#if TARGET_RT_MAC_CFM
	::CallUniversalProc(	mOldRoutine,
							kProcInfo,
							menuList);
#else
	((SetMenuBarProc) mOldRoutine)(menuList);
#endif
}



pascal void
CSetMenuBarPatcher::SetMenuBarCallback(
	Handle	menuList)
{
	EnterCallback();

	try {
		sSetMenuBarPatcher->NewSetMenuBar(menuList);
	}
	
	catch(...) {
	}
	
	ExitCallback();
}
