/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CGetKeysPatcher.cp,v 1.3.8.1 1998/11/12 03:10:13 heller Exp $
____________________________________________________________________________*/

#include <SetupA4.h>

#include "CGetKeysPatcher.h"



// Define statics
CGetKeysPatcher *	CGetKeysPatcher::sGetKeysPatcher = nil;

CGetKeysPatcher::CGetKeysPatcher()
{
	// Current version will only install one patch
	if (sGetKeysPatcher == nil) {
		Patch(_GetKeys, kProcInfo, (ProcPtr) GetKeysCallback);
		sGetKeysPatcher = this;
	}
}



CGetKeysPatcher::~CGetKeysPatcher()
{
}



	void
CGetKeysPatcher::NewGetKeys(
	KeyMap	theKeys)
{
	// default just calls through to the original
	OldGetKeys(theKeys);
}



	void
CGetKeysPatcher::OldGetKeys(
	KeyMap	theKeys)
{
#if TARGET_RT_MAC_CFM
	::CallUniversalProc(	mOldRoutine,
							kProcInfo,
							theKeys);
#else
	((GetKeysProc) mOldRoutine)(theKeys);
#endif
}



	pascal void
CGetKeysPatcher::GetKeysCallback(
	KeyMap	theKeys)
{
	EnterCallback();

	try {
		sGetKeysPatcher->NewGetKeys(theKeys);
	}
	
	catch(...) {
	}
	
	ExitCallback();
}
