/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: CPGPtoolsBufferTask.h,v 1.10.8.1 1998/11/12 03:09:04 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPtoolsCryptoTask.h"

class CPGPtoolsBufferTask : public CPGPtoolsCryptoTask
{
public:
						CPGPtoolsBufferTask(PGPtoolsOperation operation);
	virtual				~CPGPtoolsBufferTask(void);
							
	virtual	OSStatus	CalcProgressBytes(PGPContextRef context,
							ByteCount *bytes);
	virtual CToolsError	DecryptVerify(PGPContextRef	context,
								PGPtlsContextRef tlsContext,
								CDecodeParams *state);
	virtual	CToolsError	EncryptSign(PGPContextRef context,
								PGPtlsContextRef tlsContext,
								CEncodeParams *state);
	PGPError			SetText(PGPByte *text, PGPSize textLength);

protected:

	void				*mText;
	PGPSize				mTextLength;

	virtual	CToolsError	ProcessOutputData(void) = 0;
};