/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CmenuPutScrapPatch.cp,v 1.2.14.1.2.1 1998/11/12 03:08:41 heller Exp $
____________________________________________________________________________*/

#include "CCopyPasteHack.h"
#include "StSaveCurResFile.h"

#include "CmenuPutScrapPatch.h"



CmenuPutScrapPatch::CmenuPutScrapPatch(
	SGlobals &	inGlobals)
		: mGlobals(inGlobals)
{
}



CmenuPutScrapPatch::~CmenuPutScrapPatch()
{
}



	long
CmenuPutScrapPatch::NewPutScrap(
	long	length,
	ResType	theType,
	void *	source)
{
	SInt32			result;
	Boolean			callThrough = true;
	
	try {
		if (CCopyPasteHack::GetCopyPasteHack() != nil) {
			StMungeDialogs		munge(&mGlobals);
			StSaveCurResFile	saveResFile;
			LFile				thePlugFile(mGlobals.plugSpec);	
			
			thePlugFile.OpenResourceFork(fsRdPerm);
			if (CCopyPasteHack::GetCopyPasteHack()->PutScrap(length,
			theType, source)) {
				result = noErr;
				callThrough = false;
			}
			thePlugFile.CloseResourceFork();
		}
	}
	
	catch (...) {
	}
	
	if (callThrough) {
		result = OldPutScrap(	length,
								theType,
								source);
	}
	
	return result;
}
