/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CSendKeyShares.cp,v 1.22.8.1 1998/11/12 03:08:16 heller Exp $
____________________________________________________________________________*/
#include <LEditText.h>
#include <UDesktop.h>
#include <URegistrar.h>
#include <UDrawingUtils.h>
#include <PP_Messages.h>
#include <LSimpleThread.h>
#include <Threads.h>
#include <string.h>

#include "CSendKeyShares.h"

#include "CKeyTable.h"
#include "CPGPKeys.h"

#include "pgpClientLib.h"
#include "pgpFileSpec.h"
#include "pgpSKEP.h"
#include "pgpShareFile.h"
#include "pgpShare.h"
#include "pgpUserInterface.h"
#include "CComboError.h"
#include "CSecureMemory.h"
#include "CWarningAlert.h"
#include "MacStrings.h"

#include "pgpMem.h"
#include "pgpErrors.h"


const ResIDT	window_SendKeyShares		= 153;

enum	{
			kStringListID		= 1023,
			kSharePhraseStringID = 1,
			kAuthPhraseStringID,
			kSKEPConnectedStringID,
			kSKEPAuthenticatedStringID,
			kSKEPSendingStringID,
			kSKEPCloseStringID,
			kConnectingStringID,
			kDoneStringID,
			kRemoteKeyConfirmID,
			kSelectShareFileID,
			kSelectShareTitleID
		};

static void SKEPThreadProc(LThread& thread, void *arg);

CSendKeyShares::CSendKeyShares(LStream *inStream)
	:	LGADialog(inStream)
{
	mShares		= NULL;
	mSending	= FALSE;
	mAbort		= FALSE;
	mFinished	= FALSE;
}

CSendKeyShares::~CSendKeyShares()
{
	if( IsntNull( mShares ) )
		PGPFreeShares( mShares );
}

	void
CSendKeyShares::FinishCreateSelf()
{
	LGADialog::FinishCreateSelf();
	
	mSendButton = (LPushButton *)FindPaneByID( kSendSharesButton );
	mStatusText = (LStaticText *)FindPaneByID( kStatusText );
	mAuthText	= (LStaticText *)FindPaneByID( kAuthenticatedText );
	
	SwitchTarget( (LEditText *) FindPaneByID( kRemoteAddressField ) );
	
	Show();
}

	PGPError
CSendKeyShares::SKEPHandler1(
	PGPskepEvent		*event )
{
	PGPError	err = kPGPError_NoErr;
	Str255		pstr = "\p";
	Boolean		noString = FALSE;
	
	if( mAbort )
		err = kPGPError_UserAbort;
	else switch( event->type )
	{
		case kPGPskepEvent_ConnectEvent:
			GetIndString( pstr, kStringListID, kSKEPConnectedStringID );
			break;
		case kPGPskepEvent_AuthenticateEvent:
		{
			Str255	pstr2;
			char	cstr[256];
			PGPSize	nameSize;
			
			err = PGPGetPrimaryUserIDNameBuffer( event->data.ad.remoteKey,
						sizeof(cstr), cstr, &nameSize );
			if( IsPGPError( err ) )
				break;
			CToPString( cstr, pstr2 );
			mAuthText->SetDescriptor( pstr2 );
			GetIndString( pstr2, kStringListID, kRemoteKeyConfirmID );
			PToCString( pstr2, cstr );
			err = PGPConfirmRemoteKeyDialog( cstr, mRemoteAddress,
					event->data.ad.remoteKey,
					event->data.ad.tlsCipher, TRUE );
			if( IsPGPError( err ) )
				break;
			GetIndString( pstr, kStringListID, kSKEPAuthenticatedStringID );
			break;
		}
		case kPGPskepEvent_ProgressEvent:
			GetIndString( pstr, kStringListID, kSKEPSendingStringID );
			break;
		case kPGPskepEvent_CloseEvent:
			GetIndString( pstr, kStringListID, kSKEPCloseStringID );
			break;
		case kPGPskepEvent_NullEvent:
			LThread::Yield();
			noString = TRUE;
			break;
	}
	if( !noString )
		mStatusText->SetDescriptor( pstr );
	return err;
}

	PGPError
CSendKeyShares::SKEPHandler(
	PGPskepRef			skepRef,
	PGPskepEvent		*event,
	PGPUserValue		userValue )
{
	return ( (CSendKeyShares *)userValue )->SKEPHandler1( event );
}

	void
CSendKeyShares::SpendTime(const EventRecord	&inMacEvent)
{
	if( !mSending )
	{
		StopRepeating();
		if( !mFinished )
		{
			mStatusText->SetDescriptor( "\p" );
			mAuthText->SetDescriptor( "\p" );
		}
		else
		{
			Str255	pstr;
			
			GetIndString( pstr, kStringListID, kDoneStringID );
			mSendButton->SetDescriptor( pstr );
			( (LPushButton *)FindPaneByID( kCancelButton ) )->Disable();
		}
		mSendButton->Enable();
	}
	LThread::Yield();
}

	void
CSendKeyShares::SendSharesThread()
{
	Str255		pstr;
	PGPError	err = kPGPError_NoErr;
	PGPskepRef	skepRef;
			
	GetIndString( pstr, kStringListID, kConnectingStringID );
	mStatusText->SetDescriptor( pstr );
	( (LEditText *)FindPaneByID( kRemoteAddressField ) )->
		GetDescriptor( pstr );
	PToCString( pstr, mRemoteAddress );
	err = PGPNewSKEP( gPGPContext, gTLSContext, &skepRef );
	if( IsntPGPError( err ) )
	{
		err = PGPskepSetEventHandler( skepRef,
					CSendKeyShares::SKEPHandler, this );
		if( IsntPGPError( err ) )
		{
			err = PGPskepSendShares( skepRef, mAuthKey,
							mAuthPhrase, mShares, mRemoteAddress );
		}
		PGPFreeSKEP( skepRef );
	}
	if( IsPGPError( err ) )
		ReportPGPError( err );
	else
		mFinished = TRUE;
	mSending = mAbort = FALSE;
}

	void
SKEPThreadProc(LThread& thread, void *arg)
{
	CSendKeyShares *sksWindow = (CSendKeyShares *)arg;
	
	sksWindow->SendSharesThread();
}

	void
CSendKeyShares::ListenToMessage(	MessageT	inMessage,
									void *		ioParam)
{
	switch(inMessage)
	{
		case msg_OK:
		{
			if( !mFinished )
			{
				mSending = TRUE;
				mSendButton->Disable();

				mSKEPThread = new LSimpleThread( SKEPThreadProc, this );
				mSKEPThread->Resume();
				StartRepeating();
				break;
			}
		}
		case msg_Cancel:
			if( mSending )
				mAbort = TRUE;
			else
				delete this;
			break;
	}
}

	void
CSendKeyShares::SetShareInfo(
	PGPShareRef			shares,
	char				*name,
	PGPUInt32			numShares,
	PGPKeyRef			authKey,
	char const			*passphrase )
{
	mShares		= shares;
	mNumShares	= numShares;
	mAuthKey	= authKey;
	CopyCString( passphrase, mAuthPhrase );
	CToPString( name, mName );
	
	( (LStaticText *)FindPaneByID( kShareNameText ) )->
		SetDescriptor( mName );
	( (LStaticText *)FindPaneByID( kNumSharesText ) )->
		SetValue( mNumShares );
	
	Show();
}

typedef struct DecryptSharesData
{
	PGPKeySetRef		recipientSet;
	PGPKeyID			*keyIDList;
	PGPUInt32			keyIDCount;
	PGPBoolean			conventional;
	PGPKeyRef			ownerKey;
	CSecureCString256	passphrase;
} DecryptSharesData;

	PGPError
CSendKeyShares::DecryptSharesHandler(
	PGPContextRef		context,
	PGPEvent			*event,
	void				*userValue)
{
	PGPError			err = kPGPError_NoErr;
	DecryptSharesData	*dsd;
	
	dsd = (DecryptSharesData *) userValue;
	switch( event->type )
	{
		case kPGPEvent_PassphraseEvent:
		{
			Str255		pstr;
			char		cstr[256];
			char		*passphrase = NULL;
			
			GetIndString( pstr, kStringListID, kSharePhraseStringID );
			PToCString( pstr, cstr );

			if( event->data.passphraseData.fConventional )
			{
				err = PGPConventionalDecryptionPassphraseDialog( gPGPContext,
						PGPOUIDialogPrompt( gPGPContext, cstr ),
						PGPOUIOutputPassphrase( gPGPContext, &passphrase ),
						PGPOLastOption( gPGPContext ) );
				dsd->conventional = TRUE;
			}
			else
			{
				PGPKeySetRef	newKeys;
				
				err = PGPClientDecryptionPassphraseDialog( gPGPContext,
						gTLSContext, cstr,
						dsd->recipientSet, dsd->keyIDList, dsd->keyIDCount,
						kInvalidPGPOptionListRef, &passphrase,
						&dsd->ownerKey, &newKeys );
						
				pgpFixBeforeShip( "Handle new kaey" );
				
				if( PGPKeySetRefIsValid( newKeys ) )
					PGPFreeKeySet( newKeys );
			}
			if( IsntPGPError( err ) )
			{
				CopyCString( passphrase, dsd->passphrase );
				PGPFreeData( passphrase );
				
				err = PGPAddJobOptions( event->job,
							PGPOPassphrase( gPGPContext, dsd->passphrase ),
							PGPOLastOption( gPGPContext ) );
			}
			break;
		}
		case kPGPEvent_RecipientsEvent:
		{	
			dsd->recipientSet = event->data.recipientsData.recipientSet;
			if( PGPKeySetRefIsValid( dsd->recipientSet ) )
			{
				err = PGPIncKeySetRefCount( dsd->recipientSet );
			}

			if( IsntPGPError( err ) &&
				IsntNull( event->data.recipientsData.keyIDArray ) )
			{
				PGPSize	dataSize;
				
				dsd->keyIDCount 	= event->data.recipientsData.keyCount;
				dataSize			= dsd->keyIDCount * sizeof( PGPKeyID );
				
				dsd->keyIDList = (PGPKeyID *) PGPNewData(
									PGPGetContextMemoryMgr( context ),
									dataSize, 0 );
				if( IsntNull( dsd->keyIDList ) )
				{
					pgpCopyMemory( event->data.recipientsData.keyIDArray,
							dsd->keyIDList, dataSize );
				}
				else
				{
					err = kPGPError_OutOfMemory;
				}
			}
			
			break;
		}
	}
	return err;
}

	void
CSendKeyShares::SendKeyShares(
	FSSpec *				inFSSpec )
{
	PGPError				err = kPGPError_NoErr;
	FSSpec					fsSpec;
	SFTypeList				typeList;
	PFLFileSpecRef			fsRef	= NULL;
	PGPShareFileRef			sfRef	= NULL;
	PGPShareRef				shares	= NULL;
	PGPOptionListRef		decodeOpt = kInvalidPGPOptionListRef;
	DecryptSharesData		dsd;

	dsd.recipientSet	= kInvalidPGPKeySetRef;
	dsd.keyIDList 		= NULL;
	dsd.keyIDCount 		= 0;
	dsd.conventional	= FALSE;
	dsd.ownerKey		= kInvalidPGPKeyRef;
	typeList[0] = kPGPMacFileCreator_SplitKey;
	
	if( IsntNull( inFSSpec ) )
		pgpCopyMemory( inFSSpec, &fsSpec, sizeof(FSSpec) );
	
	if( IsntNull( inFSSpec ) ||
		CustomGetFileWithShowAll( 1, typeList, &fsSpec ) )
	{
		CSendKeyShares		*sksDialog;
		char				name[256];
		PGPUInt32			numShares = 0;
		PGPSize				nameSize = 0;
		
		err = PFLNewFileSpecFromFSSpec( gPGPMemoryMgr, &fsSpec, &fsRef );
		if( IsPGPError( err ) )
			goto done;
		err = PGPOpenShareFile( fsRef, &sfRef );
		if( IsPGPError( err ) )
			goto done;
		err = PGPGetShareFileUserID( sfRef, sizeof(name), name, &nameSize );
		if( IsPGPError( err ) )
			goto done;
		numShares = PGPGetNumSharesInFile( sfRef );
		err = PGPBuildOptionList( gPGPContext, &decodeOpt,
				PGPOKeySetRef( gPGPContext, CPGPKeys::TheApp()->GetKeySet() ),
				PGPOEventHandler( gPGPContext, DecryptSharesHandler, &dsd ),
				PGPOLastOption( gPGPContext ) );
		if( IsPGPError( err ) )
			goto done;
		err = PGPCopySharesFromFile( gPGPContext, sfRef, decodeOpt, &shares );
		if( IsPGPError( err ) )
			goto done;
		if( dsd.conventional )
		{
			Str255		pstr;
			char		cstr[256];
			char		*passphrase = NULL;
			
			GetIndString( pstr, kStringListID, kAuthPhraseStringID );
			PToCString( pstr, cstr );
			err = PGPSigningPassphraseDialog( gPGPContext,
						CPGPKeys::TheApp()->GetKeySet(),
						&dsd.ownerKey,
						PGPOUIDialogPrompt( gPGPContext, cstr ),
						PGPOUIOutputPassphrase( gPGPContext, &passphrase ),
						PGPOLastOption( gPGPContext ) );
			if( IsPGPError( err ) )
				goto done;
				
			CopyCString( passphrase, dsd.passphrase );
			PGPFreeData( passphrase );
		}
		
		RegisterClass_( CSendKeyShares );	
		sksDialog = (CSendKeyShares *)
			LWindow::CreateWindow( window_SendKeyShares, CPGPKeys::TheApp() );
		sksDialog->SetShareInfo( shares, name, numShares,
									dsd.ownerKey, dsd.passphrase );
		shares = NULL;
	}
done:
	if( IsntNull( shares ) )
		PGPFreeShares( shares );
	if( PGPOptionListRefIsValid( decodeOpt ) )
		PGPFreeOptionList( decodeOpt );
	if( IsntNull( sfRef ) )
		PGPFreeShareFile( sfRef );
	if( IsntNull( fsRef ) )
		PFLFreeFileSpec( fsRef );
	if( IsPGPError( err ) && ( err != kPGPError_UserAbort ) )
		ReportPGPError( err );
	if( PGPKeySetRefIsValid( dsd.recipientSet ) )
		PGPFreeKeySet( dsd.recipientSet );
	if( IsntNull( dsd.keyIDList ) )
		PGPFreeData( dsd.keyIDList );
	return;
}

	void
CSendKeyShares::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	outEnabled = false;
}

