/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CFingerprintField.h,v 1.3.8.1 1998/11/12 03:07:53 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LCommander.h>

#include "CRecessedCaption.h"

class CFingerprintField :	public CRecessedCaption,
							public LCommander
{
public:
	enum { class_ID = 'Fing' };
	static CFingerprintField * CreateFromStream(LStream * inStream);

						CFingerprintField();
						CFingerprintField(
							const CFingerprintField & inOriginal );
						CFingerprintField(	LStream * inStream );

	virtual Boolean		ObeyCommand(
								CommandT			inCommand,
								void *				ioParam);
	virtual void		FindCommandStatus(
								CommandT			inCommand,
								Boolean &			outEnabled,
								Boolean &			outUsesMark,
								Char16 &			outMark,
								Str255				outName);
	virtual void		DrawSelf();
	virtual void		FinishCreateSelf();
	virtual void		ClickSelf(
							const SMouseDownEvent & inMouseDown);
	virtual void		AdjustCursorSelf(
							Point				inPortPt,
							const EventRecord &	inMacEvent);
	virtual void		BeTarget();
	virtual void		DontBeTarget();
	
protected:
	virtual void		DrawBackground(	const Rect & localFrame);
	virtual void		DrawBox(		const Rect & localFrame);
	virtual void		DrawText(		const Rect & localFrame);
};

