/*____________________________________________________________________________
	CTranslator.h
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CTranslator.h,v 1.19.2.1.2.1 1998/11/12 03:06:36 heller Exp $
____________________________________________________________________________*/
#pragma once


#include "EudoraTypes.h"
#include "MacStrings.h"
#include "PGPPlugTypes.h"
#include "TranslatorIDs.h"
#include "CComboError.h"
#include "pgpKeys.h"
#include "pgpClientLib.h"
#include "MacSecureMemory.h"

#define InitPtrToNil( p )	{ if ( IsntNull( p ) )	*(p) = nil; }

			
typedef enum
{
	kUsePGPMIME = 3,	// arbitrary
	kUseOldPGPFormat
} CipherOutputType;
	
struct PGPKeySpec;

#include "PassphraseCache.h"
#include "pgpEncode.h"
#include "SignatureStatusMessage.h"

class CTranslator
{
public:

	PGPContextRef		mContext;
	PGPtlsContextRef	mTLSContext;
	PGPKeySetRef		mKeySet;

	class EventHandlerData
	{
	public:
		enum { kMagic = 'EHND' };
		ulong			mMagic;
		CTranslator *	mTranslator;
							
	protected:
		EventHandlerData( CTranslator *translator )
		{
			pgpAssert( IsntNull( translator ) );
			mMagic			= kMagic;
			mTranslator	 	= translator;
		}
	};
	
	class EncryptSignEventHandlerData : public EventHandlerData
	{
	public:
		PGPKeyRef		mLastKey;
		
		EncryptSignEventHandlerData( CTranslator *translator )
			: EventHandlerData( translator )
		{
			mLastKey		= kInvalidPGPKeyRef;
		}
		
	};
	
	class DecryptVerifyEventHandlerData : public EventHandlerData
	{
	public:
		Boolean					mHaveSignatureData;
		SignatureStatusInfo		mSignatureData;
		Boolean					mTriedCachedPassphrase;
		short					mOutputFileRef;
		char *					mFYEOData;
		
		PGPClientDecodeEventHandlerData		mClientHandlerData;
		
		DecryptVerifyEventHandlerData( CTranslator *translator )
			: EventHandlerData( translator )
		{
			PGPError	err;
			
			mHaveSignatureData		= FALSE;
			mTriedCachedPassphrase	= FALSE;
			mOutputFileRef			= -1;
			mFYEOData				= nil;
			
			err = PGPInitClientDecodeEventHandlerData(
						translator->mContext,
						translator->mTLSContext,
						translator->mKeySet,
						&mClientHandlerData );
			pgpAssertNoErr( err );
		}
		
		virtual ~DecryptVerifyEventHandlerData( void )
		{
			PGPCleanupClientDecodeEventHandlerData( &mClientHandlerData );
		}
	};
	
protected:
		
	emsProgress		mEudoraProgress;
	
	PGPError		LoadDefaultKeySet( PGPBoolean	writeable );
	
	CComboError		GetSigningPassBuffer(PGPPassBufferRef *passBufferOut,
						PGPKeyRef *signingKeyOut );
				
	CComboError		HandleEncryptSign( const FSSpec *in,
						const FSSpec *out, 
						StringHandle** addressesHandle,
						Boolean doSign, PGPOptionListRef options,
						Boolean isPGPMime );

	static PGPError (sPGPEncodeEventHandler)(PGPContextRef context,
						PGPEvent *event, PGPUserValue userValue);

	static PGPError (sPGPDecodeEventHandler)(PGPContextRef context,
						PGPEvent *event, PGPUserValue userValue);
	
	virtual PGPError	PGPEncodeEventHandler(PGPContextRef context,
							PGPEvent *event,
							EncryptSignEventHandlerData *data );

	virtual PGPError	PGPDecodeEventHandler(PGPContextRef context,
							PGPEvent *event,
							DecryptVerifyEventHandlerData *data );
	
	PGPError			HandleProgressEvent(PGPEvent *event);
	
	
	
	virtual PluginError	CanTranslateMIMEType( long transContext,
							ConstemsMIMETypeHandle mimeType,
							ConstStr255Param type, ConstStr255Param subType,
							ConstStr255Param protocol );
	
	virtual void		GetErrorString( CComboError err, StringPtr msg);
	virtual void		ReportError( CComboError err );
	
public:
				CTranslator(PGPContextRef context, PGPtlsContextRef tlsContext,
					emsProgress progressHook);
	virtual		~CTranslator( void );
	
	static	PluginError	GetInfo(  TranslatorID id,
							long * type, long * subtype, unsigned long * flags,
							StringHandle* trans_desc, Handle * iconHandlePtr);
	
	virtual PluginError	CanTranslate( long ransContext,
						emsMIMEtype **	inMimeTypeHandle,
						const FSSpec *	inFSp, StringHandle** addressesHandle,
						long * aprox_len, StringHandle* errorMessage,
						long * result_code);
	
	/* return TRUE if successful; report any errors */
	virtual CComboError		PrepareToTranslate( void );
						
	virtual PluginError	TranslateFile( long transContext, 
							ConstemsMIMETypeHandle InMIMEtypeHandle,
							const FSSpec * inFSp,
							StringHandle** addressesHandle,
							emsMIMEtype ***	OutMIMEtypeHandlePtr,
							const FSSpec * outFSp,
							StringHandle* returnedMessage,
							StringHandle* errorMessage, long * resultCode);
};
