/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CInterruptLevelTester.h,v 1.2.8.1 1998/11/12 03:06:23 heller Exp $
____________________________________________________________________________*/

#pragma once


class CInterruptLevelTester
	{
public:
		enum IODirection { kNoDirection, kReadDirection, kWriteDirection };
		
protected:
	const OSType	mMagic;
	enum { kMagicValue = 'CDTT' };
	
	typedef struct
		{
		TMTask					tmTask;	// must be first
		CInterruptLevelTester *	thisObject;
		} MyTMTask;
	
	typedef struct MyPB
		{
		union
			{
			ParamBlockRec	pb;
			XIOParam		xpb;
			};
			
		CInterruptLevelTester *		thisObject;
		} MyPB;
		
		short			mFileRefNum;
		Boolean			mTestInProgress;
		Boolean			mAcknowledgeDone;
		IODirection		mIODirection;
		long			mMicrosecondsDelay;
		
		enum { kBufferSize	= 4096 };
		char			mBuffer[ kBufferSize ];
		
		MyPB			mPB;
		MyTMTask		mMyTMTask;
		
		virtual void		HandleIOCompletion( MyPB *myPB );
		static pascal void	sIOCompletion( void );
		virtual void		DoIOFromTimeMgrTask( void )	= 0;
		
		static pascal void	sTimeMgrTask( void );
		virtual void		InstallTimeMgrTask( void );
		
		virtual ulong		DetermineMicrosecondsDelay( short fileRefNum );
		virtual OSErr		Setup( short fileRefNum );
		
	public:
		
					CInterruptLevelTester( void );
		virtual		~CInterruptLevelTester( void );
					
		virtual void	Run( short fileRefNum, IODirection direction );
		virtual void	Stop();
	};
