/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPDiskDRVRHeader.c,v 1.5.8.1 1998/11/12 03:05:43 heller Exp $
____________________________________________________________________________*/
 
#include <DriverGestalt.h>

#include "PGPDiskDRVRMain.h"


#include <A4Stuff.h>
#pragma near_code			// IMPORTANT


/*_________________________________________________________________________
	IMPORTANT NOTE:
	
	This driver uses the library MyCustomCRStartup.Lib.  This library is
	exactly the same as 'MSL CustomCRStartup.Lib'.  However, the CW 11 MSL
	2.1.1 update screwed up this library so that the project options are all
	wrong, creating a library that crashes.
	
	(1)  "Use Unsigned Chars" option was on.  It must be off or the wrong code
	is generated; the code assumes that the type 'char' sign extends.
	(2) A5 relative globals were set up (they should be A4)
	(3) The flags should be defined as follows:
		#define STARTUP		LIBCODE
		#define DRIVER		0
	
	Hopefully they'll have fixed this in CW 12.
_________________________________________________________________________*/

void __Startup__(void);


static pascal OSErr	DRVROpen__( ParamBlockRec * pb, DCtlEntry * dce );


//long	__codereftype__  = '000c';
//short	__maincodexnum__ = 12345;	// resource id used for main code
									// resource segment


asm void __Startup__()
{
	DC.w		dCtlEnableMask | 	\
				dStatEnableMask |	\
				dWritEnableMask | 	\
				dReadEnableMask |	\
				dNeedLockMask |		\
				kmDriverGestaltEnableMask
/*
;
; Next is the the drvrDelay (IM II-188), set only if dNeedTime flag set above
;
*/
	DC.W		5*60								// 5 sec periodic update
/*
;
; Next is the the drvrEMask (IM I-444), which events DA can respond to...
; Must be NIL for drivers, for DA's choose from
;	mouseDown		mouse button down is event 1
;	keyDown			key down is event 3
;	keyUp			key up is event 4
;	autoKey			auto-repeated key is event 5
;	updateEvt		update event
;	activateEvt		activate/deactive event
;

*/
	DC.W		0									// BIL for drivers
/*
;
; Next is the the drvrMenu (IM I-444), Menu ID of DA's menu, or NIL
;
*/
	DC.W		0									// No associated menu
/*
;
; Next are the offsets to the main routines of the driver/DA
;
*/
//Note the addition necessary to get the proper address--the number of bytes 
//from the beginning
	DC.W		daOpen		+ 8					// Open routine
	DC.W		daPrime	 	+ 10				// Prime - unused for DA's
	DC.W		daControl	+ 12				// Control
	DC.W		daStatus	+ 14				// Status - unused for DA's
	DC.W		daClose		+ 16				// Close 

	DC.B		"\p.PGPDisk000" 					// DRVR Name
Padding:
	ds.l 		5			//DAName+32 Pad string out to 32 bytes total

daOpen:
	pea 		DRVROpen__
	bra.s     	start
daPrime:
	pea 		DRVRPrime
	bra.s     	start
daControl:
	pea 		DRVRControl
	bra.s     	start
daStatus:
	pea 		DRVRStatus
	bra.s     	start
daClose:
	pea 		DRVRClose
			
start:
	move.l	  a4,-(sp)	// save data segment pointer 
	movem.l   a0/a1,-(sp)
	clr.w     -(sp)
	move.l    a0,-(sp)
	move.l    a1,-(sp)
	jsr		  SetCurrentA4	// Setup A4 so we can address regular data
	movea.l   0x0016(sp),a0
	jsr       (a0)
	move.w    (sp)+,d0
	movem.l   (sp)+,a0/a1
	move.l	  (sp)+,a4	// restore data segment pointer
	addq.w    #0x4,sp	// get rid of address of function we pushed
	cmp.w	  #1,d0		// main returns 1 if async request cannot be completed
	beq.s	  uncomp
	btst	  #1,struct(IOParam.ioTrap)(a0)	// test if this was an immed TRAP
	bne.s	  end
	move.l	  0x08FC,-(sp)	// JIODone
end:	
	rts
uncomp:	
	moveq	  #0,d0
	rts
	
}


/*_________________________________________________________________________
	Special stub:
	__SetupMainRsrc__ should be called once and only once and must be 
	#pragma near code, so it should remain in this file
_________________________________________________________________________*/

	static pascal OSErr
DRVROpen__(
	ParamBlockRec *	pb,
	DCtlEntry *		dce)
	{
// IMPORTANT: #pragma near_code	 must be on
// near_data must be off (but can't be set via pragma)
#pragma near_code
	static Boolean	sCodeIsSetup	= false;
	
	if ( ! sCodeIsSetup )
		{
		__SetupMainRsrc__( &__Startup__ );
		sCodeIsSetup	= TRUE;
		}
		
	return( DRVROpen( pb, dce ) );
	}
	


		
	
	
	





