/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CipherProcGlue.h,v 1.2.8.1 1998/11/12 03:05:31 heller Exp $
____________________________________________________________________________*/

#pragma once


#ifdef __cplusplus
extern "C" {
#endif

#include "CipherContext.h"

typedef const struct OpaqueCipherProcRef *		CipherProcRef;
const CipherProcRef		kInvalidCipherProcRef	= nil;


OSErr	CipherProc_Load( CipherProcRef *ref );
OSErr	CipherProc_Dispose( CipherProcRef );


OSStatus	CipherProc_CallInitContext( CipherProcRef ref,
					CipherContext * context, const uchar *keyToExpand );

OSStatus	CipherProc_CallVerify( CipherProcRef ref );

OSStatus	CipherProc_CallEncrypt( CipherProcRef ref,
					const CipherContext *context, ItemCount startBlock,
					ItemCount numBlocks, const void *src, void *dest );
			
OSStatus	CipherProc_CallDecrypt( CipherProcRef ref,
					const CipherContext *context, ItemCount startBlock,
					ItemCount numBlocks, const void *src, void *dest );



#ifdef __cplusplus
}
#endif
