/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CSetPassphraseDialog.h,v 1.5.8.1 1998/11/12 03:05:17 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPassphraseDialog.h"

class CPassphraseEdit;
class LProgressBar;

class CSetPassphraseDialog : public CPassphraseDialog
{
public:

	enum { class_ID = 'SPhr' };
	
					CSetPassphraseDialog();
	virtual			~CSetPassphraseDialog();
					CSetPassphraseDialog(LStream *inStream);

	void			ClearPassphraseFields(void);
	Boolean			GetPassphrase(StringPtr passphrase);
	Boolean			GetReadOnlyCheckboxStatus(void);
	Boolean			PassphraseIsConfirmed(void);
	void			ShowReadOnlyCheckbox(Boolean showCheckbox);
	
protected:

	virtual void		FinishCreateSelf(void);
	virtual	void		PassphraseHasChanged(void);
	virtual	void		SetHideTyping(Boolean hideTyping);
	
private:

	CPassphraseEdit 	*mConfirmationFieldObj;
	LProgressBar		*mPassphraseQualityBarObj;
	
	void				UpdatePassphraseQuality(void);
};

OSStatus	DoNewPassphraseDialog(ConstStr255Param diskName,
					StringPtr passphrase);
OSStatus	DoAddPassphraseDialog(ConstStr255Param diskName,
					StringPtr passphrase, Boolean *addReadOnly);
OSStatus	DoSetPassphraseDialog(ConstStr255Param diskName,
					StringPtr passphrase);