/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPDiskApplication.h,v 1.6.2.1.2.1 1998/11/12 03:05:11 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <LApplication.h>
#include <LPeriodical.h>

#include "PGPDiskFileFormat.h"

#if PGPDISK_STANDALONE
typedef struct Personalization
{
	Str255	userName;
	Str255	organization;
	Str255	registationNumber;
} Personalization;
#endif

class CPGPDiskApplication : public LApplication, public LPeriodical
{
public:
						CPGPDiskApplication();

	virtual 			~CPGPDiskApplication();

	virtual void		FindCommandStatus(CommandT inCommand,
								Boolean &outEnabled, Boolean &outUsesMark,
								Char16 &outMark, Str255 outName );
	virtual void		HandleAppleEvent( const AppleEvent &inAppleEvent,
								AppleEvent &outAEReply, AEDesc &outResult,
								Int32 inAENumber );
	virtual Boolean		ObeyCommand(CommandT inCommand, void *ioParam = nil);
	virtual	void		ProcessNextEvent(void);
	virtual void		Run(void);
	virtual void		GetPersonalizationString( StringPtr persStr );
	virtual void		ShowAboutBox(void);
	virtual	void		SpendTime(const EventRecord &inMacEvent);
	
	static CPGPDiskApplication	*mApplication;
	
protected:

	void				DoOpenDocAppleEvent(const AppleEvent &inAppleEvent );
	void				DoOpenFile(const FSSpec *theFile);
	OSStatus			GetExistingPGPDiskFSSpec(FSSpec *fileSpec);
	void				HandleAddPassphrase(void);
	void				HandleChangePassphrase(void);
	void				HandleRemovePassphrase(void);
	void				HandleRemoveAltPassphrases(void);
	CComboError			HandleMountPGPDisk(const FSSpec *inFileSpec);
	void				HandleNewPGPDisk(void);
	virtual void		Initialize(void);
	virtual void		MakeMenuBar(void);
	virtual void		StartUp(void);

#if PGPDISK_PUBLIC_KEY
	void				HandleAddRemovePublicKeys(void);
#endif
	
#if USE_MAC_DEBUG_LEAKS
	// we need to suspend leaks checking for the duration of these things
	// because PowerPlant will never release certain items
	virtual void		MakeModelDirector( void )
							{ 	MacLeaks_Suspend();
								LApplication::MakeModelDirector();
								MacLeaks_Resume(); }
#endif // USE_MAC_DEBUG_LEAKS

#if PGP_DEBUG
	virtual	void		InstallDebugMenu(void);
	virtual	void		DebugMountUnmountTest(void);
	virtual	void		DebugUnmountAllPGPDisks(void);
	virtual	void		DebugFragmentFile(void);
	virtual	void		DebugTemp1(void);
	virtual	void		DebugTemp2(void);
	virtual	void		DebugTemp3(void);
#endif	// PGP_DEBUG

private:

#if PGPDISK_STANDALONE
	Personalization		mPersonalization;
	Boolean				mHavePersonalized;
	
	void				DoPersonalization(void);
#endif
};


