/*******************************************************************************/
/*                                                                             */
/*          ViaCrypt PGP encryption routines used by                           */
/*            the C language toolkit demo program                              */
/*                                                                             */
/*******************************************************************************/

#include "cdemo.h"         /* specific to this program          */

/* Encrypt command, optinally also sign. 
      Prompt user for encryption keys 
      If SignFlag is TRUE, get signing key.
      Call Simple PGP DLL */
void Do_Encrypt(HWND hWnd, HWND hwndEdit, BOOL SignFlag)
{
    char *SelectedList;
    HANDLE hSelectedList;
    int SelectedListLength = 4096;
    int SelectedCount = 0;
    int far *pSelectedCount;
    
    char SignerKeyID[20];
    int SignerKeyIDLength = 20;
    int SignerCount = 0;
    int far *pSignerCount;
    
    long TextLength, EncryptedDataLength;
    HANDLE hBuffer, hEncryptedData;
    void FAR *ptrBuffer;
    unsigned char far *ptrEncryptedData;
    int result;
    unsigned char Buf[256];
    unsigned char far *ptrBuf;      
    

    pSelectedCount = &SelectedCount;
    pSignerCount = &SignerCount;
    *SignerKeyID = '\0';
    ptrBuf = &Buf[0];
    Buf[0] = '\0';
    
    // allocate some memory for recipient list
    hSelectedList = GlobalAlloc(GPTR, (DWORD) SelectedListLength);
    if(!hSelectedList)
    {
        MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else 
        SelectedList = GlobalLock(hSelectedList);


    /* call simple KeySel to get recipient's key */
    
    
    result = SimplePGPKeySel(hWnd,   
                (LPSTR) "Select Keys Used To Encrypt:",
                TRUE,                   // allow multiple selection
                KEYSEL_PUBLIC,          // keyring type 
                (LPSTR) SelectedList,   // upon return will contain selected key IDs
                SelectedListLength,     // length of SelectedList buffer
                pSelectedCount,         // upon return contains number of key selected
                INCLUDE_ONLYKEYIDS,     // IncludeWhat (Key IDs, User IDs, or Both?
                (LPSTR) "",             // NUll search string displays everything
                KEYS_OLD | KEYS_ENCR,   // show dual-function (traditional PGP keys)
                                        // and single-function encrypt-only keys
                (LPSTR) "",             // show all keys
                FALSE,                  // start with 'narrow' formof dlg box
                KEYSEL_SHOW_GROUPS,     // show recipient groups, but do not show
                                        // expired, disabled, or revoked keys
                KEYSEL_DISABLE_SHARED_BUTTONS, // do not display shared button
                (LPSTR) "");            // use default public keyring
                
    if(result)
    {
        wsprintf(Buf,"Key Selection failed, error code %d",result);
        MessageBox(hWnd, Buf, APP_TITLE, MB_OK | MB_ICONSTOP);
    }
        
    if(!SelectedCount)
    {
        MessageBox(hWnd,"Operation aborted: no keys selected", APP_TITLE, MB_OK);
        return;
    }
        
    if(SignFlag)  // if Encrypt & Sign
    {
        SimplePGPKeySel(hWnd,   
                (LPSTR) "Select Signer's Key:",
                FALSE,                  // do not allow multiple selection
                KEYSEL_SECRET,          // keyring type 
                (LPSTR) SignerKeyID,    // upon return will contain signer's key IDs
                SignerKeyIDLength,      // length of SignerKeyID buffer
                pSignerCount,           // upon return contains 1 if no error
                INCLUDE_ONLYKEYIDS,     // IncludeWhat (Key IDs, User IDs, or Both?
                (LPSTR) "",             // NUll search string displays everything
                KEYS_OLD | KEYS_SIGN,   // show dual-function (traditional PGP keys)
                                        // and single-function signature-only keys
                (LPSTR) "",             // show all keys
                FALSE,                  // start with 'narrow' formof dlg box
                0, 
                KEYSEL_DISABLE_SHARED_BUTTONS, // do not display shared button
                (LPSTR) "");            // use default private keyring
                
        if(!SignerCount)
        {
            MessageBox(hWnd,"Operation aborted: no Signer selected", APP_TITLE, MB_OK);
            return;
        }
        // since KeySel returns a string that is formatted differently from that required
        // for the SignerKeyID argument in SimplePGPEncryptBuffer, we must reformat it (skip
        // leading char, drop trailing /n)
        SignerKeyID[strlen(SignerKeyID) - 1] = '\0'; 
    }
    else
        SignerKeyID[1] = '\0';
        

    /* find out how long the text in the edit control is, malloc enough memory to 
       hold it, get the text from the edit control */
    TextLength = GetWindowTextLength(hwndEdit) + 1; // add 1 for null terminating char
    if(!TextLength)
    {
        MessageBox(hWnd, "No text to encrypt", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    
    hBuffer = GlobalAlloc(GPTR, (DWORD) TextLength);
    if(!hBuffer)
    {
        MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else 
    {
        ptrBuffer = GlobalLock(hBuffer);
        if(!GetWindowText(hwndEdit, (LPSTR) ptrBuffer, (int)TextLength))
        {
            MessageBox(hWnd, "Unable to get text from edit control", APP_TITLE, MB_OK|MB_ICONSTOP);
            GlobalUnlock(hBuffer);
            GlobalFree(hBuffer);
            return;
        }
    }
    
    /* malloc a second block of memory for the encrypted copy of the text.  This
       buffer needs to be larger.  While the text will be compressed (making it smaller),
       adding the other ancillary header info and ASCII Armoring may make it larger */
    
    EncryptedDataLength = TextLength * 2;
    if(EncryptedDataLength < 1024)
        EncryptedDataLength = 4096;
    hEncryptedData = GlobalAlloc(GPTR, (DWORD) EncryptedDataLength);
    if(!hEncryptedData)
    {
        MessageBox(hWnd, "Insufficient memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else
        ptrEncryptedData = GlobalLock(hEncryptedData);
    
    
    result = SimplePGPEncryptBuffer(hWnd,
                (LPSTR) ptrBuffer,
                TextLength - 1,             // Don't include trailing null
                (LPSTR) "Text Window",
                (LPSTR) ptrEncryptedData,
                &EncryptedDataLength,
                SignFlag,
                TRUE,                       // Armor = On
                TRUE,                       // Text Mode = On
                FALSE,                      // Use Public key encryption, not IDEA only
                TRUE,                       // Use public keys even if they are untrusted
                (LPSTR) SelectedList,       // recipient key IDs
                (LPSTR) &SignerKeyID[1],    // Signer Key ID
                11,                                                        
                (LPSTR) Buf,                 // No signer passphrase provided, let Simple DLL
                                            // prompt user for it.
                255,
                (LPSTR) Buf,                 // Idea pass phrase not needed
                255,
                (LPSTR) "",                 // use default public keyring
                (LPSTR) "");                // use default private keyring

    if(result)
    {
        wsprintf(Buf,"Encryption failed, error code %d",result);
        MessageBox(hWnd, Buf, APP_TITLE, MB_OK | MB_ICONSTOP);
    }
    else
    {    
        /* null-terminate the encrypted data */
        ptrEncryptedData[EncryptedDataLength ] = '\0';
        
        /* Now put the encrypted text in the edit control */                
        SetWindowText(hwndEdit,ptrEncryptedData);
    }
    
    /* Wipe input text before returning buffers */
    WipeBuf((unsigned char far *)ptrBuffer, TextLength);
    GlobalUnlock(hBuffer);
    GlobalUnlock(hEncryptedData);
    GlobalUnlock(hSelectedList);
    GlobalFree(hBuffer);
    GlobalFree(hEncryptedData);
    GlobalFree(hSelectedList);
    
    return;
}



/* Sign command. 
      get signing key.
      Call Simple PGP DLL */
void Do_Sign(HWND hWnd, HWND hwndEdit)
{
    char SignerKeyID[20];
    int SignerKeyIDLength = 20;
    int SignerCount = 0;
    int far *pSignerCount;
    
    long TextLength, SignedDataLength;
    HANDLE hBuffer, hSignedData;
    void FAR *ptrBuffer;
    unsigned char far *ptrSignedData;
    int result;
    unsigned char Buf[256];
    unsigned char far *ptrBuf;

    pSignerCount = &SignerCount;
    ptrBuf = &Buf[0];
    Buf[0] = '\0';
    
    SimplePGPKeySel(hWnd,   
                (LPSTR) "Select Signer's Key:",
                FALSE,                  // do not allow multiple selection
                KEYSEL_SECRET,         // keyring type 
                (LPSTR) SignerKeyID,    // upon return will contain signer's key IDs
                SignerKeyIDLength,      // length of SignerKeyID buffer
                pSignerCount,           // upon return contains 1 if no error
                INCLUDE_ONLYKEYIDS,     // IncludeWhat (Key IDs, User IDs, or Both?
                (LPSTR) "",             // NUll search string displays everything
                KEYS_OLD | KEYS_SIGN,   // show dual-function (traditional PGP keys)
                                        // and single-function signature-only keys
                (LPSTR) "",             // show all keys
                FALSE,                  // start with 'narrow' formof dlg box
                0, 
                KEYSEL_DISABLE_SHARED_BUTTONS, // do not display shared button
                (LPSTR) "");            // use default private keyring
                
        if(!SignerCount)
        {
            MessageBox(hWnd,"Operation aborted: no Signer selected", APP_TITLE,MB_OK);
            return;
        }
        // since KeySel returns a string that is formatted differently from that required
        // for the SignerKeyID argument in SimplePGPEncryptBuffer, we must reformat it (skip
        // leading char, drop trailing /n)
        SignerKeyID[strlen(SignerKeyID) - 1] = '\0'; 
        

    /* find out how long the text in the edit control is, malloc enough memory to 
       hold it, get the text from the edit control */
    TextLength = GetWindowTextLength(hwndEdit) + 1; // add 1 for null terminating char
    if(!TextLength)
    {
        MessageBox(hWnd, "No text to sign", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    
    hBuffer = GlobalAlloc(GPTR, (DWORD) TextLength);
    if(!hBuffer)
    {
        MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else 
    {
        ptrBuffer = GlobalLock(hBuffer);
        if(!GetWindowText(hwndEdit, (LPSTR) ptrBuffer, (int)TextLength))
        {
            MessageBox(hWnd, "Unable to get text from edit control", APP_TITLE, MB_OK|MB_ICONSTOP);
            GlobalUnlock(hBuffer);
            GlobalFree(hBuffer);
            return;
        }
    }
    
    /* malloc a second block of memory for the signed copy of the text.  This
       buffer needs to be larger. */
    
    SignedDataLength = TextLength * 2;
    if(SignedDataLength < 1024)
        SignedDataLength = 4096;
    hSignedData = GlobalAlloc(GPTR, (DWORD) SignedDataLength);
    if(!hSignedData)
    {
        MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else
        ptrSignedData = GlobalLock(hSignedData);
    
    
    
    result = SimplePGPSignBuffer(
                hWnd,
                (LPSTR) ptrBuffer,
                TextLength - 1,         // don't include training null
                (LPSTR) "Text Window",
                (LPSTR) ptrSignedData,
                &SignedDataLength,
                TRUE,                   // Armor = ON
                TRUE,                   // Textmode = ON
                FALSE,                  // SignatureOnly = OFF
                TRUE,                   // ClearSign = ON
                (LPSTR) &SignerKeyID[1],// Signer's key id
                SignerKeyIDLength,
                (LPSTR) Buf,             // no signer pass phrase, let Simple PGP DLL prompt for it
                255,
                (LPSTR) "");            // use default private keyring

    if(result)
        MessageBox(hWnd, "Signing Failed", APP_TITLE, MB_OK | MB_ICONSTOP);
    
    else
    {
        /* null-terminate the signed data */
        ptrSignedData[SignedDataLength ] = '\0';
        
        /* Now put the encrypted text in the edit control */                
        SetWindowText(hwndEdit,ptrSignedData);
    }
    
    /* Wipe input text before returning buffer */
    WipeBuf((unsigned char far *)ptrBuffer, TextLength);
    GlobalUnlock(hBuffer);
    GlobalUnlock(hSignedData);
    GlobalFree(hBuffer);
    GlobalFree(hSignedData);
    
    return;
}

/* Decrypt command, 
    If Sig_Verify is true, then:
           1. We don't write results to buffer, we wipe them instead
           2. We complain if the input is not signed
           */
void Do_Decrypt(HWND hWnd, HWND hwndEdit, BOOL Sig_Verify)
{
    long TextLength, DecryptedDataLength;
    HANDLE hBuffer, hDecryptedData;
    void FAR *ptrBuffer;
    unsigned char far *ptrDecryptedData;
    int result;
    int SignatureStatus, far *pSignatureStatus;
    char Signer[256];
    int SignerBufLen = 256;
    char SignDate[256];
    int SignDateLen = 256;
    char sbuf[300];
    unsigned char PBuf[256];
    unsigned char far *ptrPBuf;
    
    pSignatureStatus = &SignatureStatus;
    ptrPBuf = &PBuf[0];
    PBuf[0] = '\0';
    


    /* find out how long the text in the edit control is, malloc enough memory to 
       hold it, get the text from the edit control */
    TextLength = GetWindowTextLength(hwndEdit) + 1; // add 1 for null terminating char
    if(!TextLength)
    {
        MessageBox(hWnd, "No text to decrypt", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    
    hBuffer = GlobalAlloc(GPTR, (DWORD) TextLength);
    if(!hBuffer)
    {
        MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else 
    {
        ptrBuffer = GlobalLock(hBuffer);
        if(!GetWindowText(hwndEdit, (LPSTR) ptrBuffer, (int)TextLength))
        {
            MessageBox(hWnd, "Unable to get text from edit control", APP_TITLE, MB_OK|MB_ICONSTOP);
            GlobalUnlock(hBuffer);
            GlobalFree(hBuffer);
            return;
        }
    }
    
    /* malloc a second block of memory for the decrypted copy of the text.  This
       buffer  */
    
    DecryptedDataLength = TextLength * 2;
    if(DecryptedDataLength < 1024)
        DecryptedDataLength = 4096;
    hDecryptedData = GlobalAlloc(GPTR, (DWORD) DecryptedDataLength);
    if(!hDecryptedData)
    {
        MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
    else ptrDecryptedData = GlobalLock(hDecryptedData);
    
    
    result =  SimplePGPReceiveBuffer(
                hWnd,
                (LPSTR) ptrBuffer,
                TextLength,
                (LPSTR) "Text Window",
                (LPSTR) ptrDecryptedData,
                &DecryptedDataLength,
                (LPSTR) PBuf,                 // Let Simple PGP DLL prompt for pass phrase
                255,
                pSignatureStatus,           // upon return contains results of sig check
                (LPSTR) Signer,                        
                SignerBufLen,    
                (LPSTR) SignDate,
                SignDateLen,
//                TRUE,                       // use key even if untrusted
                (LPSTR) "",                 // Use default public keyring
                (LPSTR) "");                // use default private keyring
    

    if(result > 1)
	{
		wsprintf(sbuf, "Decrypt/Verify Signature Failed, error code %d", result);
        MessageBox(hWnd, sbuf, APP_TITLE, MB_OK | MB_ICONSTOP);
	}
    else
    {
        // Signed?
        switch(SignatureStatus)
        {
            case SIGSTS_NOTSIGNED:
                if(Sig_Verify)
                    MessageBox(hWnd,"Data was not signed!", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
                break;
            case SIGSTS_VERIFIED:
			case SIGSTS_VERIFIED_UNTRUSTED:
                wsprintf(sbuf,"Good Signature from %s, made %s", Signer, SignDate);
                MessageBox(hWnd, sbuf, APP_TITLE, MB_OK);
                break;
            case SIGSTS_NOTVERIFIED:
                MessageBox(hWnd,"Data was signed, but you do not have the signer's key.  There is no way to detrmine the signer.",
                        APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
                break;
            case SIGSTS_BADSIG:
                wsprintf(sbuf,"Bad Signature from %s, made %s", Signer, SignDate);
                MessageBox(hWnd, sbuf, APP_TITLE, MB_OK | MB_ICONSTOP);
                break;
        }
        
        /* null-terminate the encrypted data */
        ptrDecryptedData[DecryptedDataLength ] = '\0';  
        
        /* Now put the decrypted text in the edit control */                
        if(!Sig_Verify)
            SetWindowText(hwndEdit,ptrDecryptedData);
    }
    
    /* Wipe out text before returning buffer */
    WipeBuf((unsigned char far *)ptrDecryptedData, TextLength);
    GlobalUnlock(hBuffer);
    GlobalUnlock(hDecryptedData);
    GlobalFree(hBuffer);
    GlobalFree(hDecryptedData);
    
    return;
}


void WipeBuf(unsigned char far *buf, long Length)
{
    long i;
    
    for(i = 0; i < Length; i++)
        buf[i] = 0xaa;
    for(i = 0; i < Length; i++)
        buf[i] = 0x55;
    for(i = 0; i < Length; i++)
        buf[i] = 0x00;
}
