package cryptix.gui;

import java.awt.*;

public class PassphraseDialog extends Dialog
{
    String phrase = "";
    Button OKButton = new Button("OK");
    Button quitButton = new Button("Quit");
    TextField passphrase = new TextField(30);

    public PassphraseDialog(Frame parent)
    {
        super(parent, "Passphrase entry", true);

		setResizable(false);

        // setBackground(Color.lightGray);

        setLayout(new BorderLayout());

        Panel top = new Panel();
        Panel middle = new Panel();
        Panel bottom = new Panel();

        top.setLayout(new BorderLayout());
        top.add("North", new Label("Please enter your passphrase:"));

        middle.setLayout(new BorderLayout());
        passphrase.setEchoCharacter('*');
        middle.add("North", passphrase);

Dimension button_dimension = new Dimension(50, 10);
OKButton.resize(button_dimension);
quitButton.resize(button_dimension);

// Hack - get font from environment
OKButton.setFont(new Font("Helvetica", Font.PLAIN, 14));
quitButton.setFont(new Font("Helvetica", Font.PLAIN, 14));

        bottom.setLayout(new FlowLayout());
		// int button_hgap = 10;
		// int button_vgap = 10;
        // bottom.setLayout(new GridLayout(1, 2, button_hgap, button_vgap));
        bottom.add(OKButton);
        bottom.add(quitButton);

        add("North", top);
        add("Center", middle);
        add("South", bottom);

		pack();
    }

    public boolean action(Event e, Object arg)
    {
		if (e.target == OKButton)
			phrase = passphrase.getText();
		 hide();
		return true;
    }

    public String getPassphrase( )
    {
        return phrase;
    }

    public static void main( String argv[] )
    {
	    MainFrame top = new MainFrame("Passphrase entry (mainframe)");

	    PassphraseDialog test = new PassphraseDialog(top);
		test.show();

	    System.out.println(test.getPassphrase());
		System.exit(-1);
    }
}

private class MainFrame extends Frame
{
	MainFrame(String title)
	{
		super(title);
	}

	public boolean
	handleEvent(Event event)
	{
		if (event.id == Event.WINDOW_DESTROY)
			System.exit(0);

		return super.handleEvent(event);
	}
}
